/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.supports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.model.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.model.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.model.OnEnterRule;
import org.eclipse.tm4e.languageconfiguration.internal.model.RegExPattern;
import org.eclipse.tm4e.languageconfiguration.internal.utils.Strings;

public class OnEnterSupport {
    private static final List<CharacterPair> DEFAULT_BRACKETS = List.of(new CharacterPair("(", ")"), new CharacterPair("{", "}"), new CharacterPair("[", "]"));
    private final List<ProcessedBracketPair> brackets = new ArrayList<ProcessedBracketPair>();
    private final List<OnEnterRule> regExpRules;
    private static final Pattern B_REGEXP = Pattern.compile("\\B");

    public OnEnterSupport(@Nullable List<CharacterPair> brackets, @Nullable List<OnEnterRule> regExpRules) {
        for (CharacterPair charPair : brackets != null ? brackets : DEFAULT_BRACKETS) {
            Pattern openRegExp = OnEnterSupport.createOpenBracketRegExp(charPair.open);
            Pattern closeRegExp = OnEnterSupport.createCloseBracketRegExp(charPair.close);
            if (openRegExp == null || closeRegExp == null) continue;
            this.brackets.add(new ProcessedBracketPair(openRegExp, closeRegExp));
        }
        this.regExpRules = regExpRules != null ? regExpRules : Collections.emptyList();
    }

    public @Nullable EnterAction onEnter(String previousLineText, String beforeEnterText, String afterEnterText) {
        for (OnEnterRule rule : this.regExpRules) {
            RegExPattern previousLinePattern;
            RegExPattern afterTextPattern;
            if (!rule.beforeText.matchesPartially(beforeEnterText) || (afterTextPattern = rule.afterText) != null && !afterTextPattern.matchesPartially(afterEnterText) || (previousLinePattern = rule.previousLineText) != null && !previousLinePattern.matchesPartially(previousLineText)) continue;
            return rule.action;
        }
        if (!beforeEnterText.isEmpty() && !afterEnterText.isEmpty()) {
            for (ProcessedBracketPair bracket : this.brackets) {
                if (!bracket.matchOpen(beforeEnterText) || !bracket.matchClose(afterEnterText)) continue;
                return new EnterAction(EnterAction.IndentAction.IndentOutdent);
            }
        }
        if (!beforeEnterText.isEmpty()) {
            for (ProcessedBracketPair bracket : this.brackets) {
                if (!bracket.matchOpen(beforeEnterText)) continue;
                return new EnterAction(EnterAction.IndentAction.Indent);
            }
        }
        return null;
    }

    private static @Nullable Pattern createOpenBracketRegExp(String bracket) {
        StringBuilder str = new StringBuilder(Strings.escapeRegExpCharacters(bracket));
        String c = String.valueOf(str.charAt(0));
        if (!B_REGEXP.matcher(c).find()) {
            str.insert(0, "\\b");
        }
        str.append("\\s*$");
        return OnEnterSupport.safeRegExp(str);
    }

    private static @Nullable Pattern createCloseBracketRegExp(String bracket) {
        StringBuilder str = new StringBuilder(Strings.escapeRegExpCharacters(bracket));
        String c = String.valueOf(str.charAt(str.length() - 1));
        if (!B_REGEXP.matcher(c).find()) {
            str.append("\\b");
        }
        str.insert(0, "^\\s*");
        return OnEnterSupport.safeRegExp(str);
    }

    private static @Nullable Pattern safeRegExp(CharSequence regex) {
        try {
            return Pattern.compile(regex.toString());
        }
        catch (Exception ex) {
            LanguageConfigurationPlugin.logError("Failed to parse pattern: " + String.valueOf(regex), ex);
            return null;
        }
    }

    private static final class ProcessedBracketPair {
        final Pattern openRegExp;
        final Pattern closeRegExp;

        ProcessedBracketPair(Pattern openRegExp, Pattern closeRegExp) {
            this.openRegExp = openRegExp;
            this.closeRegExp = closeRegExp;
        }

        boolean matchOpen(String beforeEnterText) {
            return this.openRegExp.matcher(beforeEnterText).find();
        }

        boolean matchClose(String afterEnterText) {
            return this.closeRegExp.matcher(afterEnterText).find();
        }
    }
}

