/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.perf.trace;

import java.util.LinkedList;
import java.util.Random;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTraceUtils;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFTraceReader;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.junit.Assert;
import org.junit.Test;

public class TraceSeekBenchmark {
    private static final Random RND = new Random(1000L);
    private static final int LOOP_COUNT = 25;
    private static final int NB_SEEKS = 500;
    private static final String TEST_SUITE_NAME = "CTF Read & Seek Benchmark (500 seeks)";
    private static final String TEST_ID = "org.eclipse.linuxtools#CTF Read & Seek Benchmark (500 seeks)";

    @Test
    public void testKernelTrace() throws CTFException {
        TraceSeekBenchmark.readAndSeekTrace(CtfTestTrace.KERNEL, "trace-kernel", true);
    }

    private static void readAndSeekTrace(CtfTestTrace testTrace, String testName, boolean inGlobalSummary) throws CTFException {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#CTF Read & Seek Benchmark (500 seeks)#" + testName);
        perf.tagAsSummary(pm, "CTF Read & Seek Benchmark (500 seeks):" + testName, Dimension.CPU_TIME);
        if (inGlobalSummary) {
            perf.tagAsGlobalSummary(pm, "CTF Read & Seek Benchmark (500 seeks):" + testName, Dimension.CPU_TIME);
        }
        int loop = 0;
        while (loop < 25) {
            CTFTrace trace = CtfTestTraceUtils.getTrace(testTrace);
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (CTFTraceReader traceReader = new CTFTraceReader(trace);){
                    long startTime;
                    IEventDefinition firstEvent = traceReader.getCurrentEventDef();
                    long endTime = startTime = firstEvent.getTimestamp();
                    while (traceReader.hasMoreEvents()) {
                        IEventDefinition ev = traceReader.getCurrentEventDef();
                        endTime = ev.getTimestamp();
                        traceReader.advance();
                    }
                    LinkedList<Long> seekTimestamps = new LinkedList<Long>();
                    long range = endTime - startTime;
                    int i = 0;
                    while (i < 500) {
                        long delta = RND.nextLong() % range;
                        if (delta < 0L) {
                            delta += range;
                        }
                        seekTimestamps.add(startTime + delta);
                        ++i;
                    }
                    pm.start();
                    for (Long ts : seekTimestamps) {
                        traceReader.seek(ts.longValue());
                        traceReader.advance();
                    }
                    pm.stop();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CTFException e) {
                Assert.fail((String)("Test failed at iteration " + loop + ":" + e.getMessage()));
            }
            ++loop;
        }
        pm.commit();
    }
}

