/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.environment.uri.file;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.internal.environment.eclipse.Messages;
import org.eclipse.wst.common.internal.environment.relative.RelativeScheme;
import org.eclipse.wst.common.internal.environment.relative.RelativeURI;
import org.eclipse.wst.common.internal.environment.uri.file.FileURI;

public class FileScheme
extends RelativeScheme {
    @Override
    public String toString() {
        return "file";
    }

    @Override
    public boolean isValid(IURI uri) {
        boolean result = false;
        if (uri == null) {
            return false;
        }
        IURIScheme scheme = uri.getURIScheme();
        if (scheme.toString().equals("relative")) {
            return scheme.isValid(uri);
        }
        String uriString = uri.toString();
        if (uriString != null && uriString.startsWith("file:")) {
            result = true;
        }
        return result;
    }

    @Override
    public IURI newURI(String uri) throws URIException {
        Object newURI = null;
        if (uri != null && uri.startsWith("file:")) {
            newURI = uri;
        } else {
            if (uri == null || uri.indexOf(":") != -1) {
                throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_INVALID_FILE_URL, (Object)uri), null));
            }
            if (uri.startsWith("/")) {
                newURI = "file:" + uri;
            }
        }
        if (newURI == null) {
            return new RelativeURI(uri);
        }
        return new FileURI((String)newURI);
    }

    @Override
    public IURI newURI(IURI uri) throws URIException {
        return this.newURI(uri == null ? null : uri.toString());
    }

    @Override
    public IURI newURI(URL url) throws URIException {
        return this.newURI(url == null ? null : url.toString());
    }
}

