/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.events.TmfEventTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.events.TmfEventTableFilterModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.EventTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.EventTableLine;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfFilterModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.TmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableCell;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@NonNullByDefault
public class TmfEventTableDataProviderTest {
    private static final TmfTestTrace TEST_TRACE = TmfTestTrace.A_TEST_10K;
    private static ITmfTrace fTrace = new TmfTraceStub();
    private static ITmfVirtualTableDataProvider<ITmfTreeDataModel, EventTableLine> fProvider = new TmfEventTableDataProvider(fTrace);
    private static final String TIMESTAMP_COLUMN_NAME = "Timestamp";
    private static final String TIMESTAMP_NS_COLUMN_NAME = "Timestamp ns";
    private static final String EVENT_TYPE_COLUMN_NAME = "Event type";
    private static final String CONTENTS_COLUMN_NAME = "Contents";
    private static final String NEXT_DIR_UNDER_TEST = "NEXT";
    private static final String PREV_DIR_UNDER_TEST = "PREVIOUS";
    private static final String TYPE_0 = "Type-0";
    private static final String TYPE_1 = "Type-1";
    private static final String TYPE_2 = "Type-2";
    private static final String TYPE_3 = "Type-3";
    private static final String TYPE_4 = "Type-4";
    private static final String TYPE_5 = "Type-5";
    private static final String TYPE_6 = "Type-6";
    private static Map<String, Long> fColumns = Collections.emptyMap();

    @BeforeClass
    public static void beforeClass() throws TmfTraceException {
        fTrace.dispose();
        fTrace = new TmfTraceStub(TEST_TRACE.getFullPath(), 1000, true, null);
        fProvider = new TmfEventTableDataProvider(fTrace);
        fColumns = TmfEventTableDataProviderTest.fetchColumnId();
    }

    private static Map<String, Long> fetchColumnId() {
        List currentColumns = (List)fProvider.fetchColumns(Collections.emptyMap(), null).getModel();
        if (currentColumns == null) {
            return Collections.emptyMap();
        }
        Assert.assertEquals((Object)TIMESTAMP_COLUMN_NAME, (Object)((ITableColumnDescriptor)currentColumns.get(0)).getText());
        Assert.assertEquals((Object)EVENT_TYPE_COLUMN_NAME, (Object)((ITableColumnDescriptor)currentColumns.get(1)).getText());
        Assert.assertEquals((Object)CONTENTS_COLUMN_NAME, (Object)((ITableColumnDescriptor)currentColumns.get(2)).getText());
        Assert.assertEquals((Object)TIMESTAMP_NS_COLUMN_NAME, (Object)((ITableColumnDescriptor)currentColumns.get(3)).getText());
        LinkedHashMap<String, Long> expectedColumns = new LinkedHashMap<String, Long>();
        for (ITableColumnDescriptor column : currentColumns) {
            expectedColumns.put(column.getText(), column.getId());
        }
        return expectedColumns;
    }

    private static String lineTimestamp(long millisecond) {
        String timestamp = TmfTimestamp.fromMillis((long)millisecond).toString();
        if (timestamp == null) {
            timestamp = "";
        }
        return timestamp;
    }

    private static String lineNsTimestamp(int millisecond) {
        return String.valueOf(TmfTimestamp.fromMillis((long)millisecond).toNanos());
    }

    @AfterClass
    public static void tearDown() {
        fTrace.dispose();
    }

    @Test
    public void testDataProviderFetchColumn() {
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long contentsColumnId = fColumns.get(CONTENTS_COLUMN_NAME);
        Long timestampNsColumnId = fColumns.get(TIMESTAMP_NS_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        Assert.assertNotNull((Object)contentsColumnId);
        Assert.assertNotNull((Object)timestampNsColumnId);
        List<ITableColumnDescriptor> expectedColumns = Arrays.asList(new TableColumnDescriptor.Builder().setId(timestampColumnId.longValue()).setText(TIMESTAMP_COLUMN_NAME).setDataType(DataType.TIMESTAMP).build(), new TableColumnDescriptor.Builder().setId(eventTypeColumnId.longValue()).setText(EVENT_TYPE_COLUMN_NAME).setTooltip("The type of this event. This normally determines the field layout.").setDataType(DataType.STRING).build(), new TableColumnDescriptor.Builder().setId(contentsColumnId.longValue()).setText(CONTENTS_COLUMN_NAME).setTooltip("The fields (or payload) of this event").setDataType(DataType.STRING).build(), new TableColumnDescriptor.Builder().setId(timestampNsColumnId.longValue()).setText(TIMESTAMP_NS_COLUMN_NAME).setTooltip("Timestamp in nanoseconds, normalized and useful for calculations").setDataType(DataType.NUMBER).setHiddenByDefault(true).build());
        TmfModelResponse response = fProvider.fetchColumns(Collections.emptyMap(), null);
        List currentColumns = (List)response.getModel();
        Assert.assertNotNull((Object)currentColumns);
        Assert.assertEquals(expectedColumns, (Object)currentColumns);
    }

    @Test
    public void testDataProvider() {
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Collections.emptyList(), 0L, 5, null);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(1L)), new VirtualTableCell(TYPE_0), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(1))), 0L, TmfTimestamp.fromMillis((long)1L), 0L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(2L)), new VirtualTableCell(TYPE_1), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(2))), 1L, TmfTimestamp.fromMillis((long)2L), 1L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(3L)), new VirtualTableCell(TYPE_2), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(3))), 2L, TmfTimestamp.fromMillis((long)3L), 2L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(4L)), new VirtualTableCell(TYPE_3), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(4))), 3L, TmfTimestamp.fromMillis((long)4L), 3L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(5L)), new VirtualTableCell(TYPE_4), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(5))), 4L, TmfTimestamp.fromMillis((long)5L), 4L, 0L));
        TmfModelResponse response = fProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, fTrace.getNbEvents());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithOutOfBoundIndex() {
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Collections.emptyList(), 2000000L, 5, null);
        TmfModelResponse response = fProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        Assert.assertEquals(new ArrayList<Long>(fColumns.values()), (Object)currentModel.getColumnIds());
        Assert.assertTrue((boolean)currentModel.getLines().isEmpty());
    }

    @Test
    public void testDataProviderWithDesiredColumns() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Collections.singletonList(eventTypeColumnId), 5L, 5, null);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_5)), 5L, TmfTimestamp.fromMillis((long)6L), 5L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_6)), 6L, TmfTimestamp.fromMillis((long)7L), 6L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0)), 7L, TmfTimestamp.fromMillis((long)8L), 7L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_1)), 8L, TmfTimestamp.fromMillis((long)9L), 8L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_2)), 9L, TmfTimestamp.fromMillis((long)10L), 9L, 0L));
        TmfModelResponse response = fProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 5L, fTrace.getNbEvents());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithOneNonExistentColumns() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, 10L, timestampColumnId), 150L, 5, null);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_3), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(151L))), 150L, TmfTimestamp.fromMillis((long)151L), 150L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_4), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(152L))), 151L, TmfTimestamp.fromMillis((long)152L), 151L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_5), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(153L))), 152L, TmfTimestamp.fromMillis((long)153L), 152L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_6), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(154L))), 153L, TmfTimestamp.fromMillis((long)154L), 153L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(155L))), 154L, TmfTimestamp.fromMillis((long)155L), 154L, 0L));
        TmfModelResponse response = fProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 150L, fTrace.getNbEvents());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithNonExistentColumns() {
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(10L, 11L), 0L, 10, null);
        TmfModelResponse response = fProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        Assert.assertTrue((boolean)currentModel.getColumnIds().isEmpty());
        Assert.assertTrue((boolean)currentModel.getLines().isEmpty());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithSimpleFilter() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        HashMap<Long, String> tableFilter = new HashMap<Long, String>();
        tableFilter.put(eventTypeColumnId, "1");
        TmfEventTableFilterModel filterModel = new TmfEventTableFilterModel(tableFilter, null, false);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, 5, (ITmfFilterModel)filterModel);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        parameters.put("table_filters", filterModel);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_1), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(2L))), 0L, TmfTimestamp.fromMillis((long)2L), 1L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_1), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(9L))), 1L, TmfTimestamp.fromMillis((long)9L), 8L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_1), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(16L))), 2L, TmfTimestamp.fromMillis((long)16L), 15L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_1), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(23L))), 3L, TmfTimestamp.fromMillis((long)23L), 22L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_1), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(30L))), 4L, TmfTimestamp.fromMillis((long)30L), 29L, 0L));
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 0L, 1429L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithMultipleFilter() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        HashMap<Long, String> tableFilter = new HashMap<Long, String>();
        tableFilter.put(eventTypeColumnId, "0");
        tableFilter.put(timestampColumnId, "8");
        TmfEventTableFilterModel filterModel = new TmfEventTableFilterModel(tableFilter, null, false);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, 5, (ITmfFilterModel)filterModel);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        parameters.put("table_filters", filterModel);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(8L))), 0L, TmfTimestamp.fromMillis((long)8L), 7L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(78L))), 1L, TmfTimestamp.fromMillis((long)78L), 77L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(85L))), 2L, TmfTimestamp.fromMillis((long)85L), 84L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(148L))), 3L, TmfTimestamp.fromMillis((long)148L), 147L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(183L))), 4L, TmfTimestamp.fromMillis((long)183L), 182L, 0L));
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 0L, 492L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithSearchNoMatch() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, 1, null);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchExpressions = new HashMap<Long, String>();
        searchExpressions.put(eventTypeColumnId, "Does not exits");
        parameters.put("table_search_expressions", searchExpressions);
        parameters.put("table_search_direction", NEXT_DIR_UNDER_TEST);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List expectedData = Collections.emptyList();
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        Assert.assertTrue((boolean)currentModel.getLines().isEmpty());
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 0L, 10000L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test
    public void testDataProviderWithSearchTypo() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, 1, null);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchExpressions = new HashMap<Long, String>();
        searchExpressions.put(eventTypeColumnId, "Does not exits");
        parameters.put("table_search_expressions", searchExpressions);
        String typo = "T";
        parameters.put("table_search_direction", NEXT_DIR_UNDER_TEST + typo);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        Assert.assertNull((Object)response.getModel());
        Assert.assertEquals((Object)response.getStatus(), (Object)ITmfResponse.Status.FAILED);
        Assert.assertEquals((Object)response.getStatusMessage(), (Object)CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithSimpleSingleColumnsSearch() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, 1, null);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchExpressions = new HashMap<Long, String>();
        searchExpressions.put(eventTypeColumnId, TYPE_2);
        parameters.put("table_search_expressions", searchExpressions);
        parameters.put("table_search_direction", NEXT_DIR_UNDER_TEST);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_2), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(3L))), 2L, TmfTimestamp.fromMillis((long)3L), 2L, 0L));
        expectedData.get(0).setActiveProperties(8);
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 2L, 10000L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
        int nbEventsRequested = 5;
        queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, nbEventsRequested, null);
        parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        parameters.put("table_search_expressions", searchExpressions);
        response = fProvider.fetchLines(parameters, null);
        currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        Assert.assertEquals((long)nbEventsRequested, (long)currentModel.getLines().size());
        expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_0), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(1L))), 0L, TmfTimestamp.fromMillis((long)1L), 0L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_1), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(2L))), 1L, TmfTimestamp.fromMillis((long)2L), 1L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_2), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(3L))), 2L, TmfTimestamp.fromMillis((long)3L), 2L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_3), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(4L))), 3L, TmfTimestamp.fromMillis((long)4L), 3L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_4), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(5L))), 4L, TmfTimestamp.fromMillis((long)5L), 4L, 0L));
        expectedData.get(2).setActiveProperties(8);
        expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 0L, 10000L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithGetDataFromSearchForwardMatch() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        int nbEventsRequested = 3;
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 0L, nbEventsRequested, null);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchExpressions = new HashMap<Long, String>();
        searchExpressions.put(eventTypeColumnId, TYPE_2);
        parameters.put("table_search_expressions", searchExpressions);
        parameters.put("table_search_direction", NEXT_DIR_UNDER_TEST);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_2), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(3L))), 2L, TmfTimestamp.fromMillis((long)3L), 2L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_3), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(4L))), 3L, TmfTimestamp.fromMillis((long)4L), 3L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_4), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(5L))), 4L, TmfTimestamp.fromMillis((long)5L), 4L, 0L));
        expectedData.get(0).setActiveProperties(8);
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 2L, 10000L);
        Assert.assertNotNull((Object)currentModel);
        Assert.assertEquals((long)nbEventsRequested, (long)currentModel.getLines().size());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithSimpleSingleColumnsIndexBackwardsSearch() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 10L, 1, null);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchExpressions = new HashMap<Long, String>();
        searchExpressions.put(eventTypeColumnId, TYPE_2);
        parameters.put("table_search_expressions", searchExpressions);
        parameters.put("table_search_direction", PREV_DIR_UNDER_TEST);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_2), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(10L))), 9L, TmfTimestamp.fromMillis((long)10L), 9L, 0L));
        expectedData.get(0).setActiveProperties(8);
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 9L, 10000L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithGetDataFromSearchBackwardsMatch() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        int nbEventsRequested = 3;
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(Arrays.asList(eventTypeColumnId, timestampColumnId), 10L, nbEventsRequested, null);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchExpressions = new HashMap<Long, String>();
        searchExpressions.put(eventTypeColumnId, TYPE_2);
        parameters.put("table_search_expressions", searchExpressions);
        parameters.put("table_search_direction", PREV_DIR_UNDER_TEST);
        List<Long> expectedColumnsId = Arrays.asList(eventTypeColumnId, timestampColumnId);
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_2), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(10L))), 9L, TmfTimestamp.fromMillis((long)10L), 9L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_3), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(11L))), 10L, TmfTimestamp.fromMillis((long)11L), 10L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TYPE_4), new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(12L))), 11L, TmfTimestamp.fromMillis((long)12L), 11L, 0L));
        expectedData.get(0).setActiveProperties(8);
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 9L, 10000L);
        Assert.assertNotNull((Object)currentModel);
        Assert.assertEquals((long)nbEventsRequested, (long)currentModel.getLines().size());
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testDataProviderWithSimpleMultiColumnsSearch() {
        Long eventTypeColumnId = fColumns.get(EVENT_TYPE_COLUMN_NAME);
        Long timestampColumnId = fColumns.get(TIMESTAMP_COLUMN_NAME);
        Assert.assertNotNull((Object)timestampColumnId);
        Assert.assertNotNull((Object)eventTypeColumnId);
        EventTableQueryFilter queryFilter = new EventTableQueryFilter(new ArrayList<Long>(fColumns.values()), 0L, 1, null);
        Map parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchExpressions = new HashMap<Long, String>();
        searchExpressions.put(eventTypeColumnId, "T.*3");
        searchExpressions.put(timestampColumnId, "\\d*4\\d*s*");
        parameters.put("table_search_expressions", searchExpressions);
        parameters.put("table_search_direction", NEXT_DIR_UNDER_TEST);
        ArrayList<Long> expectedColumnsId = new ArrayList<Long>(fColumns.values());
        TmfTimestampFormat.getDefaulTimeFormat().format(TmfTimestamp.fromMillis((long)2L).toNanos());
        List<EventTableLine> expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(4L)), new VirtualTableCell(TYPE_3), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(4))), 3L, TmfTimestamp.fromMillis((long)4L), 3L, 0L));
        expectedData.get(0).setActiveProperties(8);
        TmfModelResponse response = fProvider.fetchLines(parameters, null);
        ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 3L, 10000L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
        int nbEventsRequested = 5;
        queryFilter = new EventTableQueryFilter(new ArrayList<Long>(fColumns.values()), 0L, nbEventsRequested, null);
        parameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        parameters.put("table_search_expressions", searchExpressions);
        response = fProvider.fetchLines(parameters, null);
        currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        Assert.assertEquals((long)nbEventsRequested, (long)currentModel.getLines().size());
        expectedData = Arrays.asList(new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(1L)), new VirtualTableCell(TYPE_0), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(1))), 0L, TmfTimestamp.fromMillis((long)1L), 0L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(2L)), new VirtualTableCell(TYPE_1), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(2))), 1L, TmfTimestamp.fromMillis((long)2L), 1L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(3L)), new VirtualTableCell(TYPE_2), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(3))), 2L, TmfTimestamp.fromMillis((long)3L), 2L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(4L)), new VirtualTableCell(TYPE_3), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(4))), 3L, TmfTimestamp.fromMillis((long)4L), 3L, 0L), new EventTableLine(Arrays.asList(new VirtualTableCell(TmfEventTableDataProviderTest.lineTimestamp(5L)), new VirtualTableCell(TYPE_4), new VirtualTableCell(""), new VirtualTableCell(TmfEventTableDataProviderTest.lineNsTimestamp(5))), 4L, TmfTimestamp.fromMillis((long)5L), 4L, 0L));
        expectedData.get(3).setActiveProperties(8);
        expectedModel = new TmfVirtualTableModel(expectedColumnsId, expectedData, 0L, 10000L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryFilterIndexParameter() {
        new EventTableQueryFilter(Collections.emptyList(), -1L, 5, null);
    }
}

