/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests;

import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewSwtBotUtil;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ControlViewKernelFilterTest
extends ControlViewTest {
    private static final String TEST_STREAM = "CreateSessionTestLTTng2_8.cfg";
    private static final String CREATE_SESSION_KERNEL_FILTER_SCENARIO_NAME = "KernelFilter";
    private static final String CREATE_SESSION_KERNEL_FILTER_PROVIDER_SCENARIO_NAME = "KernelFilterProvider";
    private static final String SESSION_NAME = "mysession";
    private static final String FILTER_EXPRESSION = "next_tid==1234";
    private static final String FILTER_EXPRESSION_DISPLAY = "foo > 10";

    @Override
    protected String getTestStream() {
        return TEST_STREAM;
    }

    @Override
    protected String getSessionName() {
        return SESSION_NAME;
    }

    @Override
    @Test
    public void testTraceSessionTree() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_SESSION_KERNEL_FILTER_SCENARIO_NAME);
        this.testCreateSession();
        this.testEnableKernelEvent();
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testDestroySession();
        this.testDisconnectFromNode();
    }

    @Test
    public void testTraceSessionTreeKernelProvider() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_SESSION_KERNEL_FILTER_PROVIDER_SCENARIO_NAME);
        this.testCreateSession();
        this.testEnableKernelFromProviderEvent();
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testDestroySession();
        this.testDisconnectFromNode();
    }

    @Override
    protected void testEnableKernelEvent() {
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup("Select", "Tracepoint Events").click();
        SWTBotTree tracepointsTree = shell.bot().tree();
        SWTBotTreeItem allItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)tracepointsTree, (String[])new String[]{"All"});
        allItem.check();
        SWTBotText filterText = shell.bot().textInGroup("Filter Expression");
        filterText.setText(FILTER_EXPRESSION);
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Kernel", (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem kernelDomainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel"});
        Assert.assertEquals((Object)"Kernel", (Object)kernelDomainItem.getText());
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0"});
        Assert.assertEquals((Object)"channel0", (Object)channelItem.getText());
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0", "*"});
        Assert.assertEquals((Object)"*", (Object)eventItem.getText());
        ITraceControlComponent comp = ControlViewSwtBotUtil.getComponent((ITraceControlComponent)this.fNode, "Sessions", this.getSessionName(), "Kernel", "channel0", "*");
        Assert.assertNotNull((Object)comp);
        Assert.assertTrue((boolean)(comp instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)comp;
        Assert.assertEquals((Object)FILTER_EXPRESSION_DISPLAY, (Object)event.getFilterExpression());
    }

    private void testEnableKernelFromProviderEvent() {
        SWTBotTreeItem kernelProviderEventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Provider", "Kernel", "sched_switch"});
        kernelProviderEventItem.select();
        SWTBotMenu menuBot = kernelProviderEventItem.contextMenu("Enable Event...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        SWTBotCCombo sessionCombo = shell.bot().ccomboBoxInGroup("Session List");
        sessionCombo.setSelection(this.getSessionName());
        SWTBotText filterText = shell.bot().textInGroup("Filter Expression");
        filterText.setText(FILTER_EXPRESSION);
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)"Kernel", (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem kernelDomainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel"});
        Assert.assertEquals((Object)"Kernel", (Object)kernelDomainItem.getText());
        SWTBotTreeItem channelItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0"});
        Assert.assertEquals((Object)"channel0", (Object)channelItem.getText());
        SWTBotTreeItem eventItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), "Kernel", "channel0", "sched_switch"});
        Assert.assertEquals((Object)"sched_switch", (Object)eventItem.getText());
        ITraceControlComponent comp = ControlViewSwtBotUtil.getComponent((ITraceControlComponent)this.fNode, "Sessions", this.getSessionName(), "Kernel", "channel0", "sched_switch");
        Assert.assertNotNull((Object)comp);
        Assert.assertTrue((boolean)(comp instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)comp;
        Assert.assertEquals((Object)FILTER_EXPRESSION_DISPLAY, (Object)event.getFilterExpression());
    }
}

