/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonTraceMetadataNode;
import org.junit.Assert;
import org.junit.Test;

public class JsonTraceMetadataNodeTest {
    @Test
    public void testEnvironmentParsing() throws Exception {
        JsonTraceMetadataNode node = new JsonTraceMetadataNode(null, "trace-class", "test");
        JsonObject environment = new JsonObject();
        environment.addProperty("hostname", "test-host");
        environment.addProperty("domain", "kernel");
        environment.addProperty("tracer_name", "lttng-modules");
        Field envField = JsonTraceMetadataNode.class.getDeclaredField("fEnvironment");
        envField.setAccessible(true);
        envField.set(node, environment);
        node.initialize();
        Assert.assertNotNull((Object)node.getEnvironment());
        Assert.assertEquals((Object)"test-host", (Object)node.getEnvironment().get("hostname").getAsString());
        Assert.assertEquals((Object)"kernel", (Object)node.getEnvironment().get("domain").getAsString());
        Assert.assertEquals((Object)"lttng-modules", (Object)node.getEnvironment().get("tracer_name").getAsString());
    }

    @Test
    public void testUidParsing() throws Exception {
        JsonTraceMetadataNode node = new JsonTraceMetadataNode(null, "trace-class", "test");
        Field uidField = JsonTraceMetadataNode.class.getDeclaredField("fUid");
        uidField.setAccessible(true);
        uidField.set(node, "test-uid-123");
        node.initialize();
        Assert.assertEquals((Object)"test-uid-123", (Object)node.getUid());
    }
}

