/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.scope;

import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.scope.LexicalScope;
import org.junit.Assert;
import org.junit.Test;

public class LexicalScopeTest {
    @Test
    public void testRoot() {
        ILexicalScope scope = ILexicalScope.ROOT;
        Assert.assertNotNull((Object)scope);
    }

    @Test
    public void testComplexNode() {
        ILexicalScope scope = ILexicalScope.STREAM_EVENT_CONTEXT;
        Assert.assertEquals((Object)"context", (Object)scope.getName());
        Assert.assertEquals((Object)"stream.event.context", (Object)scope.getPath());
    }

    @Test
    public void testEventHeaders() {
        ILexicalScope child = ILexicalScope.ROOT.getChild("event");
        Assert.assertNotNull((Object)child);
        ILexicalScope scope2 = child.getChild("header");
        ILexicalScope scope3 = ILexicalScope.ROOT.getChild("event.header");
        Assert.assertEquals((Object)ILexicalScope.EVENT_HEADER, (Object)scope2);
        Assert.assertEquals((Object)ILexicalScope.EVENT_HEADER, (Object)scope3);
        assert (ILexicalScope.EVENT_HEADER == scope2);
        Assert.assertNotNull((Object)scope2);
        ILexicalScope id = scope2.getChild("id");
        Assert.assertNotNull((Object)id);
        assert (ILexicalScope.EVENT_HEADER_ID == id);
        ILexicalScope ts = scope2.getChild("v.timestamp");
        ILexicalScope v = scope2.getChild("v");
        assert (ILexicalScope.EVENT_HEADER_V_TIMESTAMP == ts);
        assert (ILexicalScope.EVENT_HEADER_V == v);
        Assert.assertNotNull((Object)v);
        ILexicalScope ts2 = v.getChild("timestamp");
        assert (ILexicalScope.EVENT_HEADER_V_TIMESTAMP == ts2);
        Assert.assertNotNull((Object)v);
        id = v.getChild("id");
        assert (ILexicalScope.EVENT_HEADER_V_ID == id);
        Assert.assertNotNull((Object)v);
        ILexicalScope other = v.getChild("other");
        Assert.assertNull((Object)other);
    }

    @Test
    public void testFields() {
        ILexicalScope child = ILexicalScope.ROOT.getChild("fields");
        Assert.assertNotNull((Object)child);
        ILexicalScope scope2 = child.getChild("_ret");
        ILexicalScope scope3 = child.getChild("_tid");
        ILexicalScope empty = child.getChild("other");
        Assert.assertEquals((Object)ILexicalScope.FIELDS_RET, (Object)scope2);
        assert (ILexicalScope.FIELDS_RET == scope2);
        Assert.assertEquals((Object)ILexicalScope.FIELDS_TID, (Object)scope3);
        assert (ILexicalScope.FIELDS_TID == scope2);
        Assert.assertNull((Object)empty);
    }

    @Test
    public void testNotEquals() {
        Assert.assertNotEquals((Object)ILexicalScope.CONTEXT, (Object)ILexicalScope.EVENT);
        LexicalScope context = new LexicalScope((ILexicalScope)ILexicalScope.CONTEXT, "context");
        LexicalScope otherContext = new LexicalScope((ILexicalScope)ILexicalScope.CONTEXT, "context2");
        Assert.assertNotEquals((Object)context, (Object)otherContext);
        Assert.assertNotEquals((Object)context, null);
    }

    @Test
    public void testGetPath() {
        ILexicalScope child = ILexicalScope.ROOT.getChild("fields");
        Assert.assertNotNull((Object)child);
        ILexicalScope scope2 = child.getChild("_ret");
        Assert.assertNotNull((Object)scope2);
        Assert.assertEquals((Object)"fields._ret", (Object)scope2.getPath());
    }
}

