/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskWriteModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class StateDumpHandler
extends KernelEventHandler {
    private final InputOutputStateProvider fStateProvider;

    public StateDumpHandler(IKernelAnalysisEventLayout layout, InputOutputStateProvider sp) {
        super(layout);
        this.fStateProvider = sp;
    }

    @Override
    public void handleEvent(@NonNull ITmfStateSystemBuilder ss, @NonNull ITmfEvent event) throws AttributeNotFoundException {
        ITmfEventField content = event.getContent();
        String diskname = (String)event.getContent().getField(new String[]{this.getLayout().fieldDiskname()}).getValue();
        int dev = ((Long)content.getField(new String[]{this.getLayout().fieldBlockDeviceId()}).getValue()).intValue();
        if (diskname != null) {
            DiskWriteModel disk = this.fStateProvider.getDisk(dev);
            disk.setDiskName(diskname);
        }
    }
}

