/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.commands;

import com.google.common.base.Joiner;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ExportToTsvUtils {
    private ExportToTsvUtils() {
    }

    public static void exportTreeToTsv(@Nullable Tree tree, @Nullable OutputStream stream) {
        if (tree == null || stream == null) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter pw = new PrintWriter(stream);){
            int size = tree.getItemCount();
            ArrayList<String> columns = new ArrayList<String>();
            int i = 0;
            while (i < tree.getColumnCount()) {
                String valueOf = String.valueOf(tree.getColumn(i).getText());
                if (valueOf.isEmpty() && i == tree.getColumnCount() - 1) break;
                columns.add(valueOf);
                ++i;
            }
            String join = Joiner.on((char)'\t').skipNulls().join(columns);
            pw.println(join);
            int i2 = 0;
            while (i2 < size) {
                TreeItem item = tree.getItem(i2);
                ExportToTsvUtils.printItem(pw, columns, item);
                ++i2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void printItem(PrintWriter pw, List<String> columns, @Nullable TreeItem item) {
        if (item == null) {
            return;
        }
        ArrayList<String> data = new ArrayList<String>();
        int col = 0;
        while (col < columns.size()) {
            data.add(String.valueOf(item.getText(col)));
            ++col;
        }
        pw.println(Joiner.on((char)'\t').join(data));
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            ExportToTsvUtils.printItem(pw, columns, child);
            ++n2;
        }
    }

    public static void exportTableToTsv(Table table, @Nullable OutputStream stream) {
        if (table == null || stream == null) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter pw = new PrintWriter(stream);){
            int size = table.getItemCount();
            ArrayList<String> columns = new ArrayList<String>();
            int i = 0;
            while (i < table.getColumnCount()) {
                TableColumn column = table.getColumn(i);
                if (column == null) {
                    return;
                }
                String columnName = String.valueOf(column.getText());
                if (columnName.isEmpty() && i == table.getColumnCount() - 1) break;
                columns.add(columnName);
                ++i;
            }
            pw.println(Joiner.on((char)'\t').join(columns));
            i = 0;
            while (i < size) {
                TableItem item = table.getItem(i);
                if (item != null) {
                    ArrayList<String> data = new ArrayList<String>();
                    int col = 0;
                    while (col < columns.size()) {
                        data.add(String.valueOf(item.getText(col)));
                        ++col;
                    }
                    pw.println(Joiner.on((char)'\t').join(data));
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

