/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.callgraph2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.CallStackTestBase2;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallGraphAnalysisStub;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph2.AggregatedCalledFunctionStatistics;
import org.eclipse.tracecompass.internal.analysis.profiling.core.model.ModelManager;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AggregatedCalledFunctionStatisticsTest {
    private static final String FIRST_AVERAGE_DURATION = "Test first function's average duration";
    private static final String FIRST_AVERAGE_SELF_TIME = "Test first function's average self time";
    private static final String FIRST_MAXIMUM_DURATION = "Test first function's maximum duration";
    private static final String FIRST_MAXIMUM_SELF_TIME = "Test first function's maximum self time";
    private static final String FIRST_MINIMUM_DURATION = "Test first function's minimum duration";
    private static final String FIRST_MINIMUM_SELF_TIME = "Test first function's minimum self time";
    private static final String FIRST_NUMBER_OF_SEGMENTS = "Test first function's number of segments";
    private static final String FIRST_SELF_TIME_STANDARD_DEVIATION = "Test first function's self time standard deviation";
    private static final String FIRST_STANDARD_DEVIATION = "Test first function's standard deviation";
    private static final String SECOND_AVERAGE_DURATION = "Test second function's average duration";
    private static final String SECOND_AVERAGE_SELF_TIME = "Test second function's average self time";
    private static final String SECOND_MAXIMUM_DURATION = "Test second function's maximum duration";
    private static final String SECOND_MAXIMUM_SELF_TIME = "Test second function's maximum self time";
    private static final String SECOND_MINIMUM_DURATION = "Test second function's minimum duration";
    private static final String SECOND_MINIMUM_SELF_TIME = "Test second function's minimum self time";
    private static final String SECOND_NUMBER_OF_CALLS = "Test second function's number of calls";
    private static final String SECOND_SELF_TIME_STANDARD_DEVIATION = "Test second function's self time standard deviation";
    private static final String SECOND_STANDARD_DEVIATION = "Test second function's standard deviation";
    private static final String MAIN_STANDARD_DEVIATION = "Test main's standard deviation";
    private static final String QUARK_0 = "0";
    private static final String QUARK_1 = "1";
    private static final String QUARK_2 = "2";
    private static final String QUARK_3 = "3";
    private static final double ERROR = 1.0E-6;
    private CallGraphAnalysisStub fCga;

    private static @NonNull ITmfStateSystemBuilder createFixture() {
        IStateHistoryBackend backend = StateHistoryBackendFactory.createInMemoryBackend((String)"Test", (long)0L);
        return StateSystemFactory.newStateSystem((IStateHistoryBackend)backend);
    }

    private static List<ICallStackElement> getLeafElements(ICallStackElement group) {
        if (group.isLeaf()) {
            return Collections.singletonList(group);
        }
        ArrayList<ICallStackElement> leafGroups = new ArrayList<ICallStackElement>();
        group.getChildrenElements().forEach(g -> {
            boolean bl = leafGroups.addAll(AggregatedCalledFunctionStatisticsTest.getLeafElements(g));
        });
        return leafGroups;
    }

    private static @NonNull List<ICallStackElement> getLeafElements(ICallGraphProvider2 cga) {
        Collection elements = cga.getCallGraph().getElements();
        ArrayList<ICallStackElement> leafGroups = new ArrayList<ICallStackElement>();
        for (ICallStackElement group : elements) {
            leafGroups.addAll(AggregatedCalledFunctionStatisticsTest.getLeafElements(group));
        }
        return leafGroups;
    }

    @After
    public void disposeCga() {
        CallGraphAnalysisStub cga = this.fCga;
        if (cga != null) {
            cga.dispose();
        }
        ModelManager.disposeModels();
    }

    @Test
    public void treeStatisticsTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", "Thread", "CallStack"});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        long statev = 0L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(100L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(90L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(30L, null, quark);
        fixture.closeHistory(102L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregatedCalledFunctionStatisticsTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        ICallStackElement thread = threads.get(0);
        Assert.assertNotNull((Object)thread);
        Object[] children = cga.getCallGraph().getCallingContextTree(thread).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Object[] firstFunctionChildren = firstFunction.getCallees().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        Object[] secondFunctionChildren = secondFunction.getCallees().toArray();
        AggregatedCalledFunction thirdFunction = (AggregatedCalledFunction)secondFunctionChildren[0];
        @NonNull AggregatedCalledFunctionStatistics mainStatistics1 = firstFunction.getFunctionStatistics();
        Assert.assertEquals((String)"Test main's maximum duration", (long)100L, (long)mainStatistics1.getDurationStatistics().getMax());
        Assert.assertEquals((String)"Test main's minimum duration", (long)100L, (long)mainStatistics1.getDurationStatistics().getMin());
        Assert.assertEquals((String)"Test main's maximum self time", (long)20L, (long)mainStatistics1.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test main's minimum self time", (long)20L, (long)mainStatistics1.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test main's number of calls", (long)1L, (long)mainStatistics1.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)"Test main's average duration", (double)100.0, (double)mainStatistics1.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)MAIN_STANDARD_DEVIATION, (double)20.0, (double)mainStatistics1.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)MAIN_STANDARD_DEVIATION, (double)Double.NaN, (double)mainStatistics1.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)MAIN_STANDARD_DEVIATION, (double)Double.NaN, (double)mainStatistics1.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics1 = secondFunction.getFunctionStatistics();
        Assert.assertEquals((String)FIRST_MAXIMUM_DURATION, (long)50L, (long)functionStatistics1.getDurationStatistics().getMax());
        Assert.assertEquals((String)FIRST_MINIMUM_DURATION, (long)30L, (long)functionStatistics1.getDurationStatistics().getMin());
        Assert.assertEquals((String)FIRST_MAXIMUM_SELF_TIME, (long)30L, (long)functionStatistics1.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test first function's mininmum self time", (long)20L, (long)functionStatistics1.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test first function's number of calls", (long)2L, (long)functionStatistics1.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)FIRST_AVERAGE_DURATION, (double)40.0, (double)functionStatistics1.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_AVERAGE_SELF_TIME, (double)25.0, (double)functionStatistics1.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics1.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_SELF_TIME_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics1.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics2 = thirdFunction.getFunctionStatistics();
        Assert.assertEquals((String)SECOND_MAXIMUM_DURATION, (long)30L, (long)functionStatistics2.getDurationStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_DURATION, (long)30L, (long)functionStatistics2.getDurationStatistics().getMin());
        Assert.assertEquals((String)SECOND_MAXIMUM_SELF_TIME, (long)30L, (long)functionStatistics2.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_SELF_TIME, (long)30L, (long)functionStatistics2.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)SECOND_NUMBER_OF_CALLS, (long)1L, (long)functionStatistics2.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)SECOND_AVERAGE_DURATION, (double)30.0, (double)functionStatistics2.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_AVERAGE_SELF_TIME, (double)30.0, (double)functionStatistics2.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics2.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_SELF_TIME_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics2.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
    }

    @Test
    public void mergeFirstLevelCalleesStatisticsTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", "Thread", "CallStack"});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        Long statev = 0L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(100L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(90L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = 2L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(30L, null, quark);
        statev = 3L;
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(80L, null, quark);
        fixture.closeHistory(102L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregatedCalledFunctionStatisticsTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        ICallStackElement thread = threads.get(0);
        Assert.assertNotNull((Object)thread);
        Object[] children = cga.getCallGraph().getCallingContextTree(thread).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Object[] firstFunctionChildren = firstFunction.getCallees().toArray();
        AggregatedCalledFunction secondFunction = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction leaf1 = (AggregatedCalledFunction)secondFunction.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x2")).findAny().get();
        AggregatedCalledFunction leaf2 = (AggregatedCalledFunction)secondFunction.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x3")).findAny().get();
        @NonNull AggregatedCalledFunctionStatistics functionStatistics1 = firstFunction.getFunctionStatistics();
        Assert.assertEquals((String)FIRST_MAXIMUM_DURATION, (long)100L, (long)functionStatistics1.getDurationStatistics().getMax());
        Assert.assertEquals((String)FIRST_MINIMUM_DURATION, (long)100L, (long)functionStatistics1.getDurationStatistics().getMin());
        Assert.assertEquals((String)FIRST_MAXIMUM_SELF_TIME, (long)20L, (long)functionStatistics1.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)FIRST_MINIMUM_SELF_TIME, (long)20L, (long)functionStatistics1.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)FIRST_NUMBER_OF_SEGMENTS, (long)1L, (long)functionStatistics1.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)FIRST_AVERAGE_DURATION, (double)100.0, (double)functionStatistics1.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_AVERAGE_SELF_TIME, (double)20.0, (double)functionStatistics1.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics1.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics1.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics2 = secondFunction.getFunctionStatistics();
        Assert.assertEquals((String)SECOND_MAXIMUM_DURATION, (long)50L, (long)functionStatistics2.getDurationStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_DURATION, (long)30L, (long)functionStatistics2.getDurationStatistics().getMin());
        Assert.assertEquals((String)SECOND_MAXIMUM_SELF_TIME, (long)20L, (long)functionStatistics2.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_SELF_TIME, (long)10L, (long)functionStatistics2.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)SECOND_NUMBER_OF_CALLS, (long)2L, (long)functionStatistics2.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)SECOND_AVERAGE_DURATION, (double)40.0, (double)functionStatistics2.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_AVERAGE_SELF_TIME, (double)15.0, (double)functionStatistics2.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics2.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics2.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics leafStatistics1 = leaf1.getFunctionStatistics();
        Assert.assertEquals((String)"Test first leaf's maximum duration", (long)30L, (long)leafStatistics1.getDurationStatistics().getMax());
        Assert.assertEquals((String)"Test first leaf's minimum duration", (long)30L, (long)leafStatistics1.getDurationStatistics().getMin());
        Assert.assertEquals((String)"Test first leaf's maximum self time", (long)30L, (long)leafStatistics1.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test first leaf's minimum self time", (long)30L, (long)leafStatistics1.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test first leaf's number of calls", (long)1L, (long)leafStatistics1.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)"Test first leaf's minimum duration", (double)30.0, (double)leafStatistics1.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first leaf's average self time", (double)30.0, (double)leafStatistics1.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first leaf's standard deviation", (double)Double.NaN, (double)leafStatistics1.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test first leaf's self time standard deviation", (double)Double.NaN, (double)leafStatistics1.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics leafStatistics2 = leaf2.getFunctionStatistics();
        Assert.assertEquals((String)"Test second leaf's maximum duration", (long)20L, (long)leafStatistics2.getDurationStatistics().getMax());
        Assert.assertEquals((String)"Test second leaf's minimum duration", (long)20L, (long)leafStatistics2.getDurationStatistics().getMin());
        Assert.assertEquals((String)"Test second leaf's maximum self time", (long)20L, (long)leafStatistics2.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test second leaf's minimum self time", (long)20L, (long)leafStatistics2.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test second leaf's number of calls", (long)1L, (long)leafStatistics2.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)"Test second leaf's average duration", (double)20.0, (double)leafStatistics2.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second leaf's average self time", (double)20.0, (double)leafStatistics2.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second leaf's standard deviation", (double)Double.NaN, (double)leafStatistics2.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test second leaf's self time standard deviation", (double)Double.NaN, (double)leafStatistics2.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
    }

    @Test
    public void multiFunctionRootsTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", "Thread", "CallStack"});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        Long statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(20L, null, quark);
        fixture.modifyAttribute(30L, (Object)statev, quark);
        fixture.modifyAttribute(80L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 2L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(10L, null, quark);
        statev = 3L;
        fixture.modifyAttribute(30L, (Object)statev, quark);
        fixture.modifyAttribute(40L, null, quark);
        fixture.closeHistory(81L);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregatedCalledFunctionStatisticsTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        ICallStackElement thread = threads.get(0);
        Assert.assertNotNull((Object)thread);
        Object[] children = cga.getCallGraph().getCallingContextTree(thread).toArray();
        AggregatedCalledFunction firstFunction = (AggregatedCalledFunction)children[0];
        Object[] firstFunctionChildren = firstFunction.getCallees().toArray();
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)firstFunctionChildren[0];
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)firstFunctionChildren[1];
        @NonNull AggregatedCalledFunctionStatistics functionStatistics1 = firstFunction.getFunctionStatistics();
        Assert.assertEquals((String)FIRST_MAXIMUM_DURATION, (long)50L, (long)functionStatistics1.getDurationStatistics().getMax());
        Assert.assertEquals((String)FIRST_MINIMUM_DURATION, (long)20L, (long)functionStatistics1.getDurationStatistics().getMin());
        Assert.assertEquals((String)FIRST_MAXIMUM_SELF_TIME, (long)40L, (long)functionStatistics1.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)FIRST_MINIMUM_SELF_TIME, (long)10L, (long)functionStatistics1.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)FIRST_NUMBER_OF_SEGMENTS, (long)2L, (long)functionStatistics1.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)FIRST_AVERAGE_DURATION, (double)35.0, (double)functionStatistics1.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_AVERAGE_SELF_TIME, (double)25.0, (double)functionStatistics1.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics1.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_SELF_TIME_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics1.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics2 = function2.getFunctionStatistics();
        Assert.assertEquals((String)SECOND_MAXIMUM_DURATION, (long)10L, (long)functionStatistics2.getDurationStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_DURATION, (long)10L, (long)functionStatistics2.getDurationStatistics().getMin());
        Assert.assertEquals((String)SECOND_MAXIMUM_SELF_TIME, (long)10L, (long)functionStatistics2.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_SELF_TIME, (long)10L, (long)functionStatistics2.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)SECOND_NUMBER_OF_CALLS, (long)1L, (long)functionStatistics2.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)SECOND_AVERAGE_DURATION, (double)10.0, (double)functionStatistics2.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_AVERAGE_SELF_TIME, (double)10.0, (double)functionStatistics2.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics2.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_SELF_TIME_STANDARD_DEVIATION, (double)Double.NaN, (double)functionStatistics2.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        @NonNull AggregatedCalledFunctionStatistics functionStatistics3 = function3.getFunctionStatistics();
        Assert.assertEquals((String)"Test third function's maximum duration", (long)10L, (long)functionStatistics3.getDurationStatistics().getMax());
        Assert.assertEquals((String)"Test third function's minimum duration", (long)10L, (long)functionStatistics3.getDurationStatistics().getMin());
        Assert.assertEquals((String)"Test third function's maximum selftime", (long)10L, (long)functionStatistics3.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test third function's minimum self time", (long)10L, (long)functionStatistics3.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test third function's number of calls", (long)1L, (long)functionStatistics3.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)"Test third function's average duration", (double)10.0, (double)functionStatistics3.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's average self time", (double)10.0, (double)functionStatistics3.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's standard deviation", (double)Double.NaN, (double)functionStatistics3.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's self time standard deviation", (double)Double.NaN, (double)functionStatistics3.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
    }

    private static void buildCallStack(ITmfStateSystemBuilder fixture) {
        int parentQuark = fixture.getQuarkAbsoluteAndAdd(new String[]{"Processes", "Thread", "CallStack"});
        int quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_0});
        Long statev = 0L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(150L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_1});
        statev = 1L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(50L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(100L, null, quark);
        fixture.modifyAttribute(130L, (Object)statev, quark);
        fixture.modifyAttribute(150L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_2});
        statev = 2L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(10L, null, quark);
        statev = 3L;
        fixture.modifyAttribute(20L, (Object)statev, quark);
        fixture.modifyAttribute(30L, null, quark);
        statev = 2L;
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(90L, null, quark);
        quark = fixture.getQuarkRelativeAndAdd(parentQuark, new String[]{QUARK_3});
        statev = 4L;
        fixture.modifyAttribute(0L, (Object)statev, quark);
        fixture.modifyAttribute(10L, null, quark);
        fixture.modifyAttribute(60L, (Object)statev, quark);
        fixture.modifyAttribute(80L, null, quark);
        fixture.closeHistory(151L);
    }

    @Test
    public void mergeSecondLevelCalleesTest() {
        ITmfStateSystemBuilder fixture = AggregatedCalledFunctionStatisticsTest.createFixture();
        AggregatedCalledFunctionStatisticsTest.buildCallStack(fixture);
        CallGraphAnalysisStub cga = new CallGraphAnalysisStub(fixture);
        this.setCga(cga);
        cga.iterate();
        List<ICallStackElement> threads = AggregatedCalledFunctionStatisticsTest.getLeafElements((ICallGraphProvider2)cga);
        Assert.assertNotNull(threads);
        Assert.assertNotNull(threads);
        ICallStackElement thread = threads.get(0);
        Assert.assertNotNull((Object)thread);
        Object[] children = cga.getCallGraph().getCallingContextTree(thread).toArray();
        AggregatedCalledFunction main = (AggregatedCalledFunction)children[0];
        Object[] mainChildren = main.getCallees().toArray();
        AggregatedCalledFunction function1 = (AggregatedCalledFunction)mainChildren[0];
        AggregatedCalledFunction function2 = (AggregatedCalledFunction)function1.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x2")).findAny().get();
        AggregatedCalledFunction function3 = (AggregatedCalledFunction)function1.getCallees().stream().filter(acs -> CallStackTestBase2.getCallSiteSymbol(acs).resolve(Collections.emptySet()).equals("0x3")).findAny().get();
        Object[] firstChildCallee = function2.getCallees().toArray();
        AggregatedCalledFunction function4 = (AggregatedCalledFunction)firstChildCallee[0];
        AggregatedCalledFunctionStatistics mainStatistics1 = main.getFunctionStatistics();
        Assert.assertEquals((String)"Test main's maximum duration", (long)150L, (long)mainStatistics1.getDurationStatistics().getMax());
        Assert.assertEquals((String)"Test main's minimum duration", (long)150L, (long)mainStatistics1.getDurationStatistics().getMin());
        Assert.assertEquals((String)"Test main's maximum self time", (long)40L, (long)mainStatistics1.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test main's minimum self time", (long)40L, (long)mainStatistics1.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test main's number of calls", (long)1L, (long)mainStatistics1.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)"Test main's average duration", (double)150.0, (double)mainStatistics1.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's average self time", (double)40.0, (double)mainStatistics1.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)MAIN_STANDARD_DEVIATION, (double)Double.NaN, (double)mainStatistics1.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test main's self time standard deviation", (double)Double.NaN, (double)mainStatistics1.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics firstFunctionStatistics = function1.getFunctionStatistics();
        Assert.assertEquals((String)FIRST_MAXIMUM_DURATION, (long)50L, (long)firstFunctionStatistics.getDurationStatistics().getMax());
        Assert.assertEquals((String)FIRST_MINIMUM_DURATION, (long)20L, (long)firstFunctionStatistics.getDurationStatistics().getMin());
        Assert.assertEquals((String)FIRST_MAXIMUM_SELF_TIME, (long)30L, (long)firstFunctionStatistics.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)FIRST_MINIMUM_SELF_TIME, (long)10L, (long)firstFunctionStatistics.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)FIRST_NUMBER_OF_SEGMENTS, (long)3L, (long)firstFunctionStatistics.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)FIRST_AVERAGE_DURATION, (double)36.666666667, (double)firstFunctionStatistics.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_AVERAGE_SELF_TIME, (double)20.0, (double)firstFunctionStatistics.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_STANDARD_DEVIATION, (double)15.275252316, (double)firstFunctionStatistics.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)FIRST_SELF_TIME_STANDARD_DEVIATION, (double)10.0, (double)firstFunctionStatistics.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics secondFunctionStatistics2 = function2.getFunctionStatistics();
        Assert.assertEquals((String)SECOND_MAXIMUM_DURATION, (long)30L, (long)secondFunctionStatistics2.getDurationStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_DURATION, (long)10L, (long)secondFunctionStatistics2.getDurationStatistics().getMin());
        Assert.assertEquals((String)SECOND_MAXIMUM_SELF_TIME, (long)10L, (long)secondFunctionStatistics2.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)SECOND_MINIMUM_SELF_TIME, (long)0L, (long)secondFunctionStatistics2.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test second function's number of segments", (long)2L, (long)secondFunctionStatistics2.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)SECOND_AVERAGE_DURATION, (double)20.0, (double)secondFunctionStatistics2.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_AVERAGE_SELF_TIME, (double)5.0, (double)secondFunctionStatistics2.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_STANDARD_DEVIATION, (double)Double.NaN, (double)secondFunctionStatistics2.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)SECOND_SELF_TIME_STANDARD_DEVIATION, (double)Double.NaN, (double)secondFunctionStatistics2.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics thirdFunctionStatistics3 = function3.getFunctionStatistics();
        Assert.assertEquals((String)"Test third function's maximum duration", (long)10L, (long)thirdFunctionStatistics3.getDurationStatistics().getMax());
        Assert.assertEquals((String)"Test third function's minimum duration", (long)10L, (long)thirdFunctionStatistics3.getDurationStatistics().getMin());
        Assert.assertEquals((String)"Test third function's maximum self time", (long)10L, (long)thirdFunctionStatistics3.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test third function's minimum self time", (long)10L, (long)thirdFunctionStatistics3.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test third function's number of segments", (long)1L, (long)thirdFunctionStatistics3.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)"Test third function's average duration", (double)10.0, (double)thirdFunctionStatistics3.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's average self time", (double)10.0, (double)thirdFunctionStatistics3.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's self time deviation", (double)Double.NaN, (double)thirdFunctionStatistics3.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test third function's self time standard deviation", (double)Double.NaN, (double)thirdFunctionStatistics3.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
        AggregatedCalledFunctionStatistics fourthFunctionStatistics4 = function4.getFunctionStatistics();
        Assert.assertEquals((String)"Test fourth function's maximum duration", (long)20L, (long)fourthFunctionStatistics4.getDurationStatistics().getMax());
        Assert.assertEquals((String)"Test fourth function's minimum duration", (long)10L, (long)fourthFunctionStatistics4.getDurationStatistics().getMin());
        Assert.assertEquals((String)"Test fourth function's maximum self time", (long)20L, (long)fourthFunctionStatistics4.getSelfTimeStatistics().getMax());
        Assert.assertEquals((String)"Test fourth function's maximum self time", (long)10L, (long)fourthFunctionStatistics4.getSelfTimeStatistics().getMin());
        Assert.assertEquals((String)"Test fourth function's number of segments", (long)2L, (long)fourthFunctionStatistics4.getDurationStatistics().getNbElements());
        Assert.assertEquals((String)"Test fourth function's average duration", (double)15.0, (double)fourthFunctionStatistics4.getDurationStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test fourth function's average duration", (double)15.0, (double)fourthFunctionStatistics4.getSelfTimeStatistics().getMean(), (double)1.0E-6);
        Assert.assertEquals((String)"Test fourth function's standard deviation", (double)Double.NaN, (double)fourthFunctionStatistics4.getDurationStatistics().getStdDev(), (double)1.0E-6);
        Assert.assertEquals((String)"Test fourth function's self time deviation", (double)Double.NaN, (double)fourthFunctionStatistics4.getSelfTimeStatistics().getStdDev(), (double)1.0E-6);
    }

    private void setCga(CallGraphAnalysisStub cga) {
        this.fCga = cga;
    }
}

