/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.stubs;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackHostUtils;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackSeries;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;

@NonNullByDefault
public class CallGraphAnalysisStub
extends CallGraphAnalysis {
    public static final String PROCESS_PATH = "Processes";
    public static final String THREAD_PATH = "Thread";
    public static final String CALLSTACK_PATH = "CallStack";
    private static final String[] PP = new String[]{"Processes"};
    private static final String[] TP = new String[]{"Thread"};
    private static final List<String[]> PATTERNS = ImmutableList.of((Object)PP, (Object)TP);
    private final CallStackAnalysis fCsProvider;

    public CallGraphAnalysisStub(ITmfStateSystemBuilder fixture) {
        this(new CSAnalysis((ITmfStateSystem)fixture));
    }

    public CallGraphAnalysisStub(ITmfStateSystemBuilder fixture, List<String[]> patterns) {
        this(new CSAnalysis((ITmfStateSystem)fixture, patterns));
    }

    private CallGraphAnalysisStub(CallStackAnalysis csp) {
        super(csp);
        this.fCsProvider = csp;
    }

    public boolean iterate() {
        CallStackSeries callStackSeries = this.fCsProvider.getCallStackSeries();
        if (callStackSeries == null) {
            throw new NullPointerException();
        }
        String[] threadsPattern = this.fCsProvider.getThreadsPattern();
        String[] processesPattern = this.fCsProvider.getProcessesPattern();
        ITmfStateSystem ss = this.fCsProvider.getStateSystem();
        if (ss == null) {
            throw new NullPointerException();
        }
        return this.iterateOverStateSystem(ss, threadsPattern, processesPattern, (IProgressMonitor)new NullProgressMonitor());
    }

    public void dispose() {
        super.dispose();
        this.fCsProvider.dispose();
    }

    private static class CSAnalysis
    extends CallStackAnalysis {
        private final ITmfStateSystem fSs;
        private final @Nullable List<String[]> fPatterns;

        public CSAnalysis(ITmfStateSystem fixture) {
            this.fSs = fixture;
            this.fPatterns = null;
        }

        public CSAnalysis(ITmfStateSystem fixture, List<String[]> patterns) {
            this.fSs = fixture;
            this.fPatterns = patterns;
        }

        public @Nullable ITmfStateSystem getStateSystem() {
            return this.fSs;
        }

        public @Nullable CallStackSeries getCallStackSeries() {
            List<String @NonNull []> patterns = this.fPatterns;
            return new CallStackSeries(this.fSs, patterns == null ? PATTERNS : patterns, 0, "", (CallStackHostUtils.IHostIdResolver)new CallStackHostUtils.TraceHostIdResolver(this.getTrace()), (CallStackSeries.IThreadIdResolver)new CallStackSeries.AttributeValueThreadResolver(1));
        }

        protected @NonNull ITmfStateProvider createStateProvider() {
            throw new UnsupportedOperationException();
        }

        public List<String[]> getPatterns() {
            return super.getPatterns();
        }
    }
}

