/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tracecompass.tmf.remote.ui";
    public static final String PLUGIN_CORE_ID = "org.eclipse.tracecompass.tmf.remote.core";
    private static Activator plugin;
    private IPreferenceStore fCorePreferenceStore;

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public IPreferenceStore getCorePreferenceStore() {
        if (this.fCorePreferenceStore == null) {
            this.fCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, PLUGIN_CORE_ID);
        }
        return this.fCorePreferenceStore;
    }

    public Image getImageFromPath(String path) {
        return this.getImageDescripterFromPath(path).createImage();
    }

    public ImageDescriptor getImageDescripterFromPath(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image getImageFromImageRegistry(String path) {
        Image icon = this.getImageRegistry().get(path);
        if (icon == null) {
            icon = this.getImageDescripterFromPath(path).createImage();
            plugin.getImageRegistry().put(path, icon);
        }
        return icon;
    }

    public void logInfo(String message) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public void logInfo(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, message, exception));
    }

    public void logWarning(String message) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message));
    }

    public void logWarning(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, message, exception));
    }

    public void logError(String message) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public void logError(String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, exception));
    }
}

