/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.internal.core.DirtyFileSearchParticipantServiceTracker;
import org.eclipse.search.internal.core.SearchCoreMessages;
import org.eclipse.search.internal.core.text.DirtyFileProvider;
import org.eclipse.search.internal.core.text.TextSearchEngineRegistry;
import org.osgi.framework.BundleContext;

public class SearchCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.search.core";
    public static final int INTERNAL_ERROR = 1;
    private static SearchCorePlugin fgSearchPlugin;
    private TextSearchEngineRegistry fTextSearchEngineRegistry;
    private DirtyFileProvider fDirtyFileSearchParticipant;
    private DirtyFileSearchParticipantServiceTracker fDirtyFileSearchParticipantTracker;

    public static SearchCorePlugin getDefault() {
        return fgSearchPlugin;
    }

    public SearchCorePlugin() {
        Assert.isTrue((fgSearchPlugin == null ? 1 : 0) != 0);
        fgSearchPlugin = this;
        this.fTextSearchEngineRegistry = null;
    }

    public void start(BundleContext context) throws Exception {
        this.fDirtyFileSearchParticipantTracker = new DirtyFileSearchParticipantServiceTracker(context);
    }

    public void stop(BundleContext context) throws Exception {
    }

    public TextSearchEngineRegistry getTextSearchEngineRegistry() {
        if (this.fTextSearchEngineRegistry == null) {
            this.fTextSearchEngineRegistry = new TextSearchEngineRegistry();
        }
        return this.fTextSearchEngineRegistry;
    }

    public DirtyFileProvider getDirtyFileDiscovery() {
        if (this.fDirtyFileSearchParticipant == null) {
            this.fDirtyFileSearchParticipantTracker.open();
            this.fDirtyFileSearchParticipant = this.fDirtyFileSearchParticipantTracker.checkedGetService();
        }
        return this.fDirtyFileSearchParticipant;
    }

    public static void log(IStatus status) {
        SearchCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        SearchCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, SearchCoreMessages.SearchPlugin_internal_error, e));
    }

    public static String getID() {
        return PLUGIN_ID;
    }
}

