/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IGroupingSegmentAspect;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IOStateSystemSegmentStore;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputInformationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Messages;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.RequestIntervalSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class InputOutputAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.inputoutput";
    private final Collection<ISegmentAspect> fAspects = ImmutableList.of((Object)new IoDiskAspect(), (Object)IoRequestTypeAspect.INSTANCE);
    private final ISegmentStoreProvider fWaitingQueueSs = new InputOutputSegmentStore("Waiting_queue");
    private final ISegmentStoreProvider fExecQueueSs = new InputOutputSegmentStore("Driver_queue");

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        IKernelAnalysisEventLayout layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        return new InputOutputStateProvider(trace, layout);
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException();
        }
        Iterable tidModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TidAnalysisModule.class);
        Iterator iterator = tidModules.iterator();
        if (iterator.hasNext()) {
            TidAnalysisModule tidModule = (TidAnalysisModule)((Object)iterator.next());
            modules.add((IAnalysisModule)tidModule);
        }
        return modules;
    }

    public ArrayList<Long> getLatencyTables(long start, long end) {
        @NonNull ArrayList<@NonNull Long> map = new ArrayList<Long>();
        ITmfTrace trace = this.getTrace();
        ITmfStateSystem ss = this.getStateSystem();
        if (trace == null || ss == null) {
            return map;
        }
        try {
            List diskQuarks = ss.getQuarks(new String[]{"Disks", "*"});
            for (Integer diskQuark : diskQuarks) {
                int driverQueueQuark = ss.getQuarkRelative(diskQuark.intValue(), new String[]{"Driver_queue"});
                List slotsQuark = ss.getSubAttributes(driverQueueQuark, false);
                for (Integer slotQuark : slotsQuark) {
                    List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)slotQuark, (long)start, (long)end);
                    for (ITmfStateInterval currentInterval : intervals) {
                        if (currentInterval.getStateValue().isNull()) continue;
                        Long latency = currentInterval.getEndTime() - currentInterval.getStartTime();
                        map.add(latency / 1000000L);
                    }
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Activator.getDefault().logError("Error getting the latency table", e);
            return map;
        }
        return map;
    }

    public ISegmentStoreProvider getWaitingQueueSegmentStore() {
        return this.fWaitingQueueSs;
    }

    public ISegmentStoreProvider getExecutionQueueSegmentStore() {
        return this.fExecQueueSs;
    }

    private class InputOutputSegmentStore
    implements ISegmentStoreProvider {
        private final String fQueueAttribute;

        public InputOutputSegmentStore(String queueAttribute) {
            this.fQueueAttribute = queueAttribute;
        }

        public void addListener(@NonNull IAnalysisProgressListener listener) {
        }

        public void removeListener(@NonNull IAnalysisProgressListener listener) {
        }

        public Iterable<ISegmentAspect> getSegmentAspects() {
            return InputOutputAnalysisModule.this.fAspects;
        }

        public @Nullable ISegmentStore<ISegment> getSegmentStore() {
            ITmfStateSystem ss = InputOutputAnalysisModule.this.getStateSystem();
            if (ss == null) {
                InputOutputAnalysisModule.this.schedule();
                return null;
            }
            if (!InputOutputAnalysisModule.this.waitForCompletion()) {
                return null;
            }
            Collection<Disk> disks = InputOutputInformationProvider.getDisks(InputOutputAnalysisModule.this);
            HashMap<Integer, Disk> quarkToDisk = new HashMap<Integer, Disk>();
            for (Disk disk : disks) {
                int wqQuark = ss.optQuarkRelative(disk.getQuark(), new String[]{this.fQueueAttribute});
                if (wqQuark == -2) continue;
                List subAttributes = ss.getSubAttributes(wqQuark, false);
                for (Integer subAttribute : subAttributes) {
                    quarkToDisk.put(subAttribute, disk);
                }
            }
            return new IOStateSystemSegmentStore(ss, quarkToDisk);
        }
    }

    private final class IoDiskAspect
    implements IGroupingSegmentAspect {
        private IoDiskAspect() {
        }

        public String getName() {
            return Objects.requireNonNull(Messages.IoAspect_DiskName);
        }

        public String getHelpText() {
            return Objects.requireNonNull(Messages.IoAspect_DiskHelpText);
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable Object resolve(ISegment segment) {
            if (segment instanceof RequestIntervalSegment) {
                return ((RequestIntervalSegment)segment).getDiskName();
            }
            return "";
        }
    }

    private static final class IoRequestTypeAspect
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new IoRequestTypeAspect();

        private IoRequestTypeAspect() {
        }

        public String getHelpText() {
            return Objects.requireNonNull(Messages.IoAspect_TypeHelpText);
        }

        public String getName() {
            return Objects.requireNonNull(Messages.IoAspect_TypeName);
        }

        public @Nullable Comparator<?> getComparator() {
            return null;
        }

        public @Nullable String resolve(ISegment segment) {
            if (segment instanceof RequestIntervalSegment) {
                return ((RequestIntervalSegment)segment).getOperationType().name();
            }
            return "";
        }
    }
}

