/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramBucket;

public class HistogramScaledData {
    public static final int OUT_OF_RANGE_BUCKET = -1;
    public int fWidth;
    public int fHeight;
    public int fBarWidth;
    public HistogramBucket[] fData;
    public final int[] fLostEventsData;
    public double fBucketDuration;
    public long fMaxValue;
    public long fMaxCombinedValue;
    public int fSelectionBeginBucket;
    public int fSelectionEndBucket;
    public int fLastBucket;
    public double fScalingFactor;
    public double fScalingFactorCombined;
    public long fFirstBucketTime;
    public long fFirstEventTime;
    public static volatile boolean hideLostEvents = false;

    public HistogramScaledData(int width, int height, int barWidth) {
        this.fWidth = width;
        this.fHeight = height;
        this.fBarWidth = barWidth;
        this.fData = new HistogramBucket[width / this.fBarWidth];
        this.fLostEventsData = new int[width / this.fBarWidth];
        this.fBucketDuration = 1.0;
        this.fMaxValue = 0L;
        this.fMaxCombinedValue = 0L;
        this.fSelectionBeginBucket = 0;
        this.fSelectionEndBucket = 0;
        this.fLastBucket = 0;
        this.fScalingFactor = 1.0;
        this.fScalingFactorCombined = 1.0;
        this.fFirstBucketTime = 0L;
    }

    public HistogramScaledData(HistogramScaledData other) {
        this.fWidth = other.fWidth;
        this.fHeight = other.fHeight;
        this.fBarWidth = other.fBarWidth;
        this.fData = Arrays.copyOf(other.fData, other.fData.length);
        this.fLostEventsData = Arrays.copyOf(other.fLostEventsData, other.fLostEventsData.length);
        this.fBucketDuration = other.fBucketDuration;
        this.fMaxValue = other.fMaxValue;
        this.fMaxCombinedValue = other.fMaxCombinedValue;
        this.fSelectionBeginBucket = other.fSelectionBeginBucket;
        this.fSelectionEndBucket = other.fSelectionEndBucket;
        this.fLastBucket = other.fLastBucket;
        this.fScalingFactor = other.fScalingFactor;
        this.fScalingFactorCombined = other.fScalingFactorCombined;
        this.fFirstBucketTime = other.fFirstBucketTime;
    }

    public long getFirstBucketTime() {
        return this.fFirstBucketTime;
    }

    public void setFirstBucketTime(long firstEventTime) {
        this.fFirstBucketTime = firstEventTime;
    }

    public long getLastBucketTime() {
        return this.getBucketStartTime(this.fLastBucket);
    }

    public long getBucketStartTime(int index) {
        return this.fFirstBucketTime + (long)((double)this.getOffsetIndex(index) * this.fBucketDuration);
    }

    private int getOffsetIndex(int index) {
        if (this.fBucketDuration != 0.0) {
            double nbBuckets = (double)this.fWidth * this.fBucketDuration;
            double threshold = 0.5 / nbBuckets * (double)this.fWidth;
            return (int)((double)index + threshold);
        }
        return index;
    }

    public long getBucketEndTime(int index) {
        return this.getBucketStartTime(index + 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.fData);
        result = 31 * result + Arrays.hashCode(this.fLostEventsData);
        result = 31 * result + Objects.hash(this.fBarWidth, this.fBucketDuration, this.fFirstBucketTime, this.fFirstEventTime, this.fHeight, this.fLastBucket, this.fMaxCombinedValue, this.fMaxValue, this.fScalingFactor, this.fScalingFactorCombined, this.fSelectionBeginBucket, this.fSelectionEndBucket, this.fWidth);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistogramScaledData other = (HistogramScaledData)obj;
        return this.fBarWidth == other.fBarWidth && Double.doubleToLongBits(this.fBucketDuration) == Double.doubleToLongBits(other.fBucketDuration) && Arrays.equals(this.fData, other.fData) && this.fFirstBucketTime == other.fFirstBucketTime && this.fFirstEventTime == other.fFirstEventTime && this.fHeight == other.fHeight && this.fLastBucket == other.fLastBucket && Arrays.equals(this.fLostEventsData, other.fLostEventsData) && this.fMaxCombinedValue == other.fMaxCombinedValue && this.fMaxValue == other.fMaxValue && Double.doubleToLongBits(this.fScalingFactor) == Double.doubleToLongBits(other.fScalingFactor) && Double.doubleToLongBits(this.fScalingFactorCombined) == Double.doubleToLongBits(other.fScalingFactorCombined) && this.fSelectionBeginBucket == other.fSelectionBeginBucket && this.fSelectionEndBucket == other.fSelectionEndBucket && this.fWidth == other.fWidth;
    }
}

