/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.eclipse.tracecompass.tmf.core.model.ISampling;

public class SamplingSerializer
extends StdSerializer<ISampling> {
    private static final long serialVersionUID = 1L;

    public SamplingSerializer() {
        super(ISampling.class);
    }

    public void serialize(ISampling value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value instanceof ISampling.Timestamps) {
            ISampling.Timestamps timestamps = (ISampling.Timestamps)value;
            gen.writeArray(timestamps.timestamps(), 0, timestamps.timestamps().length);
        } else if (value instanceof ISampling.Categories) {
            ISampling.Categories categories = (ISampling.Categories)value;
            gen.writeStartArray();
            for (String category : categories.categories()) {
                gen.writeString(category);
            }
            gen.writeEndArray();
        } else if (value instanceof ISampling.Ranges) {
            ISampling.Ranges timeRanges = (ISampling.Ranges)value;
            gen.writeStartArray();
            for (ISampling.Range range : timeRanges.ranges()) {
                gen.writeStartArray();
                gen.writeNumber(((Long)range.start()).longValue());
                gen.writeNumber(((Long)range.end()).longValue());
                gen.writeEndArray();
            }
            gen.writeEndArray();
        } else {
            throw new IllegalArgumentException("Unknown Sampling type: " + value.getClass().getName());
        }
    }
}

