/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiChartModel;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.Messages;

public class LamiTableClass {
    private final String fTableClassName;
    private final String fTableTitle;
    private final List<LamiTableEntryAspect> fAspects;
    private final Collection<LamiChartModel> fPredefinedViews;

    public LamiTableClass(String tableClassName, String tableTitle, List<LamiTableEntryAspect> columnAspects, Collection<LamiChartModel> predefinedViews) {
        this.fTableClassName = tableClassName;
        this.fTableTitle = tableTitle;
        this.fAspects = (List)NonNullUtils.checkNotNull((Object)ImmutableList.copyOf(columnAspects));
        this.fPredefinedViews = ImmutableList.copyOf(predefinedViews);
    }

    public LamiTableClass(LamiTableClass baseClass, String replacementTitle) {
        this.fTableClassName = Messages.LamiAnalysis_ExtendedTableNamePrefix + " " + baseClass.fTableClassName;
        this.fTableTitle = replacementTitle;
        this.fAspects = baseClass.fAspects;
        this.fPredefinedViews = baseClass.fPredefinedViews;
    }

    public String getTableClassName() {
        return this.fTableClassName;
    }

    public String getTableTitle() {
        return this.fTableTitle;
    }

    public List<LamiTableEntryAspect> getAspects() {
        return this.fAspects;
    }

    public Collection<LamiChartModel> getPredefinedViews() {
        return this.fPredefinedViews;
    }
}

