/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPPReferenceType
implements ICPPReferenceType,
ITypeContainer,
ISerializableType {
    private IType fType = null;
    private boolean fIsRValue;

    public CPPReferenceType(IType type, boolean isRValue) {
        this.fIsRValue = isRValue;
        this.setType(type);
    }

    @Override
    public IType getType() {
        return this.fType;
    }

    @Override
    public boolean isRValueReference() {
        return this.fIsRValue;
    }

    @Override
    public void setType(IType t) {
        if (t instanceof ICPPReferenceType) {
            ICPPReferenceType rt = (ICPPReferenceType)t;
            this.fIsRValue = this.fIsRValue && rt.isRValueReference();
            t = rt.getType();
        }
        assert (t != null);
        this.fType = t;
    }

    @Override
    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return ((ITypedef)obj).isSameType(this);
        }
        if (obj instanceof ICPPReferenceType) {
            ICPPReferenceType rhs = (ICPPReferenceType)obj;
            IType t1 = this.getType();
            IType t2 = rhs.getType();
            boolean rv1 = this.isRValueReference();
            boolean rv2 = rhs.isRValueReference();
            while (true) {
                if (t1 instanceof ITypedef) {
                    t1 = ((ITypedef)t1).getType();
                    continue;
                }
                if (!(t1 instanceof ICPPReferenceType)) break;
                rv1 = rv1 && ((ICPPReferenceType)t1).isRValueReference();
                t1 = ((ICPPReferenceType)t1).getType();
            }
            while (true) {
                if (t2 instanceof ITypedef) {
                    t2 = ((ITypedef)t2).getType();
                    continue;
                }
                if (!(t2 instanceof ICPPReferenceType)) break;
                rv2 = rv2 && ((ICPPReferenceType)t2).isRValueReference();
                t2 = ((ICPPReferenceType)t2).getType();
            }
            if (t1 == null) {
                return false;
            }
            return rv1 == rv2 && t1.isSameType(t2);
        }
        return false;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return t;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 6;
        if (this.isRValueReference()) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CPPReferenceType(nested, (firstBytes & 0x20) != 0);
    }
}

