/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.otf2.core.trace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.otf2.core.Activator;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.IOtf2Constants;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2SystemMetrics;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2SystemTree;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class Otf2Trace
extends CtfTmfTrace {
    private Collection<ITmfEventAspect<?>> fAspects = TmfBaseAspects.getBaseAspects();
    private static final int CONFIDENCE = 100;

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return this.fAspects;
    }

    public @Nullable IStatus validate(@Nullable IProject project, @Nullable String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Map environment = ((CtfTraceValidationStatus)status).getEnvironment();
            String domain = (String)environment.get("tracer_name");
            if (domain == null || !domain.equals("\"otf2\"")) {
                return new Status(4, "org.eclipse.tracecompass.incubator.otf2.core", "This trace is not an OTF2 trace");
            }
            return new TraceValidationStatus(100, "org.eclipse.tracecompass.incubator.otf2.core");
        }
        return status;
    }

    public TmfTraceContext createTraceContext(TmfTimeRange selection, TmfTimeRange windowRange, @Nullable IFile editorFile, @Nullable ITmfFilter filter) {
        return new TmfTraceContext(selection, windowRange, editorFile, filter);
    }

    public void initTrace(@Nullable IResource resource, @Nullable String path, @Nullable Class<? extends @Nullable ITmfEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(this.fAspects);
        builder.addAll(this.createCountersAndNodesAspects());
        this.fAspects = builder.build();
    }

    private Collection<ITmfEventAspect<?>> createCountersAndNodesAspects() {
        ImmutableSet.Builder aspectsBuilder = new ImmutableSet.Builder();
        ITmfContext context = this.seekEvent((ITmfLocation)new CtfLocation(new CtfLocationInfo(0L, 0L)));
        CtfTmfEvent event = this.getNext(context);
        Otf2SystemTree systemTree = new Otf2SystemTree();
        Otf2SystemMetrics systemMetrics = new Otf2SystemMetrics();
        HashMap<Integer, String> stringIds = new HashMap<Integer, String>();
        boolean readingDefinitions = true;
        while (event != null && readingDefinitions) {
            block24: {
                String definition;
                String eventName = event.getName();
                Matcher matcher = IOtf2Constants.OTF2_EVENT_NAME_PATTERN.matcher(eventName);
                if (matcher.matches() && matcher.group("type").equals("Event")) {
                    readingDefinitions = false;
                }
                if (!matcher.matches() || !matcher.group("type").equals("GlobalDef")) break block24;
                switch (definition = matcher.group("name")) {
                    case "String": {
                        Otf2Trace.addString((ITmfEvent)event, stringIds);
                        break;
                    }
                    case "SystemTreeNode": {
                        systemTree.addSystemTreeNode((ITmfEvent)event);
                        break;
                    }
                    case "LocationGroup": {
                        systemTree.addLocationGroup((ITmfEvent)event);
                        break;
                    }
                    case "Location": {
                        systemTree.addLocation((ITmfEvent)event);
                        break;
                    }
                    case "MetricMember": {
                        systemMetrics.addMetricMember((ITmfEvent)event, stringIds);
                        break;
                    }
                    case "MetricClass": {
                        systemMetrics.addMetricClass((ITmfEvent)event);
                        break;
                    }
                    default: {
                        Activator.getInstance().logWarning("The following group name is not supported: " + definition);
                    }
                }
            }
            event = this.getNext(context);
        }
        aspectsBuilder.addAll(systemTree.getSystemAspects(stringIds));
        aspectsBuilder.addAll(systemMetrics.getCounterAspects());
        return aspectsBuilder.build();
    }

    private static void addString(ITmfEvent event, Map<Integer, String> stringIds) {
        ITmfEventField content = event.getContent();
        Integer id = (Integer)content.getFieldValue(Integer.class, new String[]{"self"});
        id = (int)(id != null ? (long)id.intValue() : 0xFFFFFFFFL);
        String stringValue = (String)content.getFieldValue(String.class, new String[]{"stringValue"});
        stringValue = stringValue != null ? stringValue : "UNKNOWN";
        stringIds.put(id, stringValue);
    }
}

