/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.validation.internal.ConfigurationConstants;
import org.eclipse.wst.validation.internal.PreferencesWrapper;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ValidationConfiguration
implements Preferences.IPropertyChangeListener {
    private final IResource _resource;
    private boolean disableAllValidation = this.getDisableAllValidation();
    private String _version;
    private Map<ValidatorMetaData, Boolean> _validators = new HashMap<ValidatorMetaData, Boolean>();
    protected Map<ValidatorMetaData, Boolean> manualValidators;
    protected Map<ValidatorMetaData, Boolean> buildValidators;
    protected static final String UserPreference = "USER_PREFERENCE";
    protected static final String UserBuildPreference = "USER_BUILD_PREFERENCE";
    protected static final String UserManualPreference = "USER_MANUAL_PREFERENCE";
    protected static final String DelegatesPreference = "DELEGATES_PREFERENCE";
    protected String USER_PREFERENCE = "USER_PREFERENCE";
    protected String USER_MANUAL_PREFERENCE = "USER_MANUAL_PREFERENCE";
    protected String USER_BUILD_PREFERENCE = "USER_BUILD_PREFERENCE";
    protected String DELEGATES_PREFERENCE = "DELEGATES_PREFERENCE";
    private Map<String, String> _delegatesByTarget = new HashMap<String, String>();
    private static final String DefaultValue = "default_value";

    public static String getEnabledElementsAsString(Set<ValidatorMetaData> elements) {
        if (elements == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (ValidatorMetaData vmd : elements) {
            buffer.append(vmd.getValidatorUniqueName());
            buffer.append(";");
        }
        return buffer.toString();
    }

    private boolean getDisableAllValidation() {
        return false;
    }

    public static String getEnabledElementsAsString(ValidatorMetaData[] elements) {
        StringBuffer buffer = new StringBuffer();
        ValidatorMetaData[] validatorMetaDataArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            buffer.append(vmd.getValidatorUniqueName());
            buffer.append(";");
            ++n2;
        }
        return buffer.toString();
    }

    public static Set<ValidatorMetaData> getStringAsEnabledElements(String elements) {
        if (elements == null) {
            return null;
        }
        HashSet<ValidatorMetaData> result = new HashSet<ValidatorMetaData>();
        StringTokenizer tokenizer = new StringTokenizer(elements, ";");
        while (tokenizer.hasMoreTokens()) {
            String elem = tokenizer.nextToken();
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(elem);
            if (vmd == null) continue;
            result.add(vmd);
        }
        return result;
    }

    public static ValidatorMetaData[] getStringAsEnabledElementsArray(String elements) {
        if (elements == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(elements, ";");
        ValidatorMetaData[] result = new ValidatorMetaData[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String elem = tokenizer.nextToken();
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(elem);
            if (vmd == null) continue;
            result[count++] = vmd;
        }
        if (count != result.length) {
            ValidatorMetaData[] trimResult = new ValidatorMetaData[count];
            System.arraycopy(result, 0, trimResult, 0, count);
            return trimResult;
        }
        return result;
    }

    public static Set<String> getValidatorIdsManual() {
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences(null, null);
        String config = prefs.get(UserManualPreference, null);
        return ValidationConfiguration.getValidatorIds(config);
    }

    public static Set<String> getValidatorIdsBuild() {
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences(null, null);
        String config = prefs.get(UserBuildPreference, null);
        return ValidationConfiguration.getValidatorIds(config);
    }

    private static Set<String> getValidatorIds(String elements) {
        HashSet<String> set = new HashSet<String>(50);
        if (elements != null) {
            StringTokenizer tokenizer = new StringTokenizer(elements, ";");
            while (tokenizer.hasMoreTokens()) {
                set.add(tokenizer.nextToken());
            }
        }
        return set;
    }

    public static IWorkspaceRoot getRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected ValidationConfiguration(IResource resource) {
        this._resource = resource;
    }

    protected ValidationConfiguration(IResource resource, ValidatorMetaData[] validators) throws InvocationTargetException {
        if (resource == null) {
            throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLCREATE"));
        }
        this._resource = resource;
        this.setValidators(validators);
    }

    public boolean isDisableAllValidation() throws InvocationTargetException {
        return this.disableAllValidation;
    }

    public void setDisableAllValidation(boolean allValidation) {
        this.disableAllValidation = allValidation;
    }

    public ValidatorMetaData[] getEnabledValidators() throws InvocationTargetException {
        return this.getValidators(true);
    }

    public ValidatorMetaData[] getEnabledIncrementalValidators(boolean incremental) throws InvocationTargetException {
        return this.getEnabledFullBuildValidators(!incremental);
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild) throws InvocationTargetException {
        return this.getEnabledFullBuildValidators(fullBuild, false);
    }

    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild, boolean onlyReferenced) throws InvocationTargetException {
        int count = 0;
        ValidatorMetaData[] result = null;
        if (!this.isDisableAllValidation()) {
            Set<ValidatorMetaData> set = this.getBuildEnabledValidatorsMap().keySet();
            ValidatorMetaData[] temp = new ValidatorMetaData[set.size()];
            for (ValidatorMetaData vmd : set) {
                Boolean bvalue = this.getBuildEnabledValidatorsMap().get(vmd);
                if (!bvalue.booleanValue() || vmd == null || !vmd.isBuildValidation() || onlyReferenced && !vmd.isDependentValidator()) continue;
                temp[count++] = vmd;
            }
            result = new ValidatorMetaData[count];
            System.arraycopy(temp, 0, result, 0, count);
        } else {
            result = new ValidatorMetaData[]{};
        }
        return result;
    }

    public void setEnabledValidators(ValidatorMetaData[] vmds) {
        Map<ValidatorMetaData, Boolean> all = this.getValidatorMetaData();
        for (ValidatorMetaData vmd : all.keySet()) {
            all.put(vmd, Boolean.FALSE);
        }
        if (vmds == null || vmds.length == 0) {
            return;
        }
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd;
            vmd = validatorMetaDataArray[n2];
            all.put(vmd, Boolean.TRUE);
            ++n2;
        }
    }

    public void setEnabledManualValidators(ValidatorMetaData[] vmds) throws InvocationTargetException {
        HashSet<ValidatorMetaData> manualEnabledVMDs = new HashSet<ValidatorMetaData>(vmds.length);
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            manualEnabledVMDs.add(vmd);
            ++n2;
        }
        validatorMetaDataArray = this.getValidators();
        n = validatorMetaDataArray.length;
        n2 = 0;
        while (n2 < n) {
            ValidatorMetaData data = validatorMetaDataArray[n2];
            if (manualEnabledVMDs.contains(data)) {
                this.getManualEnabledValidatorsMap().put(data, Boolean.TRUE);
            } else {
                this.getManualEnabledValidatorsMap().put(data, Boolean.FALSE);
            }
            ++n2;
        }
    }

    public void setEnabledManualValidators(Set<ValidatorMetaData> vmds) throws InvocationTargetException {
        ValidatorMetaData[] validatorMetaDataArray = this.getValidators();
        int n = validatorMetaDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData data = validatorMetaDataArray[n2];
            if (vmds.contains(data)) {
                this.getManualEnabledValidatorsMap().put(data, Boolean.TRUE);
            } else {
                this.getManualEnabledValidatorsMap().put(data, Boolean.FALSE);
            }
            ++n2;
        }
    }

    public void setEnabledBuildValidators(ValidatorMetaData[] vmds) throws InvocationTargetException {
        HashSet<ValidatorMetaData> buildEnabledVMDs = new HashSet<ValidatorMetaData>(vmds.length);
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            buildEnabledVMDs.add(vmd);
            ++n2;
        }
        validatorMetaDataArray = this.getValidators();
        n = validatorMetaDataArray.length;
        n2 = 0;
        while (n2 < n) {
            ValidatorMetaData data = validatorMetaDataArray[n2];
            if (buildEnabledVMDs.contains(data)) {
                this.getBuildEnabledValidatorsMap().put(data, Boolean.TRUE);
            } else {
                this.getBuildEnabledValidatorsMap().put(data, Boolean.FALSE);
            }
            ++n2;
        }
    }

    public void setEnabledBuildValidators(Set<ValidatorMetaData> vmds) throws InvocationTargetException {
        ValidatorMetaData[] validatorMetaDataArray = this.getValidators();
        int n = validatorMetaDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData data = validatorMetaDataArray[n2];
            if (vmds.contains(data)) {
                this.getBuildEnabledValidatorsMap().put(data, Boolean.TRUE);
            } else {
                this.getBuildEnabledValidatorsMap().put(data, Boolean.FALSE);
            }
            ++n2;
        }
    }

    private Map<ValidatorMetaData, Boolean> getValidatorMetaData() {
        return this._validators;
    }

    public ValidatorMetaData[] getDisabledValidators() throws InvocationTargetException {
        return this.getValidators(false);
    }

    private ValidatorMetaData[] getValidators(boolean value) throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        int count = 0;
        for (ValidatorMetaData vmd : this.getValidatorMetaData().keySet()) {
            Boolean bvalue = this.getValidatorMetaData().get(vmd);
            if (bvalue != value) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public ValidatorMetaData[] getManualEnabledValidators() throws InvocationTargetException {
        Map<ValidatorMetaData, Boolean> map = this.getManualEnabledValidatorsMap();
        if (!map.isEmpty()) {
            LinkedList<ValidatorMetaData> list = new LinkedList<ValidatorMetaData>();
            for (Map.Entry<ValidatorMetaData, Boolean> me : map.entrySet()) {
                Boolean obj = me.getValue();
                if (obj == null || !obj.booleanValue()) continue;
                list.add(me.getKey());
            }
            return list.toArray(new ValidatorMetaData[list.size()]);
        }
        return this.getEnabledValidators();
    }

    public ValidatorMetaData[] getBuildEnabledValidators() throws InvocationTargetException {
        Map<ValidatorMetaData, Boolean> map = this.getBuildEnabledValidatorsMap();
        LinkedList<ValidatorMetaData> list = new LinkedList<ValidatorMetaData>();
        if (!map.isEmpty()) {
            for (Map.Entry<ValidatorMetaData, Boolean> me : map.entrySet()) {
                Boolean obj = me.getValue();
                if (obj == null || !obj.booleanValue()) continue;
                list.add(me.getKey());
            }
            return list.toArray(new ValidatorMetaData[list.size()]);
        }
        return this.getEnabledValidators();
    }

    protected Map<ValidatorMetaData, Boolean> getBuildEnabledValidatorsMap() {
        if (this.buildValidators == null) {
            this.buildValidators = new HashMap<ValidatorMetaData, Boolean>();
        }
        return this.buildValidators;
    }

    protected Map<ValidatorMetaData, Boolean> getManualEnabledValidatorsMap() {
        if (this.manualValidators == null) {
            this.manualValidators = new HashMap<ValidatorMetaData, Boolean>();
        }
        return this.manualValidators;
    }

    public ValidatorMetaData[] getIncrementalValidators() throws InvocationTargetException {
        ValidatorMetaData[] temp = new ValidatorMetaData[this.numberOfValidators()];
        int count = 0;
        for (ValidatorMetaData vmd : this.getValidatorMetaData().keySet()) {
            Boolean bvalue = this.getValidatorMetaData().get(vmd);
            if (!bvalue.booleanValue() || !vmd.isIncremental()) continue;
            temp[count++] = vmd;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public ValidatorMetaData[] getValidators() throws InvocationTargetException {
        return ValidationConfiguration.convertToArray(this._validators.keySet());
    }

    public void setValidators(ValidatorMetaData[] vmds) {
        this._validators.clear();
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            if (vmd != null) {
                this._validators.put(vmd, vmd.isEnabledByDefault() ? Boolean.TRUE : Boolean.FALSE);
            }
            ++n2;
        }
    }

    public void setDefaultDelegates(ValidatorMetaData[] vmds) throws InvocationTargetException {
        this._delegatesByTarget.clear();
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            if (vmd != null) {
                String targetID = vmd.getValidatorUniqueName();
                String delegateID = ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(targetID);
                if (delegateID != null) {
                    this._delegatesByTarget.put(targetID, ValidatorDelegatesRegistry.getInstance().getDefaultDelegate(targetID));
                }
            }
            ++n2;
        }
    }

    public int numberOfValidators() throws InvocationTargetException {
        return this._validators.size();
    }

    public int numberOfEnabledIncrementalValidators() throws InvocationTargetException {
        return ValidationConfiguration.numberOfIncrementalValidators(this.getEnabledValidators());
    }

    public int numberOfIncrementalValidators() throws InvocationTargetException {
        return ValidationConfiguration.numberOfIncrementalValidators(this.getValidators());
    }

    private static int numberOfIncrementalValidators(ValidatorMetaData[] vmds) {
        int count = 0;
        ValidatorMetaData[] validatorMetaDataArray = vmds;
        int n = vmds.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMetaData vmd = validatorMetaDataArray[n2];
            if (vmd.isIncremental()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public int numberOfEnabledValidators() throws InvocationTargetException {
        return this.getEnabledValidators().length;
    }

    public int numberOfDisabledValidators() throws InvocationTargetException {
        return this.getDisabledValidators().length;
    }

    public final String getVersion() throws InvocationTargetException {
        if (this._version == null) {
            this.loadVersion();
        }
        return this._version;
    }

    private void setVersion(String version) {
        this._version = version;
    }

    public void markVersionCurrent() {
        this.setVersion(ConfigurationConstants.CURRENT_VERSION);
    }

    public boolean isVersionCurrent() throws InvocationTargetException {
        return this.getVersion().equals(ConfigurationConstants.CURRENT_VERSION);
    }

    public IResource getResource() {
        return this._resource;
    }

    public boolean isEnabled(String validatorClassName) throws InvocationTargetException {
        if (validatorClassName == null) {
            return false;
        }
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorClassName);
        return this.isEnabled(vmd);
    }

    public boolean isEnabled(ValidatorMetaData vmd) throws InvocationTargetException {
        if (vmd == null) {
            return false;
        }
        Boolean value = this.getValidatorMetaData().get(vmd);
        if (value == null) {
            return false;
        }
        return value;
    }

    public final void passivate() throws InvocationTargetException {
        try {
            if (this.getResource() == null) {
                throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLSAVE"));
            }
            this.getResource().setSessionProperty(ConfigurationConstants.USER_PREFERENCE, (Object)this);
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_SAVE", new String[]{this.getResource().getName()}));
        }
    }

    public abstract void resetToDefault() throws InvocationTargetException;

    protected Boolean convertToBoolean(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Integer convertToInteger(int value) {
        return new Integer(value);
    }

    protected boolean convertToBoolean(String value) {
        Boolean b = Boolean.valueOf(value);
        return b;
    }

    protected int convertToInt(String value) {
        Integer t = Integer.valueOf(value);
        return t;
    }

    public static ValidatorMetaData[] convertToArray(Collection<ValidatorMetaData> c) {
        int length = c == null ? 0 : c.size();
        ValidatorMetaData[] result = new ValidatorMetaData[length];
        if (length == 0) {
            return result;
        }
        int count = 0;
        for (ValidatorMetaData vmd : c) {
            result[count++] = vmd;
        }
        return result;
    }

    public static ValidatorMetaData[] convertToArray(Object[] c) {
        int length = c == null ? 0 : c.length;
        ValidatorMetaData[] result = new ValidatorMetaData[length];
        if (length == 0) {
            return result;
        }
        System.arraycopy(c, 0, result, 0, length);
        return result;
    }

    public void store() throws InvocationTargetException {
        this.store(null);
    }

    public void store(Boolean persist) throws InvocationTargetException {
        PreferencesWrapper pref = PreferencesWrapper.getPreferences(null, persist);
        pref.put(UserPreference, this.serialize());
        pref.put(UserManualPreference, this.serializeManualSetting());
        pref.put(UserBuildPreference, this.serializeBuildSetting());
        pref.put(DelegatesPreference, this.serializeDelegatesSetting());
        try {
            pref.flush();
        }
        catch (BackingStoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected final void loadVersion() throws InvocationTargetException {
        if (this.getResource() == null) {
            throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLRETRIEVE"));
        }
        IMarker[] marker = this.getMarker();
        String version = null;
        version = marker == null ? this.loadVersion(this.getResource()) : this.loadVersion(marker);
        this.setVersion(version);
    }

    protected final String loadVersion(IMarker[] marker) throws InvocationTargetException {
        String version = (String)this.getValue(marker[0], "version");
        if (version == null) {
            return "4.03";
        }
        return version;
    }

    protected final String loadVersion(IResource resource) throws InvocationTargetException {
        try {
            String storedConfiguration = resource.getPersistentProperty(ConfigurationConstants.USER_PREFERENCE);
            String version = null;
            if (storedConfiguration == null) {
                version = ValidationConfiguration.getVersionDefault();
            } else {
                int versionIndex = storedConfiguration.indexOf("version");
                if (versionIndex != -1) {
                    version = storedConfiguration.substring(versionIndex + "version".length());
                }
            }
            if (version == null) {
                return ValidationConfiguration.getVersionDefault();
            }
            return version;
        }
        catch (CoreException exc) {
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{this.getResource().getName()}));
        }
    }

    protected final void load() throws InvocationTargetException {
        try {
            if (this.getResource() == null) {
                throw new InvocationTargetException(null, ResourceHandler.getExternalizedMessage("VBF_EXC_NULLRETRIEVE"));
            }
            IMarker[] marker = this.getMarker();
            if (marker == null) {
                this.loadPreference();
            } else {
                this.load(marker);
            }
        }
        catch (InvocationTargetException exc) {
            throw exc;
        }
        catch (Exception exc) {
            String resourceName = this.getResource() == null ? "null" : this.getResource().getName();
            throw new InvocationTargetException(exc, ResourceHandler.getExternalizedMessage("VBF_EXC_RETRIEVE", new String[]{resourceName}));
        }
    }

    protected abstract IMarker[] getMarker();

    protected abstract void load(IMarker[] var1) throws InvocationTargetException;

    protected Object getValue(IMarker marker, String attribName) {
        if (marker == null) {
            return null;
        }
        try {
            return marker.getAttribute(attribName);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
    }

    protected boolean getValue(IMarker marker, String attribName, boolean defaultValue) {
        Boolean bool = (Boolean)this.getValue(marker, attribName);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }

    protected int getValue(IMarker marker, String attribName, int defaultValue) {
        Integer integer = (Integer)this.getValue(marker, attribName);
        if (integer == null) {
            return defaultValue;
        }
        return integer;
    }

    protected String getValue(IMarker marker, String attribName, String defaultValue) {
        String string = (String)this.getValue(marker, attribName);
        if (string == null) {
            return defaultValue;
        }
        return string;
    }

    protected void loadPreference() throws InvocationTargetException {
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences(null, null);
        this.deserializeAllPrefs(prefs);
    }

    private void deserializeAllPrefs(PreferencesWrapper prefs) throws InvocationTargetException {
        String storedConfig = prefs.get(UserPreference, null);
        this.deserialize(storedConfig);
        String storedManualConfig = prefs.get(UserManualPreference, null);
        this.deserializeManual(storedManualConfig);
        String storedBuildConfig = prefs.get(UserBuildPreference, null);
        this.deserializeBuild(storedBuildConfig);
        String storedDelegatesConfiguration = prefs.get(DelegatesPreference, null);
        this.deserializeDelegates(storedDelegatesConfiguration);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        Preferences prefs = (Preferences)event.getSource();
        if (prefs != null && !event.getOldValue().equals(event.getNewValue())) {
            try {
                this.deserializeAllPrefs(event);
                this.passivate();
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
    }

    private void deserializeAllPrefs(Preferences.PropertyChangeEvent event) throws InvocationTargetException {
        String storedConfig = (String)event.getNewValue();
        if (event.getProperty().equals(UserPreference)) {
            this.deserialize(storedConfig);
        } else if (event.getProperty().equals(UserManualPreference)) {
            this.deserializeManual(storedConfig);
        } else if (event.getProperty().equals(UserBuildPreference)) {
            this.deserializeBuild(storedConfig);
        } else if (event.getProperty().equals(DelegatesPreference)) {
            this.deserializeDelegates(storedConfig);
        }
    }

    protected void deserializeBuild(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals(DefaultValue)) {
            this.resetToDefault();
            return;
        }
        int buildValidationIndex = storedConfiguration.indexOf("enabledBuildValidatorList");
        String manualValidation = storedConfiguration.substring(buildValidationIndex + "enabledBuildValidatorList".length(), storedConfiguration.length());
        this.setEnabledBuildValidators(ValidationConfiguration.getStringAsEnabledElementsArray(manualValidation));
    }

    protected void deserializeManual(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals(DefaultValue)) {
            this.resetToDefault();
            return;
        }
        int manualValidationIndex = storedConfiguration.indexOf("enabledManualValidatorList");
        String manualValidation = storedConfiguration.substring(manualValidationIndex + "enabledManualValidatorList".length(), storedConfiguration.length());
        this.setEnabledManualValidators(ValidationConfiguration.getStringAsEnabledElementsArray(manualValidation));
    }

    protected void deserializeDelegates(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals(DefaultValue)) {
            this.resetToDefault();
            return;
        }
        int delegatesIndex = storedConfiguration.indexOf("delegateValidatorList");
        String delegates = storedConfiguration.substring(delegatesIndex + "delegateValidatorList".length(), storedConfiguration.length());
        if (delegates == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(delegates, ";");
        while (tokenizer.hasMoreTokens()) {
            String delegateConfiguration = tokenizer.nextToken();
            int separatorIndex = delegateConfiguration.indexOf("=");
            String targetID = delegateConfiguration.substring(0, separatorIndex);
            String delegateID = delegateConfiguration.substring(separatorIndex + 1);
            this._delegatesByTarget.put(targetID, delegateID);
        }
    }

    protected void copyTo(ValidationConfiguration up) throws InvocationTargetException {
        up.setVersion(this.getVersion());
        up.setValidators(this.getValidators());
        up.setDisableAllValidation(this.isDisableAllValidation());
        up.setEnabledValidators(this.getEnabledValidators());
        up.setEnabledManualValidators(this.getManualEnabledValidators());
        up.setEnabledBuildValidators(this.getBuildEnabledValidators());
        up.setDelegatingValidators(this.getDelegatingValidators());
    }

    public Map<String, String> getDelegatingValidators() throws InvocationTargetException {
        return this._delegatesByTarget;
    }

    public void setDelegatingValidators(Map<String, String> source) {
        this._delegatesByTarget.putAll(source);
    }

    protected boolean hasEnabledValidatorsChanged(ValidatorMetaData[] oldEnabledVmd) throws InvocationTargetException {
        if (oldEnabledVmd == null) {
            return true;
        }
        int i = 0;
        while (i < oldEnabledVmd.length) {
            ValidatorMetaData vmd = oldEnabledVmd[i];
            if (!this.isEnabled(vmd)) {
                return true;
            }
            ++i;
        }
        return this.numberOfEnabledValidators() != oldEnabledVmd.length;
    }

    protected boolean haveDelegatesChanged(Map<String, String> oldDelegates) throws InvocationTargetException {
        if (oldDelegates == null) {
            return true;
        }
        for (String targetID : oldDelegates.keySet()) {
            String oldDelegateID = oldDelegates.get(targetID);
            String newDelegateID = this._delegatesByTarget.get(targetID);
            if (oldDelegateID == null || newDelegateID == null) {
                return true;
            }
            if (newDelegateID.equals(oldDelegateID)) continue;
            return true;
        }
        return oldDelegates.size() != this._delegatesByTarget.size();
    }

    protected String serialize() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("disableAllValidation");
        buffer.append(String.valueOf(this.isDisableAllValidation()));
        buffer.append("version");
        buffer.append(this.getVersion());
        return buffer.toString();
    }

    protected String serializeManualSetting() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("enabledManualValidatorList");
        buffer.append(ValidationConfiguration.getEnabledElementsAsString(this.getManualEnabledValidators()));
        return buffer.toString();
    }

    protected String serializeBuildSetting() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("enabledBuildValidatorList");
        buffer.append(ValidationConfiguration.getEnabledElementsAsString(this.getBuildEnabledValidators()));
        return buffer.toString();
    }

    protected String serializeDelegatesSetting() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("delegateValidatorList");
        buffer.append(this.getDelegatesAsString(this.getValidatorMetaData()));
        return buffer.toString();
    }

    private String getDelegatesAsString(Map<ValidatorMetaData, Boolean> validatorMetaData) {
        StringBuffer buffer = new StringBuffer();
        for (ValidatorMetaData vmd : validatorMetaData.keySet()) {
            String targetID = vmd.getValidatorUniqueName();
            String delegateID = this.getDelegateUniqueName(vmd);
            if (delegateID == null) continue;
            buffer.append(targetID);
            buffer.append("=");
            buffer.append(delegateID);
            buffer.append(";");
        }
        return buffer.toString();
    }

    public String getDelegateUniqueName(ValidatorMetaData vmd) {
        String targetID = vmd.getValidatorUniqueName();
        return this._delegatesByTarget.get(targetID);
    }

    public String getDelegateForTarget(String targetId) {
        return this._delegatesByTarget.get(targetId);
    }

    public void setDelegateUniqueName(ValidatorMetaData vmd, String delegateID) {
        String targetID = vmd.getValidatorUniqueName();
        this._delegatesByTarget.put(targetID, delegateID);
    }

    protected void deserialize(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals(DefaultValue)) {
            this.resetToDefault();
            return;
        }
        int disableAllValidationIndex = storedConfiguration.indexOf("disableAllValidation");
        int versionIndex = storedConfiguration.indexOf("version");
        if (disableAllValidationIndex != -1) {
            String disableAllValidation = storedConfiguration.substring(disableAllValidationIndex + "disableAllValidation".length(), versionIndex);
            this.setDisableAllValidation(Boolean.valueOf(disableAllValidation));
        } else {
            this.setDisableAllValidation(false);
        }
    }

    public static boolean getDisableValidationDefault() {
        return false;
    }

    public static ValidatorMetaData[] getEnabledValidatorsDefault() {
        return ConfigurationConstants.DEFAULT_ENABLED_VALIDATORS;
    }

    public static int getMaximumNumberOfMessagesDefault() {
        return 50;
    }

    public static String getVersionDefault() {
        return ConfigurationConstants.CURRENT_VERSION;
    }

    public boolean isManualEnabled(ValidatorMetaData vmd) {
        if (vmd == null) {
            return false;
        }
        Boolean value = this.getManualEnabledValidatorsMap().get(vmd);
        if (value == null) {
            return false;
        }
        return value;
    }

    public boolean isBuildEnabled(ValidatorMetaData vmd) {
        if (vmd == null) {
            return false;
        }
        Boolean value = this.getBuildEnabledValidatorsMap().get(vmd);
        if (value == null) {
            return false;
        }
        return value;
    }

    public int numberOfManualEnabledValidators() throws InvocationTargetException {
        return this.getManualEnabledValidators().length;
    }

    public void enableSingleValidator(ValidatorMetaData vmd) {
        this.getValidatorMetaData().put(vmd, Boolean.TRUE);
    }

    public void disableSingleValidator(ValidatorMetaData vmd) {
        this.getValidatorMetaData().put(vmd, Boolean.FALSE);
    }

    public void enableSingleManualValidator(ValidatorMetaData vmd) {
        this.getManualEnabledValidatorsMap().put(vmd, Boolean.TRUE);
    }

    public void disableSingleManualValidator(ValidatorMetaData vmd) {
        this.getManualEnabledValidatorsMap().put(vmd, Boolean.FALSE);
    }

    public void enableSingleBuildValidator(ValidatorMetaData vmd) {
        this.getBuildEnabledValidatorsMap().put(vmd, Boolean.TRUE);
    }

    public void disableSingleBuildValidator(ValidatorMetaData vmd) {
        this.getBuildEnabledValidatorsMap().put(vmd, Boolean.FALSE);
    }

    public ValidatorDelegateDescriptor getDelegateDescriptor(ValidatorMetaData vmd) throws InvocationTargetException {
        String targetID = vmd.getValidatorUniqueName();
        String delegateID = this.getDelegateUniqueName(vmd);
        ValidatorDelegateDescriptor descriptor = ValidatorDelegatesRegistry.getInstance().getDescriptor(targetID, delegateID);
        return descriptor;
    }
}

