/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;

public class ExceptionInfo {
    private final IType fType;
    private final ITypeBinding fTypeBinding;
    private int fKind;
    public static final int OLD = 0;
    public static final int ADDED = 1;
    public static final int DELETED = 2;

    public ExceptionInfo(IType type, int kind, ITypeBinding binding) {
        Assert.isNotNull((Object)type);
        this.fType = type;
        this.fKind = kind;
        this.fTypeBinding = binding;
    }

    public static ExceptionInfo createInfoForOldException(IType type, ITypeBinding binding) {
        return new ExceptionInfo(type, 0, binding);
    }

    public static ExceptionInfo createInfoForAddedException(IType type) {
        return new ExceptionInfo(type, 1, null);
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.fKind = 2;
    }

    public void markAsOld() {
        Assert.isTrue((boolean)this.isDeleted());
        this.fKind = 0;
    }

    public boolean isAdded() {
        return this.fKind == 1;
    }

    public boolean isDeleted() {
        return this.fKind == 2;
    }

    public boolean isOld() {
        return this.fKind == 0;
    }

    public IType getType() {
        return this.fType;
    }

    public int getKind() {
        return this.fKind;
    }

    public ITypeBinding getTypeBinding() {
        return this.fTypeBinding;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        switch (this.fKind) {
            case 0: {
                result.append("OLD: ");
                break;
            }
            case 1: {
                result.append("ADDED: ");
                break;
            }
            case 2: {
                result.append("DELETED: ");
            }
        }
        if (this.fType == null) {
            result.append("null");
        } else {
            result.append(this.fType.toString());
        }
        return result.toString();
    }
}

