/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDNamespaceConstraintCategory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.impl.XSDTermImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDWildcardImpl
extends XSDTermImpl
implements XSDWildcard {
    protected static final XSDNamespaceConstraintCategory NAMESPACE_CONSTRAINT_CATEGORY_EDEFAULT = XSDNamespaceConstraintCategory.ANY_LITERAL;
    protected static final int NAMESPACE_CONSTRAINT_CATEGORY_EFLAG_OFFSET = 8;
    protected static final int NAMESPACE_CONSTRAINT_CATEGORY_EFLAG_DEFAULT = NAMESPACE_CONSTRAINT_CATEGORY_EDEFAULT.ordinal() << 8;
    private static final XSDNamespaceConstraintCategory[] NAMESPACE_CONSTRAINT_CATEGORY_EFLAG_VALUES = XSDNamespaceConstraintCategory.values();
    protected static final int NAMESPACE_CONSTRAINT_CATEGORY_EFLAG = 768;
    protected EList<String> namespaceConstraint;
    protected static final XSDProcessContents PROCESS_CONTENTS_EDEFAULT = XSDProcessContents.STRICT_LITERAL;
    protected static final int PROCESS_CONTENTS_EFLAG_OFFSET = 10;
    protected static final int PROCESS_CONTENTS_EFLAG_DEFAULT = PROCESS_CONTENTS_EDEFAULT.ordinal() << 10;
    private static final XSDProcessContents[] PROCESS_CONTENTS_EFLAG_VALUES = XSDProcessContents.values();
    protected static final int PROCESS_CONTENTS_EFLAG = 3072;
    protected static final int PROCESS_CONTENTS_ESETFLAG = 4096;
    protected EList<String> lexicalNamespaceConstraint;
    protected XSDAnnotation annotation;
    protected EList<XSDAnnotation> annotations;

    public static XSDWildcard createWildcard(Node node) {
        switch (XSDConstants.nodeType(node)) {
            case 2: 
            case 3: {
                XSDWildcard xsdWildcard = XSDFactory.eINSTANCE.createXSDWildcard();
                xsdWildcard.setElement((Element)node);
                return xsdWildcard;
            }
        }
        return null;
    }

    protected XSDWildcardImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_WILDCARD;
    }

    @Override
    public XSDNamespaceConstraintCategory getNamespaceConstraintCategory() {
        return NAMESPACE_CONSTRAINT_CATEGORY_EFLAG_VALUES[(this.eFlags & 0x300) >>> 8];
    }

    @Override
    public void setNamespaceConstraintCategory(XSDNamespaceConstraintCategory newNamespaceConstraintCategory) {
        XSDNamespaceConstraintCategory oldNamespaceConstraintCategory = NAMESPACE_CONSTRAINT_CATEGORY_EFLAG_VALUES[(this.eFlags & 0x300) >>> 8];
        if (newNamespaceConstraintCategory == null) {
            newNamespaceConstraintCategory = NAMESPACE_CONSTRAINT_CATEGORY_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFFCFF | newNamespaceConstraintCategory.ordinal() << 8;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldNamespaceConstraintCategory, (Object)newNamespaceConstraintCategory));
        }
    }

    @Override
    public EList<String> getNamespaceConstraint() {
        if (this.namespaceConstraint == null) {
            this.namespaceConstraint = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 6);
        }
        return this.namespaceConstraint;
    }

    @Override
    public XSDProcessContents getProcessContents() {
        return PROCESS_CONTENTS_EFLAG_VALUES[(this.eFlags & 0xC00) >>> 10];
    }

    @Override
    public void setProcessContents(XSDProcessContents newProcessContents) {
        XSDProcessContents oldProcessContents = PROCESS_CONTENTS_EFLAG_VALUES[(this.eFlags & 0xC00) >>> 10];
        if (newProcessContents == null) {
            newProcessContents = PROCESS_CONTENTS_EDEFAULT;
        }
        this.eFlags = this.eFlags & 0xFFFFF3FF | newProcessContents.ordinal() << 10;
        boolean oldProcessContentsESet = (this.eFlags & 0x1000) != 0;
        this.eFlags |= 0x1000;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldProcessContents, (Object)newProcessContents, !oldProcessContentsESet));
        }
    }

    @Override
    public void unsetProcessContents() {
        XSDProcessContents oldProcessContents = PROCESS_CONTENTS_EFLAG_VALUES[(this.eFlags & 0xC00) >>> 10];
        boolean oldProcessContentsESet = (this.eFlags & 0x1000) != 0;
        this.eFlags = this.eFlags & 0xFFFFF3FF | PROCESS_CONTENTS_EFLAG_DEFAULT;
        this.eFlags &= 0xFFFFEFFF;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 7, (Object)oldProcessContents, (Object)PROCESS_CONTENTS_EDEFAULT, oldProcessContentsESet));
        }
    }

    @Override
    public boolean isSetProcessContents() {
        return (this.eFlags & 0x1000) != 0;
    }

    @Override
    public EList<String> getLexicalNamespaceConstraint() {
        if (this.lexicalNamespaceConstraint == null) {
            this.lexicalNamespaceConstraint = new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 8);
        }
        return this.lexicalNamespaceConstraint;
    }

    @Override
    public void unsetLexicalNamespaceConstraint() {
        if (this.lexicalNamespaceConstraint != null) {
            ((InternalEList.Unsettable)this.lexicalNamespaceConstraint).unset();
        }
    }

    @Override
    public boolean isSetLexicalNamespaceConstraint() {
        return this.lexicalNamespaceConstraint != null && ((InternalEList.Unsettable)this.lexicalNamespaceConstraint).isSet();
    }

    @Override
    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -10, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -10, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public EList<XSDAnnotation> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new EObjectEList(XSDAnnotation.class, (InternalEObject)this, 10);
        }
        return this.annotations;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return this.basicSetAnnotation(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getNamespaceConstraintCategory();
            }
            case 6: {
                return this.getNamespaceConstraint();
            }
            case 7: {
                return this.getProcessContents();
            }
            case 8: {
                return this.getLexicalNamespaceConstraint();
            }
            case 9: {
                return this.getAnnotation();
            }
            case 10: {
                return this.getAnnotations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setNamespaceConstraintCategory((XSDNamespaceConstraintCategory)((Object)newValue));
                return;
            }
            case 6: {
                this.getNamespaceConstraint().clear();
                this.getNamespaceConstraint().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setProcessContents((XSDProcessContents)((Object)newValue));
                return;
            }
            case 8: {
                this.getLexicalNamespaceConstraint().clear();
                this.getLexicalNamespaceConstraint().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 10: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setNamespaceConstraintCategory(NAMESPACE_CONSTRAINT_CATEGORY_EDEFAULT);
                return;
            }
            case 6: {
                this.getNamespaceConstraint().clear();
                return;
            }
            case 7: {
                this.unsetProcessContents();
                return;
            }
            case 8: {
                this.unsetLexicalNamespaceConstraint();
                return;
            }
            case 9: {
                this.setAnnotation(null);
                return;
            }
            case 10: {
                this.getAnnotations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return (this.eFlags & 0x300) != NAMESPACE_CONSTRAINT_CATEGORY_EFLAG_DEFAULT;
            }
            case 6: {
                return this.namespaceConstraint != null && !this.namespaceConstraint.isEmpty();
            }
            case 7: {
                return this.isSetProcessContents();
            }
            case 8: {
                return this.isSetLexicalNamespaceConstraint();
            }
            case 9: {
                return this.annotation != null;
            }
            case 10: {
                return this.annotations != null && !this.annotations.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (namespaceConstraintCategory: ");
        result.append((Object)NAMESPACE_CONSTRAINT_CATEGORY_EFLAG_VALUES[(this.eFlags & 0x300) >>> 8]);
        result.append(", namespaceConstraint: ");
        result.append(this.namespaceConstraint);
        result.append(", processContents: ");
        if ((this.eFlags & 0x1000) != 0) {
            result.append((Object)PROCESS_CONTENTS_EFLAG_VALUES[(this.eFlags & 0xC00) >>> 10]);
        } else {
            result.append("<unset>");
        }
        result.append(", lexicalNamespaceConstraint: ");
        result.append(this.lexicalNamespaceConstraint);
        result.append(')');
        return result.toString();
    }

    @Override
    public Element createElement() {
        Element newElement = this.createElement(this.getContainer() instanceof XSDParticle ? 2 : 3);
        this.setElement(newElement);
        return newElement;
    }

    @Override
    public void patch() {
        super.patch();
        for (String string : this.getLexicalNamespaceConstraint()) {
            if (string.startsWith("##")) continue;
            ((XSDSchemaImpl)this.getSchema()).resolveSchema(string);
        }
    }

    @Override
    protected boolean analyze() {
        super.analyze();
        XSDSchema xsdSchema = this.getSchema();
        XSDNamespaceConstraintCategory newNamespaceConstraintCategory = XSDNamespaceConstraintCategory.ANY_LITERAL;
        ArrayList<String> newNamespaceConstraint = new ArrayList<String>();
        for (String string : this.getLexicalNamespaceConstraint()) {
            String targetNamespace;
            if (string.equals("##any")) break;
            if (string.equals("##other")) {
                newNamespaceConstraintCategory = XSDNamespaceConstraintCategory.NOT_LITERAL;
                targetNamespace = xsdSchema.getTargetNamespace();
                newNamespaceConstraint.add(targetNamespace);
                break;
            }
            if (string.equals("##targetNamespace")) {
                newNamespaceConstraintCategory = XSDNamespaceConstraintCategory.SET_LITERAL;
                targetNamespace = xsdSchema.getTargetNamespace();
                newNamespaceConstraint.add(targetNamespace);
                continue;
            }
            if (string.equals("##local")) {
                newNamespaceConstraintCategory = XSDNamespaceConstraintCategory.SET_LITERAL;
                newNamespaceConstraint.add(null);
                continue;
            }
            newNamespaceConstraintCategory = XSDNamespaceConstraintCategory.SET_LITERAL;
            newNamespaceConstraint.add(string);
        }
        if (this.getNamespaceConstraintCategory() != newNamespaceConstraintCategory) {
            this.setNamespaceConstraintCategory(newNamespaceConstraintCategory);
        }
        EList<String> theNamespaceConstraint = this.getNamespaceConstraint();
        ArrayList<String> remainingNamespaceConstraint = new ArrayList<String>((Collection<String>)theNamespaceConstraint);
        remainingNamespaceConstraint.removeAll(newNamespaceConstraint);
        if (!remainingNamespaceConstraint.isEmpty()) {
            theNamespaceConstraint.removeAll(remainingNamespaceConstraint);
        }
        if (!newNamespaceConstraint.isEmpty()) {
            XSDWildcardImpl.setListContentAndOrder(theNamespaceConstraint, newNamespaceConstraint);
        }
        return true;
    }

    @Override
    public void validate() {
        super.validate();
        String anchor = null;
        String contentType = null;
        Element theElement = this.getElement();
        if (theElement != null) {
            String[] attributes = null;
            if (this.getContainer() instanceof XSDParticle) {
                anchor = "element-any";
                contentType = "wildcard";
                attributes = new String[]{"id", "maxOccurs", "minOccurs", "namespace", "processContents"};
                this.checkAttributeTypeConstraint(contentType, "maxOccurs", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "maxOccurs", false);
                this.checkAttributeTypeConstraint(contentType, "minOccurs", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "minOccurs", false);
            } else {
                anchor = "element-anyAttribute";
                contentType = "wildcard";
                attributes = new String[]{"id", "namespace", "processContents"};
            }
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", anchor, theElement, attributes);
            this.checkComplexContent(contentType, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "id", false);
            this.checkAttributeTypeConstraint(contentType, "namespace", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "namespace", false);
            this.checkAttributeTypeConstraint(contentType, "processContents", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "processContents", false);
        }
    }

    @Override
    protected boolean isUpdatingDOM() {
        return super.isUpdatingDOM() || this.getContainer() instanceof XSDParticle && ((XSDConcreteComponentImpl)this.getContainer()).isUpdatingDOM();
    }

    @Override
    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            if (changedElement.hasAttributeNS(null, "processContents")) {
                XSDProcessContents newProcessContents = XSDProcessContents.get(changedElement.getAttributeNS(null, "processContents"));
                if (!this.isSetProcessContents() || newProcessContents != this.getProcessContents()) {
                    this.setProcessContents(newProcessContents);
                }
            } else if (this.isSetProcessContents()) {
                this.unsetProcessContents();
            }
            if (changedElement.hasAttributeNS(null, "namespace")) {
                String newLexicalNamespaceConstraint = changedElement.getAttributeNS(null, "namespace");
                if (!newLexicalNamespaceConstraint.equals(this.getStringLexicalNamespaceConstraint())) {
                    this.setStringLexicalNamespaceConstraint(newLexicalNamespaceConstraint);
                }
            } else if (this.isSetLexicalNamespaceConstraint()) {
                this.unsetLexicalNamespaceConstraint();
            }
        }
    }

    @Override
    protected void handleUnreconciledElement(Element child, List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        if (XSDConstants.nodeType(child) == 1) {
            XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
            newContents.add(xsdAnnotation);
        }
    }

    @Override
    protected void handleReconciliation(List<XSDConcreteComponent> newContents, List<XSDConcreteComponent> remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.Literals.XSD_WILDCARD__ANNOTATION, newContents, remainingContents);
    }

    @Override
    protected void changeAttribute(EAttribute eAttribute) {
        if (this.isReconciling) {
            return;
        }
        super.changeAttribute(eAttribute);
        Element theElement = this.getElement();
        if (theElement != null) {
            if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_WILDCARD__LEXICAL_NAMESPACE_CONSTRAINT) {
                if (!this.isSetLexicalNamespaceConstraint()) {
                    this.niceSetAttribute(theElement, "namespace", null);
                } else {
                    EList<String> theLexicalNamespaceConstraint = this.getLexicalNamespaceConstraint();
                    StringBuffer result = new StringBuffer();
                    for (String value : theLexicalNamespaceConstraint) {
                        if (result.length() != 0) {
                            result.append(' ');
                        }
                        result.append(value);
                    }
                    this.niceSetAttribute(theElement, "namespace", result.toString());
                }
                if (eAttribute != null) {
                    this.traverseToRootForPatching();
                }
            }
            if (eAttribute == null || eAttribute == XSDPackage.Literals.XSD_WILDCARD__PROCESS_CONTENTS) {
                XSDProcessContents theProcessContents = this.getProcessContents();
                this.niceSetAttribute(theElement, "processContents", this.isSetProcessContents() ? theProcessContents.getName() : null);
            }
        }
    }

    @Override
    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_WILDCARD__ANNOTATION) {
            this.getAnnotations().add((Object)((XSDAnnotation)xsdConcreteComponent));
        }
    }

    @Override
    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        int index;
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.Literals.XSD_WILDCARD__ANNOTATION && (index = this.getAnnotations().indexOf((Object)xsdConcreteComponent)) >= 0) {
            this.getAnnotations().remove(index);
        }
    }

    @Override
    public String getStringNamespaceConstraint() {
        StringBuffer result = new StringBuffer();
        for (String value : this.getNamespaceConstraint()) {
            if (result.length() != 0) {
                result.append(' ');
            }
            if (value == null || value.length() == 0) {
                result.append("'absent'");
                continue;
            }
            result.append(value);
        }
        return result.toString();
    }

    @Override
    public String getStringLexicalNamespaceConstraint() {
        if (this.isSetLexicalNamespaceConstraint()) {
            StringBuffer result = new StringBuffer();
            for (String value : this.getLexicalNamespaceConstraint()) {
                if (result.length() != 0) {
                    result.append(' ');
                }
                result.append(value);
            }
            return result.toString();
        }
        return null;
    }

    @Override
    public void setStringLexicalNamespaceConstraint(String lexicalNamespaceConstraint) {
        if (lexicalNamespaceConstraint == null) {
            this.unsetLexicalNamespaceConstraint();
        } else {
            ArrayList<String> newLexicalNamespaceConstraint = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(lexicalNamespaceConstraint);
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                newLexicalNamespaceConstraint.add(token);
            }
            if (!newLexicalNamespaceConstraint.equals(this.getLexicalNamespaceConstraint())) {
                ArrayList<String> oldContents = new ArrayList<String>((Collection<String>)this.getLexicalNamespaceConstraint());
                oldContents.removeAll(newLexicalNamespaceConstraint);
                if (!oldContents.isEmpty()) {
                    this.getLexicalNamespaceConstraint().removeAll(oldContents);
                }
                XSDWildcardImpl.setListContentAndOrder(this.getLexicalNamespaceConstraint(), newLexicalNamespaceConstraint);
            } else if (newLexicalNamespaceConstraint.isEmpty() && !this.isSetLexicalNamespaceConstraint()) {
                this.getLexicalNamespaceConstraint().clear();
            }
        }
    }

    @Override
    public boolean isWildcardSubset(XSDWildcard superSetWildcard) {
        if (XSDNamespaceConstraintCategory.ANY_LITERAL == superSetWildcard.getNamespaceConstraintCategory()) {
            return true;
        }
        if (XSDNamespaceConstraintCategory.NOT_LITERAL == this.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.NOT_LITERAL == superSetWildcard.getNamespaceConstraintCategory() && this.getNamespaceConstraint().equals(superSetWildcard.getNamespaceConstraint())) {
            return true;
        }
        return XSDNamespaceConstraintCategory.SET_LITERAL == this.getNamespaceConstraintCategory() && (XSDNamespaceConstraintCategory.SET_LITERAL == superSetWildcard.getNamespaceConstraintCategory() && superSetWildcard.getNamespaceConstraint().containsAll(this.getNamespaceConstraint()) || XSDNamespaceConstraintCategory.NOT_LITERAL == superSetWildcard.getNamespaceConstraintCategory() && !this.getNamespaceConstraint().containsAll(superSetWildcard.getNamespaceConstraint()));
    }

    @Override
    public XSDWildcard attributeWildcardUnion(XSDWildcard otherWildcard) {
        if (this.getNamespaceConstraintCategory() == otherWildcard.getNamespaceConstraintCategory() && this.getNamespaceConstraint().containsAll(otherWildcard.getNamespaceConstraint()) && otherWildcard.getNamespaceConstraint().containsAll(this.getNamespaceConstraint())) {
            return this;
        }
        if (XSDNamespaceConstraintCategory.ANY_LITERAL == this.getNamespaceConstraintCategory()) {
            return this;
        }
        if (XSDNamespaceConstraintCategory.ANY_LITERAL == otherWildcard.getNamespaceConstraintCategory()) {
            return otherWildcard;
        }
        if (XSDNamespaceConstraintCategory.SET_LITERAL == this.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.SET_LITERAL == otherWildcard.getNamespaceConstraintCategory()) {
            XSDWildcard result = this.getXSDFactory().createXSDWildcard();
            if (this.isSetProcessContents()) {
                result.setProcessContents(this.getProcessContents());
            }
            result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.SET_LITERAL);
            ArrayList<String> newNamespaceConstraint = new ArrayList<String>((Collection<String>)this.getNamespaceConstraint());
            for (String value : otherWildcard.getNamespaceConstraint()) {
                if (newNamespaceConstraint.contains(value)) continue;
                newNamespaceConstraint.add(value);
            }
            result.getNamespaceConstraint().addAll(newNamespaceConstraint);
            return result;
        }
        if (XSDNamespaceConstraintCategory.NOT_LITERAL == this.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.NOT_LITERAL == otherWildcard.getNamespaceConstraintCategory() && !this.getNamespaceConstraint().equals(otherWildcard.getNamespaceConstraint())) {
            return null;
        }
        if (XSDNamespaceConstraintCategory.SET_LITERAL == this.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.NOT_LITERAL == otherWildcard.getNamespaceConstraintCategory()) {
            if (this.getNamespaceConstraint().containsAll(otherWildcard.getNamespaceConstraint())) {
                XSDWildcard result = this.getXSDFactory().createXSDWildcard();
                if (this.isSetProcessContents()) {
                    result.setProcessContents(this.getProcessContents());
                }
                result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.ANY_LITERAL);
                return result;
            }
            return otherWildcard;
        }
        if (XSDNamespaceConstraintCategory.SET_LITERAL == otherWildcard.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.NOT_LITERAL == this.getNamespaceConstraintCategory()) {
            if (otherWildcard.getNamespaceConstraint().containsAll(this.getNamespaceConstraint())) {
                XSDWildcard result = this.getXSDFactory().createXSDWildcard();
                if (this.isSetProcessContents()) {
                    result.setProcessContents(this.getProcessContents());
                }
                result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.ANY_LITERAL);
                return result;
            }
            return this;
        }
        XSDWildcard result = this.getXSDFactory().createXSDWildcard();
        result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.NOT_LITERAL);
        return result;
    }

    @Override
    public XSDWildcard attributeWildcardIntersection(XSDWildcard otherWildcard) {
        if (this.getNamespaceConstraintCategory() == otherWildcard.getNamespaceConstraintCategory() && this.getNamespaceConstraint().containsAll(otherWildcard.getNamespaceConstraint()) && otherWildcard.getNamespaceConstraint().containsAll(this.getNamespaceConstraint())) {
            return this;
        }
        if (XSDNamespaceConstraintCategory.ANY_LITERAL == this.getNamespaceConstraintCategory()) {
            return otherWildcard;
        }
        if (XSDNamespaceConstraintCategory.ANY_LITERAL == otherWildcard.getNamespaceConstraintCategory()) {
            return this;
        }
        if (XSDNamespaceConstraintCategory.SET_LITERAL == this.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.NOT_LITERAL == otherWildcard.getNamespaceConstraintCategory()) {
            if (this.getNamespaceConstraint().containsAll(otherWildcard.getNamespaceConstraint()) || this.getNamespaceConstraint().contains(null)) {
                XSDWildcard result = this.getXSDFactory().createXSDWildcard();
                if (this.isSetProcessContents()) {
                    result.setProcessContents(this.getProcessContents());
                }
                result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.SET_LITERAL);
                ArrayList<String> newNamespaceConstraint = new ArrayList<String>((Collection<String>)this.getNamespaceConstraint());
                newNamespaceConstraint.removeAll((Collection<?>)otherWildcard.getNamespaceConstraint());
                newNamespaceConstraint.remove(null);
                result.getNamespaceConstraint().addAll(newNamespaceConstraint);
                return result;
            }
            return this;
        }
        if (XSDNamespaceConstraintCategory.SET_LITERAL == otherWildcard.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.NOT_LITERAL == this.getNamespaceConstraintCategory()) {
            if (otherWildcard.getNamespaceConstraint().containsAll(this.getNamespaceConstraint()) || otherWildcard.getNamespaceConstraint().contains(null)) {
                XSDWildcard result = this.getXSDFactory().createXSDWildcard();
                if (this.isSetProcessContents()) {
                    result.setProcessContents(this.getProcessContents());
                }
                result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.SET_LITERAL);
                ArrayList<String> newNamespaceConstraint = new ArrayList<String>((Collection<String>)otherWildcard.getNamespaceConstraint());
                newNamespaceConstraint.removeAll((Collection<?>)this.getNamespaceConstraint());
                newNamespaceConstraint.remove(null);
                result.getNamespaceConstraint().addAll(newNamespaceConstraint);
                return result;
            }
            return otherWildcard;
        }
        if (XSDNamespaceConstraintCategory.SET_LITERAL == this.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.SET_LITERAL == otherWildcard.getNamespaceConstraintCategory()) {
            XSDWildcard result = this.getXSDFactory().createXSDWildcard();
            if (this.isSetProcessContents()) {
                result.setProcessContents(this.getProcessContents());
            }
            result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.SET_LITERAL);
            ArrayList<String> newNamespaceConstraint = new ArrayList<String>((Collection<String>)this.getNamespaceConstraint());
            newNamespaceConstraint.retainAll((Collection<?>)otherWildcard.getNamespaceConstraint());
            result.getNamespaceConstraint().addAll(newNamespaceConstraint);
            return result;
        }
        if (XSDNamespaceConstraintCategory.NOT_LITERAL == this.getNamespaceConstraintCategory() && XSDNamespaceConstraintCategory.NOT_LITERAL == otherWildcard.getNamespaceConstraintCategory()) {
            if (this.getNamespaceConstraint().size() == 1 && this.getNamespaceConstraint().contains(null)) {
                return otherWildcard;
            }
            if (otherWildcard.getNamespaceConstraint().size() == 1 && otherWildcard.getNamespaceConstraint().contains(null)) {
                return this;
            }
            XSDWildcard result = this.getXSDFactory().createXSDWildcard();
            result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.NOT_LITERAL);
            return result;
        }
        XSDWildcard result = this.getXSDFactory().createXSDWildcard();
        result.setNamespaceConstraintCategory(XSDNamespaceConstraintCategory.NOT_LITERAL);
        return result;
    }

    public void setLike(XSDWildcard xsdWildcard) {
        EList<String> newNamespaceConstraint;
        EList<String> theNamespaceConstraint;
        if (this.getNamespaceConstraintCategory() != xsdWildcard.getNamespaceConstraintCategory()) {
            this.setNamespaceConstraintCategory(xsdWildcard.getNamespaceConstraintCategory());
        }
        if (!(theNamespaceConstraint = this.getNamespaceConstraint()).containsAll(newNamespaceConstraint = xsdWildcard.getNamespaceConstraint()) || !newNamespaceConstraint.containsAll(theNamespaceConstraint)) {
            ArrayList<String> remainingNamespaceConstraint = new ArrayList<String>((Collection<String>)theNamespaceConstraint);
            remainingNamespaceConstraint.removeAll((Collection<?>)newNamespaceConstraint);
            if (!remainingNamespaceConstraint.isEmpty()) {
                theNamespaceConstraint.removeAll(remainingNamespaceConstraint);
            }
            if (!newNamespaceConstraint.isEmpty()) {
                XSDWildcardImpl.setListContentAndOrder(theNamespaceConstraint, newNamespaceConstraint);
            }
        }
        if (xsdWildcard.isSetProcessContents()) {
            if (this.getProcessContents() != xsdWildcard.getProcessContents()) {
                this.setProcessContents(xsdWildcard.getProcessContents());
            }
        } else {
            this.unsetProcessContents();
        }
    }

    @Override
    public boolean allows(String namespace) {
        switch (this.getNamespaceConstraintCategory().getValue()) {
            case 0: {
                return true;
            }
            case 1: {
                return namespace != null && !this.getNamespaceConstraint().contains((Object)namespace);
            }
            case 2: {
                return this.getNamespaceConstraint().contains((Object)namespace);
            }
        }
        return false;
    }

    @Override
    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDWildcardImpl clonedWildcard = (XSDWildcardImpl)this.getXSDFactory().createXSDWildcard();
        clonedWildcard.isReconciling = true;
        if (this.isSetLexicalNamespaceConstraint()) {
            if (!this.getLexicalNamespaceConstraint().isEmpty()) {
                clonedWildcard.getLexicalNamespaceConstraint().addAll(this.getLexicalNamespaceConstraint());
            } else {
                clonedWildcard.getLexicalNamespaceConstraint().clear();
            }
        }
        if (this.isSetProcessContents()) {
            clonedWildcard.setProcessContents(this.getProcessContents());
        }
        if (deep && this.getAnnotation() != null) {
            clonedWildcard.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedWildcard.setElement(this.getElement());
        }
        clonedWildcard.isReconciling = shareDOM;
        return clonedWildcard;
    }
}

