/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.perf.profiling.core.trace;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.perf.profiling.core.trace.PerfCpuAspect;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.PerfEventLayout;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.event.aspect.CtfChannelAspect;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class PerfCtfTrace
extends CtfTmfTrace
implements IKernelTrace {
    private static final Collection<@NonNull ITmfEventAspect<?>> PERF_CTF_ASPECTS = ImmutableList.of((Object)TmfBaseAspects.getTimestampAspect(), (Object)new CtfChannelAspect(), (Object)((Object)new PerfCpuAspect()), (Object)TmfBaseAspects.getEventTypeAspect(), (Object)TmfBaseAspects.getContentsAspect());
    private static final int CONFIDENCE = 101;
    private static final String PERF_DOMAIN = "\"perf\"";

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return PERF_CTF_ASPECTS;
    }

    public @Nullable IStatus validate(@Nullable IProject project, @Nullable String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Map environment = Objects.requireNonNull(((CtfTraceValidationStatus)status).getEnvironment());
            String domain = (String)environment.get("tracer_name");
            if (!PERF_DOMAIN.equals(domain)) {
                return new Status(4, "org.eclipse.tracecompass.incubator.perf.profiling.core", "This trace is not a perf trace");
            }
            return new TraceValidationStatus(101, "org.eclipse.tracecompass.incubator.perf.profiling.core");
        }
        return status;
    }

    public IKernelAnalysisEventLayout getKernelEventLayout() {
        return PerfEventLayout.getInstance();
    }
}

