/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.manager.AbstractPrototypeRefPair;
import org.osgi.framework.ServiceReference;

public class MultiplePrototypeRefPair<S, T>
extends AbstractPrototypeRefPair<S, T> {
    private final ConcurrentMap<ScrComponentContext, T> instances = new ConcurrentHashMap<ScrComponentContext, T>();

    public MultiplePrototypeRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public String toString() {
        return "[MultiplePrototypeRefPair: ref: [" + this.getRef() + "] has service: [" + !this.instances.isEmpty() + "]]";
    }

    @Override
    public T getServiceObject(ScrComponentContext key) {
        return (T)this.instances.get(key);
    }

    @Override
    public boolean setServiceObject(ScrComponentContext key, T serviceObject) {
        return this.instances.putIfAbsent(key, serviceObject) == null;
    }

    @Override
    protected T remove(ScrComponentContext key) {
        return (T)this.instances.remove(key);
    }

    @Override
    protected Collection<Map.Entry<ScrComponentContext, T>> clearEntries() {
        ArrayList<Map.Entry<ScrComponentContext, T>> result = new ArrayList<Map.Entry<ScrComponentContext, T>>(this.instances.entrySet());
        this.instances.clear();
        return result;
    }
}

