/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;

public class AttributeUtil {
    private static final String[] ATTRIBUTE_NORETURN = new String[]{"__noreturn__", "noreturn"};
    private static final String[] ATTRIBUTE_NODISCARD = new String[]{"warn_unused_result", "nodiscard"};

    private AttributeUtil() {
    }

    public static boolean hasAttribute(IASTAttributeOwner node, String[] names) {
        IASTAttribute[] attributes;
        IASTAttribute[] iASTAttributeArray = attributes = node.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IASTAttribute attribute = iASTAttributeArray[n2];
            char[] name = attribute.getName();
            int i = 0;
            while (i < names.length) {
                if (CharArrayUtils.equals(name, names[i])) {
                    return true;
                }
                ++i;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasNoreturnAttribute(IASTAttributeOwner node) {
        return AttributeUtil.hasAttribute(node, ATTRIBUTE_NORETURN);
    }

    public static boolean hasNodiscardAttribute(IASTAttributeOwner node) {
        return AttributeUtil.hasAttribute(node, ATTRIBUTE_NODISCARD);
    }

    public static char[] getSimpleArgument(IASTAttribute attribute) {
        IASTToken argumentClause = attribute.getArgumentClause();
        return argumentClause == null ? null : argumentClause.getTokenCharImage();
    }
}

