/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.server;

import ch.epfl.scala.bsp4j.BuildServer;
import ch.epfl.scala.bsp4j.CleanCacheParams;
import ch.epfl.scala.bsp4j.CleanCacheResult;
import ch.epfl.scala.bsp4j.CompileParams;
import ch.epfl.scala.bsp4j.CompileResult;
import ch.epfl.scala.bsp4j.DebugSessionAddress;
import ch.epfl.scala.bsp4j.DebugSessionParams;
import ch.epfl.scala.bsp4j.DependencyModulesParams;
import ch.epfl.scala.bsp4j.DependencyModulesResult;
import ch.epfl.scala.bsp4j.DependencySourcesParams;
import ch.epfl.scala.bsp4j.DependencySourcesResult;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import ch.epfl.scala.bsp4j.InverseSourcesParams;
import ch.epfl.scala.bsp4j.InverseSourcesResult;
import ch.epfl.scala.bsp4j.JavaBuildServer;
import ch.epfl.scala.bsp4j.JavacOptionsParams;
import ch.epfl.scala.bsp4j.JavacOptionsResult;
import ch.epfl.scala.bsp4j.OutputPathsParams;
import ch.epfl.scala.bsp4j.OutputPathsResult;
import ch.epfl.scala.bsp4j.ResourcesParams;
import ch.epfl.scala.bsp4j.ResourcesResult;
import ch.epfl.scala.bsp4j.RunParams;
import ch.epfl.scala.bsp4j.RunResult;
import ch.epfl.scala.bsp4j.ScalaBuildServer;
import ch.epfl.scala.bsp4j.ScalaMainClassesParams;
import ch.epfl.scala.bsp4j.ScalaMainClassesResult;
import ch.epfl.scala.bsp4j.ScalaTestClassesParams;
import ch.epfl.scala.bsp4j.ScalaTestClassesResult;
import ch.epfl.scala.bsp4j.ScalacOptionsParams;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import ch.epfl.scala.bsp4j.SourcesParams;
import ch.epfl.scala.bsp4j.SourcesResult;
import ch.epfl.scala.bsp4j.TestParams;
import ch.epfl.scala.bsp4j.TestResult;
import ch.epfl.scala.bsp4j.WorkspaceBuildTargetsResult;
import com.microsoft.java.bs.core.Launcher;
import com.microsoft.java.bs.core.internal.log.BspTraceEntity;
import com.microsoft.java.bs.core.internal.services.BuildTargetService;
import com.microsoft.java.bs.core.internal.services.LifecycleService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class GradleBuildServer
implements BuildServer,
JavaBuildServer,
ScalaBuildServer {
    private LifecycleService lifecycleService;
    private BuildTargetService buildTargetService;

    public GradleBuildServer(LifecycleService lifecycleService, BuildTargetService buildTargetService) {
        this.lifecycleService = lifecycleService;
        this.buildTargetService = buildTargetService;
    }

    public CompletableFuture<InitializeBuildResult> buildInitialize(InitializeBuildParams params) {
        return this.handleRequest("build/initialize", cc -> this.lifecycleService.initializeServer(params));
    }

    public void onBuildInitialized() {
        this.handleNotification("build/initialized", this.lifecycleService::onBuildInitialized, true);
    }

    public CompletableFuture<Object> buildShutdown() {
        return this.handleRequest("build/shutdown", cc -> this.lifecycleService.shutdown());
    }

    public void onBuildExit() {
        this.handleNotification("build/exit", this.lifecycleService::exit, false);
    }

    public CompletableFuture<WorkspaceBuildTargetsResult> workspaceBuildTargets() {
        return this.handleRequest("workspace/buildTargets", cc -> this.buildTargetService.getWorkspaceBuildTargets());
    }

    public CompletableFuture<Object> workspaceReload() {
        return this.handleRequest("workspace/reload", cc -> {
            this.buildTargetService.reloadWorkspace();
            return null;
        });
    }

    public CompletableFuture<SourcesResult> buildTargetSources(SourcesParams params) {
        return this.handleRequest("buildTarget/sources", cc -> this.buildTargetService.getBuildTargetSources(params));
    }

    public CompletableFuture<InverseSourcesResult> buildTargetInverseSources(InverseSourcesParams params) {
        throw new UnsupportedOperationException("Unimplemented method 'buildTargetInverseSources'");
    }

    public CompletableFuture<DependencySourcesResult> buildTargetDependencySources(DependencySourcesParams params) {
        return this.handleRequest("buildTarget/dependencySources", cc -> this.buildTargetService.getBuildTargetDependencySources(params));
    }

    public CompletableFuture<ResourcesResult> buildTargetResources(ResourcesParams params) {
        return this.handleRequest("buildTarget/resources", cc -> this.buildTargetService.getBuildTargetResources(params));
    }

    public CompletableFuture<OutputPathsResult> buildTargetOutputPaths(OutputPathsParams params) {
        return this.handleRequest("buildTarget/outputPaths", cc -> this.buildTargetService.getBuildTargetOutputPaths(params));
    }

    public CompletableFuture<CompileResult> buildTargetCompile(CompileParams params) {
        return this.handleRequest("buildTarget/compile", cc -> this.buildTargetService.compile(params));
    }

    public CompletableFuture<TestResult> buildTargetTest(TestParams params) {
        return this.handleRequest("buildTarget/test", cc -> this.buildTargetService.buildTargetTest(params));
    }

    public CompletableFuture<RunResult> buildTargetRun(RunParams params) {
        throw new UnsupportedOperationException("Unimplemented method 'buildTargetRun'");
    }

    public CompletableFuture<DebugSessionAddress> debugSessionStart(DebugSessionParams params) {
        throw new UnsupportedOperationException("Unimplemented method 'debugSessionStart'");
    }

    public CompletableFuture<CleanCacheResult> buildTargetCleanCache(CleanCacheParams params) {
        return this.handleRequest("buildTarget/cleanCache", cc -> this.buildTargetService.cleanCache(params));
    }

    public CompletableFuture<DependencyModulesResult> buildTargetDependencyModules(DependencyModulesParams params) {
        return this.handleRequest("buildTarget/dependencyModules", cc -> this.buildTargetService.getBuildTargetDependencyModules(params));
    }

    public CompletableFuture<JavacOptionsResult> buildTargetJavacOptions(JavacOptionsParams params) {
        return this.handleRequest("buildTarget/javacOptions", cc -> this.buildTargetService.getBuildTargetJavacOptions(params));
    }

    public CompletableFuture<ScalacOptionsResult> buildTargetScalacOptions(ScalacOptionsParams params) {
        return this.handleRequest("buildTarget/scalacOptions", cc -> this.buildTargetService.getBuildTargetScalacOptions(params));
    }

    public CompletableFuture<ScalaTestClassesResult> buildTargetScalaTestClasses(ScalaTestClassesParams params) {
        throw new UnsupportedOperationException("Unimplemented method 'buildTargetScalaTestClasses'");
    }

    public CompletableFuture<ScalaMainClassesResult> buildTargetScalaMainClasses(ScalaMainClassesParams params) {
        throw new UnsupportedOperationException("Unimplemented method 'buildTargetScalaMainClasses'");
    }

    private void handleNotification(String methodName, Runnable runnable, boolean async) {
        BspTraceEntity entity = new BspTraceEntity.Builder().operationName(this.escapeMethodName(methodName)).build();
        Launcher.LOGGER.log(Level.INFO, "Received notification '" + methodName + "'.", entity);
        if (async) {
            CompletableFuture.runAsync(runnable);
        } else {
            runnable.run();
        }
    }

    private <R> CompletableFuture<R> handleRequest(String methodName, Function<CancelChecker, R> supplier) {
        return this.runAsync(methodName, supplier);
    }

    public <T, R> CompletableFuture<R> handleRequest(String methodName, BiFunction<CancelChecker, T, R> function, T arg) {
        Launcher.LOGGER.info("Received request '" + methodName + "'.");
        return this.runAsync(methodName, cancelChecker -> function.apply((CancelChecker)cancelChecker, arg));
    }

    private <T> CompletableFuture<T> runAsync(String methodName, Function<CancelChecker, T> request) {
        long startTime = System.nanoTime();
        return ((CompletableFuture)((CompletableFuture)CompletableFutures.computeAsync(request).thenApply(Either::forRight)).exceptionally(Either::forLeft)).thenCompose(either -> {
            long elapsedTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            return either.isLeft() ? this.failure(methodName, (Throwable)either.getLeft()) : this.success(methodName, either.getRight(), elapsedTime);
        });
    }

    private <T> CompletableFuture<T> success(String methodName, T response, long elapsedTime) {
        BspTraceEntity entity = new BspTraceEntity.Builder().operationName(this.escapeMethodName(methodName)).duration(String.valueOf(elapsedTime)).build();
        String message = String.format("Sending response '%s'. Processing request took %d ms.", methodName, elapsedTime);
        Launcher.LOGGER.log(Level.INFO, message, entity);
        return CompletableFuture.completedFuture(response);
    }

    private <T> CompletableFuture<T> failure(String methodName, Throwable throwable) {
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)throwable);
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        String rootCauseMessage = rootCause != null ? rootCause.getMessage() : null;
        BspTraceEntity entity = new BspTraceEntity.Builder().operationName(this.escapeMethodName(methodName)).trace(stackTrace).rootCauseMessage(rootCauseMessage).build();
        String message = String.format("Failed to process '%s': %s", methodName, stackTrace);
        Launcher.LOGGER.log(Level.SEVERE, message, entity);
        if (throwable instanceof ResponseErrorException) {
            return CompletableFuture.failedFuture(throwable);
        }
        return CompletableFuture.failedFuture((Throwable)new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, rootCauseMessage == null ? throwable.getMessage() : rootCauseMessage, null)));
    }

    private String escapeMethodName(String name) {
        return name.replace('/', '-');
    }
}

