/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import java.util.List;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.references.XMLReferencesPlugin;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchQuery;
import org.eclipse.lemminx.extensions.references.search.SearchQueryFactory;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLReferencesHighlightingParticipant
implements IHighlightingParticipant {
    private final XMLReferencesPlugin plugin;

    public XMLReferencesHighlightingParticipant(XMLReferencesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void findDocumentHighlights(DOMNode node, Position position, int offset, List<DocumentHighlight> highlights, CancelChecker cancelChecker) {
        SearchQuery query = SearchQueryFactory.createToQueryByRetrievingToBefore(node, offset, this.plugin.getReferencesSettings(), cancelChecker);
        if (query == null) {
            return;
        }
        query.setMatchNode(true);
        query.setSearchInIncludedFiles(false);
        highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(query.getSearchNode()), DocumentHighlightKind.Write));
        SearchEngine.getInstance().search(query, (fromSearchNode, toSearchNode, expression) -> highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(fromSearchNode), DocumentHighlightKind.Read)), cancelChecker);
    }
}

