/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;

public class RecorderServer {
    private BotGeneratorEventDispatcher recorder;

    public RecorderServer(BotGeneratorEventDispatcher recorder) {
        this.recorder = recorder;
    }

    public void start(int port) {
        this.recorder.setRecording(true);
        ConnectionListener connectionListener = new ConnectionListener(port);
        connectionListener.start();
    }

    private class ConnectionHandler
    implements BotGeneratorEventDispatcher.CodeGenerationListener {
        private PrintWriter output;

        public ConnectionHandler(Socket socket) {
            try {
                this.output = new PrintWriter(socket.getOutputStream(), true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void handleCodeGenerated(GenerationRule code) {
            for (String text : code.getActions()) {
                this.output.println(text);
            }
        }
    }

    private class ConnectionListener
    extends Thread {
        private int port;

        public ConnectionListener(int port) {
            this.port = port;
        }

        @Override
        public void run() {
            try {
                ServerSocket serverSocket = new ServerSocket(this.port);
                while (!ConnectionListener.interrupted()) {
                    ConnectionHandler connectionHandler = new ConnectionHandler(serverSocket.accept());
                    RecorderServer.this.recorder.addListener(connectionHandler);
                }
                serverSocket.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start server - There was a problem starting the recorder server. Try restarting using a different port number.");
            }
        }
    }
}

