/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.internal.wizard.project.WorkingSetChangedListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetConfigurationBlock;

public final class WorkingSetConfigurationWidget
extends WorkingSetConfigurationBlock {
    private final List<WorkingSetChangedListener> listener = new CopyOnWriteArrayList<WorkingSetChangedListener>();
    private Button workingSetsEnabledButton;
    private Combo workingSetsCombo;
    private Button workingSetsSelectButton;

    public WorkingSetConfigurationWidget(String[] workingSetIds, IDialogSettings settings) {
        super(workingSetIds, settings);
    }

    public WorkingSetConfigurationWidget(String[] workingSetIds, IDialogSettings settings, String addButtonLabel, String comboLabel, String selectLabel) {
        super(workingSetIds, settings, addButtonLabel, comboLabel, selectLabel);
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        Label workingSetsLabel = this.findWorkingSetsLabel(parent);
        workingSetsLabel.setText(workingSetsLabel.getText().replace(":", ""));
        this.workingSetsEnabledButton = this.findWorkingSetsEnabledButton(parent);
        this.workingSetsEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationWidget.this.fireWorkingSetChanged();
            }
        });
        this.workingSetsCombo = this.findWorkingSetsCombo(parent);
        this.workingSetsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorkingSetConfigurationWidget.this.fireWorkingSetChanged();
            }
        });
        this.workingSetsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationWidget.this.fireWorkingSetChanged();
            }
        });
        this.workingSetsSelectButton = this.findWorkingSetsSelectButton(parent);
    }

    private Label findWorkingSetsLabel(Composite parent) {
        return (Label)this.findControl(parent, (Predicate<? super Control>)Predicates.instanceOf(Label.class));
    }

    private Button findWorkingSetsEnabledButton(Composite parent) {
        return (Button)this.findControl(parent, (Predicate<? super Control>)Predicates.instanceOf(Button.class));
    }

    private Combo findWorkingSetsCombo(Composite parent) {
        return (Combo)this.findControl(parent, (Predicate<? super Control>)Predicates.instanceOf(Combo.class));
    }

    private Button findWorkingSetsSelectButton(Composite parent) {
        Predicate isButton = Predicates.instanceOf(Button.class);
        Predicate<Control> hasPushStyle = new Predicate<Control>(){

            public boolean apply(Control control) {
                return (control.getStyle() & 8) == 8;
            }
        };
        return (Button)this.findControl(parent, (Predicate<? super Control>)Predicates.and((Predicate)isButton, (Predicate)hasPushStyle));
    }

    private Control findControl(Composite parent, Predicate<? super Control> predicate) {
        Control result = this.findControlRecursively(parent, predicate);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("Cannot find control under the root composite matching to the provided condition.");
    }

    private Control findControlRecursively(Composite parent, Predicate<? super Control> predicate) {
        Control[] children;
        for (Control control : children = parent.getChildren()) {
            Control result;
            if (predicate.apply((Object)control)) {
                return control;
            }
            if (!(control instanceof Composite) || (result = this.findControlRecursively((Composite)control, predicate)) == null) continue;
            return result;
        }
        return null;
    }

    public Button getWorkingSetsEnabledButton() {
        return this.workingSetsEnabledButton;
    }

    public Combo getWorkingSetsCombo() {
        return this.workingSetsCombo;
    }

    public Button getWorkingSetsSelectButton() {
        return this.workingSetsSelectButton;
    }

    public void addWorkingSetChangeListener(WorkingSetChangedListener workingSetListener) {
        this.listener.add(workingSetListener);
    }

    public void removeWorkingSetChangeListener(WorkingSetChangedListener workingSetListener) {
        this.listener.remove(workingSetListener);
    }

    private void fireWorkingSetChanged() {
        ImmutableList workingSets = ImmutableList.copyOf((Object[])this.getSelectedWorkingSets());
        for (WorkingSetChangedListener workingSetChangedListener : this.listener) {
            workingSetChangedListener.workingSetsChanged((List<IWorkingSet>)workingSets);
        }
    }

    public void modifyCurrentWorkingSetItem(IWorkingSet[] result) {
        try {
            Field selectedWorkingSets = WorkingSetConfigurationBlock.class.getDeclaredField("selectedWorkingSets");
            selectedWorkingSets.setAccessible(true);
            selectedWorkingSets.set((Object)this, result);
            if (result.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addRecentWorkingSet(result[0]);
            }
            Method updateWorkingSetSelection = WorkingSetConfigurationBlock.class.getDeclaredMethod("updateWorkingSetSelection", new Class[0]);
            updateWorkingSetSelection.setAccessible(true);
            updateWorkingSetSelection.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException((Throwable)e);
        }
    }
}

