/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.core.model.JDIPrimitiveValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompareObjectWithClipboard
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Object object = selection.getFirstElement();
        if (object instanceof IJavaVariable) {
            IJavaVariable variable = (IJavaVariable)object;
            try {
                Object clpbrd = this.getClipboard();
                if (clpbrd != null) {
                    IValue iValue;
                    IJavaObject javaObject;
                    String cb = clpbrd.toString();
                    String variableName = variable.getName();
                    IValue iValue2 = variable.getValue();
                    if (iValue2 instanceof IJavaObject && !((javaObject = (IJavaObject)iValue2) instanceof JDINullValue)) {
                        if (javaObject.getJavaType() instanceof IJavaArrayType) {
                            StringBuilder arrBuilder = new StringBuilder("[");
                            IVariable[] iVariableArray = variable.getValue().getVariables();
                            int n = iVariableArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IVariable variableTemp = iVariableArray[n2];
                                arrBuilder.append(String.valueOf(variableTemp.getValue()) + ", ");
                                ++n2;
                            }
                            arrBuilder.delete(arrBuilder.length() - 2, arrBuilder.length());
                            arrBuilder.append("]");
                            this.compareVariable(arrBuilder.toString(), variableName, cb);
                            return;
                        }
                        JDIStackFrame frame = (JDIStackFrame)DebugUITools.getDebugContext();
                        IJavaThread thread = (IJavaThread)frame.getThread();
                        IJavaValue stringVal = javaObject.sendMessage("toString", "()Ljava/lang/String;", null, thread, false);
                        String variableValue = stringVal.getValueString();
                        this.compareVariable(variableValue, variableName, cb);
                    }
                    if ((iValue = variable.getValue()) instanceof JDIPrimitiveValue) {
                        JDIPrimitiveValue javaPrimitive = (JDIPrimitiveValue)iValue;
                        this.compareVariable(javaPrimitive.toString(), variableName, cb);
                    }
                } else {
                    MessageDialog.openWarning((Shell)DebugUIPlugin.getShell(), (String)"Variable Value Comparision", (String)"Invalid clipboard content");
                }
            }
            catch (DebugException e) {
                DebugUIPlugin.log((Throwable)e);
            }
        }
    }

    private void compareVariable(String variableValue, String variableName, String clipboardContent) {
        class StringTypedElement
        implements ITypedElement,
        IStreamContentAccessor {
            private final String name;
            private final String content;

            public StringTypedElement(String name, String content) {
                this.name = name;
                this.content = content;
            }

            public String getName() {
                return this.name;
            }

            public Image getImage() {
                return null;
            }

            public String getType() {
                return "variable";
            }

            public InputStream getContents() {
                return new ByteArrayInputStream(this.content.getBytes(StandardCharsets.UTF_8));
            }
        }
        final StringTypedElement variable = new StringTypedElement(variableName, variableValue);
        final StringTypedElement clipboard = new StringTypedElement("Clipboard", clipboardContent);
        CompareConfiguration config = new CompareConfiguration();
        config.setLeftLabel(variableName);
        config.setRightLabel("Contents in clipboard");
        config.setLeftEditable(false);
        config.setLeftEditable(false);
        CompareEditorInput compareInput = new CompareEditorInput(config){
            {
                super($anonymous0);
            }

            protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                return new DiffNode((ITypedElement)variable, (ITypedElement)clipboard);
            }
        };
        CompareUI.openCompareEditor((CompareEditorInput)compareInput);
    }

    private Object getClipboard() {
        Clipboard clip = new Clipboard(Display.getDefault());
        try {
            Object object = clip.getContents((Transfer)TextTransfer.getInstance());
            return object;
        }
        finally {
            clip.dispose();
        }
    }
}

