/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleAutoReconcileAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public ToggleAutoReconcileAction() {
        super(AntEditorActionMessages.getResourceBundle(), "ToggleAutoReconcileAction.", null, 2);
        this.setImageDescriptor(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.IMG_REFRESH"));
        this.setToolTipText(AntEditorActionMessages.getString("ToggleAutoReconcileAction.tooltip"));
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof AntEditor) {
            AntModel model = ((AntEditor)editor).getAntModel();
            model.setShouldReconcile(this.isChecked());
            this.fStore.setValue("editor_reconcile", this.isChecked());
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = false;
        boolean enabled = false;
        if (editor instanceof AntEditor) {
            AntModel model = ((AntEditor)editor).getAntModel();
            enabled = model != null;
            boolean bl = checked = enabled && this.fStore.getBoolean("editor_reconcile");
            if (model != null) {
                model.setShouldReconcile(checked);
            }
        }
        this.setChecked(checked);
        this.setEnabled(enabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = AntUIPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("editor_reconcile")) {
            this.setChecked(Boolean.parseBoolean(event.getNewValue().toString()));
        }
    }
}

