/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;

@NoExtend
public abstract class Graphics {
    public static final int LINE_CUSTOM = 6;
    public static final int LINE_DASH = 2;
    public static final int LINE_DASHDOT = 4;
    public static final int LINE_DASHDOTDOT = 5;
    public static final int LINE_DOT = 3;
    public static final int LINE_SOLID = 1;

    public abstract void clipRect(Rectangle var1);

    public void clipPath(Path path) {
        this.throwNotImplemented();
    }

    public abstract void dispose();

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public final void drawArc(Rectangle r, int offset, int length) {
        this.drawArc(r.x, r.y, r.width, r.height, offset, length);
    }

    public abstract void drawFocus(int var1, int var2, int var3, int var4);

    public final void drawFocus(Rectangle r) {
        this.drawFocus(r.x, r.y, r.width, r.height);
    }

    public abstract void drawImage(Image var1, int var2, int var3);

    public void drawImage(Image image, int destX, int destY, int destWidth, int destHeight) {
        org.eclipse.swt.graphics.Rectangle bounds = image.getBounds();
        this.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, destX, destY, destWidth, destHeight);
    }

    public abstract void drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public final void drawImage(Image image, Point p) {
        this.drawImage(image, p.x, p.y);
    }

    public final void drawImage(Image image, Rectangle dest) {
        this.drawImage(image, dest.x, dest.y, dest.width, dest.height);
    }

    public final void drawImage(Image srcImage, Rectangle src, Rectangle dest) {
        this.drawImage(srcImage, src.x, src.y, src.width, src.height, dest.x, dest.y, dest.width, dest.height);
    }

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public final void drawLine(Point p1, Point p2) {
        this.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    public abstract void drawOval(int var1, int var2, int var3, int var4);

    public final void drawOval(Rectangle r) {
        this.drawOval(r.x, r.y, r.width, r.height);
    }

    public void drawPath(Path path) {
        this.throwNotImplemented();
    }

    public void drawPoint(int x, int y) {
        this.drawLine(x, y, x, y);
    }

    public void drawPolygon(int[] points) {
        this.drawPolygon(Graphics.getPointList(points));
    }

    public abstract void drawPolygon(PointList var1);

    public void drawPolyline(int[] points) {
        this.drawPolyline(Graphics.getPointList(points));
    }

    public abstract void drawPolyline(PointList var1);

    public abstract void drawRectangle(int var1, int var2, int var3, int var4);

    public final void drawRectangle(Rectangle r) {
        this.drawRectangle(r.x, r.y, r.width, r.height);
    }

    public abstract void drawRoundRectangle(Rectangle var1, int var2, int var3);

    public abstract void drawString(String var1, int var2, int var3);

    public final void drawString(String s, Point p) {
        this.drawString(s, p.x, p.y);
    }

    public abstract void drawText(String var1, int var2, int var3);

    public void drawText(String s, int x, int y, int style) {
        this.throwNotImplemented();
    }

    public final void drawText(String s, Point p) {
        this.drawText(s, p.x, p.y);
    }

    public final void drawText(String s, Point p, int style) {
        this.drawText(s, p.x, p.y, style);
    }

    public final void drawTextLayout(TextLayout layout, int x, int y) {
        this.drawTextLayout(layout, x, y, -1, -1, null, null);
    }

    public void drawTextLayout(TextLayout layout, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.throwNotImplemented();
    }

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public final void fillArc(Rectangle r, int offset, int length) {
        this.fillArc(r.x, r.y, r.width, r.height, offset, length);
    }

    public abstract void fillGradient(int var1, int var2, int var3, int var4, boolean var5);

    public final void fillGradient(Rectangle r, boolean vertical) {
        this.fillGradient(r.x, r.y, r.width, r.height, vertical);
    }

    public abstract void fillOval(int var1, int var2, int var3, int var4);

    public final void fillOval(Rectangle r) {
        this.fillOval(r.x, r.y, r.width, r.height);
    }

    public void fillPath(Path path) {
        this.throwNotImplemented();
    }

    public void fillPolygon(int[] points) {
        this.fillPolygon(Graphics.getPointList(points));
    }

    public abstract void fillPolygon(PointList var1);

    public abstract void fillRectangle(int var1, int var2, int var3, int var4);

    public final void fillRectangle(Rectangle r) {
        this.fillRectangle(r.x, r.y, r.width, r.height);
    }

    public abstract void fillRoundRectangle(Rectangle var1, int var2, int var3);

    public abstract void fillString(String var1, int var2, int var3);

    public final void fillString(String s, Point p) {
        this.fillString(s, p.x, p.y);
    }

    public abstract void fillText(String var1, int var2, int var3);

    public final void fillText(String s, Point p) {
        this.fillText(s, p.x, p.y);
    }

    public double getAbsoluteScale() {
        return 1.0;
    }

    public boolean getAdvanced() {
        this.throwNotImplemented();
        return false;
    }

    public int getAlpha() {
        this.throwNotImplemented();
        return 255;
    }

    public int getAntialias() {
        this.throwNotImplemented();
        return -1;
    }

    public abstract Color getBackgroundColor();

    public abstract Rectangle getClip(Rectangle var1);

    public int getFillRule() {
        this.throwNotImplemented();
        return 0;
    }

    public abstract Font getFont();

    public abstract FontMetrics getFontMetrics();

    public abstract Color getForegroundColor();

    public int getInterpolation() {
        this.throwNotImplemented();
        return 0;
    }

    public LineAttributes getLineAttributes() {
        this.throwNotImplemented();
        return null;
    }

    public int getLineCap() {
        this.throwNotImplemented();
        return 1;
    }

    public int getLineJoin() {
        this.throwNotImplemented();
        return 1;
    }

    public float getLineMiterLimit() {
        this.throwNotImplemented();
        return 0.0f;
    }

    public abstract int getLineStyle();

    public abstract int getLineWidth();

    public abstract float getLineWidthFloat();

    private static PointList getPointList(int[] points) {
        PointList pointList = new PointList(points.length / 2);
        int i = 0;
        while (i + 1 < points.length) {
            pointList.addPoint(points[i], points[i + 1]);
            i += 2;
        }
        return pointList;
    }

    public int getTextAntialias() {
        this.throwNotImplemented();
        return -1;
    }

    public abstract boolean getXORMode();

    public abstract void popState();

    public abstract void pushState();

    public abstract void restoreState();

    public void rotate(float degrees) {
        this.throwNotImplemented();
    }

    public abstract void scale(double var1);

    public void scale(float horizontal, float vertical) {
        this.throwNotImplemented();
    }

    public void setAlpha(int alpha) {
        this.throwNotImplemented();
    }

    public void setAdvanced(boolean advanced) {
        this.throwNotImplemented();
    }

    public void setAntialias(int value) {
        this.throwNotImplemented();
    }

    public abstract void setBackgroundColor(Color var1);

    public void setBackgroundPattern(Pattern pattern) {
        this.throwNotImplemented();
    }

    public void setClip(Path path) {
        this.throwNotImplemented();
    }

    public abstract void setClip(Rectangle var1);

    public void setFillRule(int rule) {
        this.throwNotImplemented();
    }

    public abstract void setFont(Font var1);

    public abstract void setForegroundColor(Color var1);

    public void setForegroundPattern(Pattern pattern) {
        this.throwNotImplemented();
    }

    public void setInterpolation(int interpolation) {
        this.throwNotImplemented();
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.throwNotImplemented();
    }

    public void setLineCap(int cap) {
        this.throwNotImplemented();
    }

    public void setLineDash(int[] dash) {
        this.throwNotImplemented();
    }

    public void setLineDash(float[] value) {
        this.throwNotImplemented();
    }

    public void setLineDashOffset(float value) {
        this.throwNotImplemented();
    }

    public void setLineJoin(int join) {
        this.throwNotImplemented();
    }

    public abstract void setLineStyle(int var1);

    public abstract void setLineWidth(int var1);

    public abstract void setLineWidthFloat(float var1);

    public abstract void setLineMiterLimit(float var1);

    public void setTextAntialias(int value) {
        this.throwNotImplemented();
    }

    public void shear(float horz, float vert) {
        this.throwNotImplemented();
    }

    public abstract void setXORMode(boolean var1);

    private void throwNotImplemented() {
        throw new RuntimeException("The class: " + String.valueOf(this.getClass()) + " has not implemented this new graphics function");
    }

    public abstract void translate(int var1, int var2);

    public void translate(float dx, float dy) {
        this.throwNotImplemented();
    }

    public final void translate(Point pt) {
        this.translate(pt.x, pt.y);
    }
}

