/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexBuilder;
import org.eclipse.jgit.internal.storage.pack.BitmapCommit;
import org.eclipse.jgit.internal.storage.pack.PackWriterBitmapPreparer;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.BitmapWalker;
import org.eclipse.jgit.storage.pack.PackConfig;

public class PackBitmapCalculator {
    private final PackConfig config;

    public PackBitmapCalculator(PackConfig config) {
        this.config = config;
    }

    public void calculate(ObjectReader reader, ProgressMonitor pm, int numCommits, Set<? extends ObjectId> wants, Set<? extends ObjectId> excludeFromBitmapSelection, PackBitmapIndexBuilder writeBitmaps) throws IOException {
        PackWriterBitmapPreparer bitmapPreparer = new PackWriterBitmapPreparer(reader, writeBitmaps, pm, wants, this.config);
        Collection<BitmapCommit> selectedCommits = bitmapPreparer.selectCommits(numCommits, excludeFromBitmapSelection);
        pm.beginTask(JGitText.get().buildingBitmaps, selectedCommits.size());
        BitmapWalker walker = bitmapPreparer.newBitmapWalker();
        BitmapCommit last = null;
        for (BitmapCommit cmit : selectedCommits) {
            if (!cmit.isReuseWalker()) {
                walker = bitmapPreparer.newBitmapWalker();
            }
            BitmapIndex.BitmapBuilder bitmap = walker.findObjects(Collections.singleton(cmit), null, false);
            if (last != null && cmit.isReuseWalker() && !bitmap.contains(last)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().bitmapMissingObject, cmit.name(), last.name()));
            }
            last = BitmapCommit.copyFrom(cmit).build();
            writeBitmaps.processBitmapForWrite(cmit, bitmap.build(), cmit.getFlags());
            walker.setPrevCommit(last);
            walker.setPrevBitmap(bitmap);
            pm.update(1);
        }
        pm.endTask();
    }
}

