/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoading;
import org.eclipse.sirius.common.tools.internal.interpreter.ClassLoadingService;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.ui.tools.api.editor.ITableCellEditorFactory;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class CellEditorFactoryManager {
    private Set<String> viewpointPlugins = new LinkedHashSet<String>();
    private Set<String> viewpointProjects = new LinkedHashSet<String>();
    private ClassLoading classLoading = ClassLoadingService.getClassLoading();

    private CellEditorFactoryManager(DAnalysisSessionImpl session) {
        this.configure(session);
    }

    public static ITableCellEditorFactory getCellEditorFactory(DAnalysisSessionImpl session, String qualifiedClassName) throws IllegalArgumentException {
        CellEditorFactoryManager cellEditorFactoryManager = new CellEditorFactoryManager(session);
        try {
            ITableCellEditorFactory result;
            ITableCellEditorFactory iTableCellEditorFactory = result = cellEditorFactoryManager.instantiateCellEditorFactory(qualifiedClassName);
            return iTableCellEditorFactory;
        }
        finally {
            cellEditorFactoryManager.dispose();
        }
    }

    void configure(DAnalysisSessionImpl dasi) {
        ArrayList<String> filePaths = new ArrayList<String>();
        for (Viewpoint vp : dasi.getSelectedViewpointsSpecificToGeneric()) {
            Resource vpResource = vp.eResource();
            if (vpResource == null) continue;
            filePaths.add(vpResource.getURI().toPlatformString(true));
        }
        this.updateScope(filePaths);
    }

    public void dispose() {
        this.classLoading.dispose();
        this.viewpointPlugins.clear();
        this.viewpointProjects.clear();
    }

    public ITableCellEditorFactory instantiateCellEditorFactory(String qualifiedClassName) throws IllegalArgumentException {
        Class found = this.classLoading.findClass(this.viewpointProjects, this.viewpointPlugins, qualifiedClassName);
        if (found != null) {
            Object instance = null;
            try {
                instance = found.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.CelEditorFactoryManager_impossibleInstantiation, qualifiedClassName), e);
            }
            if (instance instanceof ITableCellEditorFactory) {
                return instance;
            }
            throw new IllegalArgumentException(MessageFormat.format(Messages.CelEditorFactoryManager_wrongImplementation, qualifiedClassName));
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.CelEditorFactoryManager_notFound, qualifiedClassName));
    }

    public void updateScope(Collection<String> value) {
        if (value != null) {
            for (String odesignPath : value) {
                URI workspaceCandidate = URI.createPlatformResourceURI((String)odesignPath, (boolean)true);
                URI pluginCandidate = URI.createPlatformPluginURI((String)odesignPath, (boolean)true);
                if (CellEditorFactoryManager.existsInWorkspace(workspaceCandidate.toPlatformString(true))) {
                    this.viewpointProjects.add(workspaceCandidate.segment(1));
                    continue;
                }
                if (!CellEditorFactoryManager.existsInPlugins(URI.decode((String)pluginCandidate.toString()))) continue;
                this.viewpointPlugins.add(pluginCandidate.segment(1));
            }
        }
    }

    private static boolean existsInPlugins(String path) {
        try {
            URL url = new URL(path);
            return FileLocator.find((URL)url) != null;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private static boolean existsInWorkspace(String path) {
        if (path == null || path.length() == 0 || EcorePlugin.getWorkspaceRoot() == null) {
            return false;
        }
        return ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(path));
    }
}

