/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.testsrunner.internal.model.ITestingSessionsManagerListener;
import org.eclipse.cdt.testsrunner.internal.model.TestingSessionsManager;
import org.eclipse.cdt.testsrunner.internal.ui.view.ProgressCountPanel;
import org.eclipse.cdt.testsrunner.internal.ui.view.ResultsView;
import org.eclipse.cdt.testsrunner.internal.ui.view.TestPathUtils;
import org.eclipse.cdt.testsrunner.internal.ui.view.TestsHierarchyViewer;
import org.eclipse.cdt.testsrunner.internal.ui.view.UIViewMessages;
import org.eclipse.cdt.testsrunner.model.ITestCase;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestSuite;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.cdt.testsrunner.model.ITestingSessionListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class UIUpdater {
    private ResultsView resultsView;
    private TestsHierarchyViewer testsHierarchyViewer;
    private ProgressCountPanel progressCountPanel;
    private ITestingSessionListener sessionListener;
    private boolean autoScroll = true;
    private TestingSessionsManager sessionsManager;
    private TestingSessionsManagerListener sessionsManagerListener;
    ITestingSession testingSession;
    UIChangesCache uiChangesCache = new UIChangesCache();
    UpdateUIJob updateUIJob = null;
    private static final int REFRESH_INTERVAL = 200;

    public UIUpdater(ResultsView resultsView, TestsHierarchyViewer testsHierarchyViewer, ProgressCountPanel progressCountPanel, TestingSessionsManager sessionsManager) {
        this.resultsView = resultsView;
        this.testsHierarchyViewer = testsHierarchyViewer;
        this.progressCountPanel = progressCountPanel;
        this.sessionsManager = sessionsManager;
        this.sessionListener = new SessionListener();
        this.sessionsManagerListener = new TestingSessionsManagerListener();
        sessionsManager.addListener(this.sessionsManagerListener);
    }

    public boolean getAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public void dispose() {
        this.unsubscribeFromSessionEvent();
        this.sessionsManager.removeListener(this.sessionsManagerListener);
    }

    private void subscribeToSessionEvent() {
        if (this.testingSession != null) {
            this.testingSession.getModelAccessor().addChangesListener(this.sessionListener);
        }
    }

    private void unsubscribeFromSessionEvent() {
        if (this.testingSession != null) {
            this.testingSession.getModelAccessor().removeChangesListener(this.sessionListener);
        }
    }

    private void startUpdateUIJob() {
        this.stopUpdateUIJob();
        this.uiChangesCache.resetChanges();
        this.updateUIJob = new UpdateUIJob();
        this.updateUIJob.scheduleSelf();
    }

    private void stopUpdateUIJob() {
        if (this.updateUIJob != null) {
            this.updateUIJob.stop();
            this.updateUIJob = null;
        }
    }

    public void reapplyActiveSession() {
        this.sessionsManagerListener.sessionActivated(this.sessionsManager.getActiveSession());
    }

    private class SessionListener
    implements ITestingSessionListener {
        private SessionListener() {
        }

        private void enterTestItem(ITestItem testItem) {
            UIUpdater.this.uiChangesCache.scheduleViewCaptionChange(testItem);
            UIUpdater.this.uiChangesCache.scheduleTreeItemUpdate(testItem);
            if (UIUpdater.this.autoScroll) {
                UIUpdater.this.uiChangesCache.scheduleTreeItemReveal(testItem);
            }
        }

        @Override
        public void enterTestSuite(ITestSuite testSuite) {
            this.enterTestItem(testSuite);
        }

        @Override
        public void exitTestSuite(ITestSuite testSuite) {
            UIUpdater.this.uiChangesCache.scheduleTreeItemUpdate(testSuite);
            if (UIUpdater.this.autoScroll) {
                UIUpdater.this.uiChangesCache.scheduleTreeItemExpand(testSuite, false);
            }
        }

        @Override
        public void enterTestCase(ITestCase testCase) {
            this.enterTestItem(testCase);
        }

        @Override
        public void exitTestCase(ITestCase testCase) {
            UIUpdater.this.uiChangesCache.scheduleActionsUpdate();
            UIUpdater.this.uiChangesCache.scheduleProgressCountPanelUpdate();
            UIUpdater.this.uiChangesCache.scheduleTreeItemUpdate(testCase);
        }

        @Override
        public void childrenUpdate(ITestSuite parent) {
            UIUpdater.this.uiChangesCache.scheduleTreeItemRefresh(parent);
        }

        @Override
        public void testingStarted() {
            UIUpdater.this.resultsView.updateActionsFromSession();
            Display.getDefault().syncExec(() -> {
                UIUpdater.this.resultsView.setCaption(UIUpdater.this.testingSession.getStatusMessage());
                UIUpdater.this.progressCountPanel.updateInfoFromSession();
                UIUpdater.this.testsHierarchyViewer.getTreeViewer().refresh();
            });
            UIUpdater.this.startUpdateUIJob();
        }

        @Override
        public void testingFinished() {
            UIUpdater.this.stopUpdateUIJob();
            UIUpdater.this.resultsView.updateActionsFromSession();
            Display.getDefault().syncExec(() -> {
                UIUpdater.this.uiChangesCache.applyChanges();
                UIUpdater.this.resultsView.setCaption(UIUpdater.this.testingSession.getStatusMessage());
                UIUpdater.this.progressCountPanel.updateInfoFromSession();
                UIUpdater.this.testsHierarchyViewer.getTreeViewer().refresh();
                UIUpdater.this.testsHierarchyViewer.getTreeViewer().collapseAll();
                UIUpdater.this.testsHierarchyViewer.getTreeViewer().expandToLevel(2);
            });
        }
    }

    private class TestingSessionsManagerListener
    implements ITestingSessionsManagerListener {
        private TestingSessionsManagerListener() {
        }

        @Override
        public void sessionActivated(ITestingSession newTestingSession) {
            if (UIUpdater.this.testingSession != newTestingSession) {
                UIUpdater.this.stopUpdateUIJob();
                UIUpdater.this.uiChangesCache.resetChanges();
                UIUpdater.this.unsubscribeFromSessionEvent();
                UIUpdater.this.testingSession = newTestingSession;
                UIUpdater.this.subscribeToSessionEvent();
                UIUpdater.this.resultsView.updateActionsFromSession();
                Display.getDefault().syncExec(() -> {
                    UIUpdater.this.progressCountPanel.setTestingSession(UIUpdater.this.testingSession);
                    UIUpdater.this.testsHierarchyViewer.setTestingSession(UIUpdater.this.testingSession);
                    UIUpdater.this.resultsView.setCaption(UIUpdater.this.testingSession != null ? UIUpdater.this.testingSession.getStatusMessage() : "");
                });
                if (newTestingSession != null && !newTestingSession.isFinished()) {
                    UIUpdater.this.startUpdateUIJob();
                }
            }
        }
    }

    private class UIChangesCache {
        private boolean needProgressCountPanelUpdate;
        private boolean needActionsUpdate;
        private ITestItem testItemForNewViewCaption;
        private Set<Object> treeItemsToRefresh = new HashSet<Object>();
        private Set<Object> treeItemsToUpdate = new HashSet<Object>();
        private Object treeItemToReveal;
        private Map<Object, Boolean> treeItemsToExpand = new LinkedHashMap<Object, Boolean>();

        UIChangesCache() {
            this.resetChanges();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleProgressCountPanelUpdate() {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.needProgressCountPanelUpdate = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleActionsUpdate() {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.needActionsUpdate = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleViewCaptionChange(ITestItem testItem) {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.testItemForNewViewCaption = testItem;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTreeItemUpdate(Object item) {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.treeItemsToUpdate.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTreeItemReveal(Object item) {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.treeItemToReveal = item;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTreeItemExpand(Object item, boolean expandedState) {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.treeItemsToExpand.put(item, expandedState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTreeItemRefresh(Object item) {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.treeItemsToRefresh.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyChanges() {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                TreeViewer treeViewer = UIUpdater.this.testsHierarchyViewer.getTreeViewer();
                if (this.needProgressCountPanelUpdate) {
                    UIUpdater.this.progressCountPanel.updateInfoFromSession();
                }
                if (this.needActionsUpdate) {
                    UIUpdater.this.resultsView.updateActionsFromSession();
                }
                if (this.testItemForNewViewCaption != null) {
                    UIUpdater.this.resultsView.setCaption(MessageFormat.format(UIViewMessages.UIUpdater_view_caption_format, this.testItemForNewViewCaption.getName(), TestPathUtils.getTestItemPath(this.testItemForNewViewCaption.getParent())));
                }
                if (!this.treeItemsToRefresh.isEmpty()) {
                    for (Object object : this.treeItemsToRefresh) {
                        treeViewer.refresh(object, false);
                    }
                }
                if (!this.treeItemsToUpdate.isEmpty()) {
                    treeViewer.update(this.treeItemsToUpdate.toArray(), null);
                }
                if (this.treeItemToReveal != null) {
                    treeViewer.reveal(this.treeItemToReveal);
                }
                if (!this.treeItemsToExpand.isEmpty()) {
                    for (Map.Entry entry : this.treeItemsToExpand.entrySet()) {
                        treeViewer.setExpandedState(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                    }
                }
                this.resetChangesImpl();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetChanges() {
            UIChangesCache uIChangesCache = this;
            synchronized (uIChangesCache) {
                this.resetChangesImpl();
            }
        }

        private void resetChangesImpl() {
            this.needProgressCountPanelUpdate = false;
            this.needActionsUpdate = false;
            this.testItemForNewViewCaption = null;
            this.treeItemsToUpdate.clear();
            this.treeItemToReveal = null;
            this.treeItemsToExpand.clear();
        }
    }

    private class UpdateUIJob
    extends UIJob {
        private boolean isRunning;

        public UpdateUIJob() {
            super(UIViewMessages.UIUpdater_update_ui_job);
            this.isRunning = true;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!UIUpdater.this.resultsView.isDisposed()) {
                UIUpdater.this.uiChangesCache.applyChanges();
                this.scheduleSelf();
            }
            return Status.OK_STATUS;
        }

        public void scheduleSelf() {
            this.schedule(200L);
        }

        public void stop() {
            this.isRunning = false;
        }

        public boolean shouldSchedule() {
            return this.isRunning;
        }
    }
}

