/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.util;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInheritance;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

@Deprecated
public class CElementBaseLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_SIMPLE_NAME = 2;
    public static final int M_EXCEPTIONS = 4;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int TEMPLATE_PARAMETERS = 128;
    public static final int F_SIMPLE_NAME = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int TEMPLATE_ARGUMENTS = 16384;
    public static final int T_INHERITANCE = 65536;
    public static final int TU_QUALIFIED = 0x100000;
    public static final int TU_POST_QUALIFIED = 0x200000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int PROJECT_POST_QUALIFIED = 0x40000000;
    public static final int MF_POST_FILE_QUALIFIED = Integer.MIN_VALUE;
    public static final int ALL_FULLY_QUALIFIED = 34613280;
    public static final int ALL_POST_QUALIFIED = 69210176;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 1058848;
    public static final int DEFAULT_POST_QUALIFIED = 2101312;
    public static final String CONCAT_STRING = CoreModelMessages.getString("CElementLabels.concat_string");
    public static final String COMMA_STRING = CoreModelMessages.getString("CElementLabels.comma_string");
    public static final String DECL_STRING = CoreModelMessages.getString("CElementLabels.declseparator_string");

    public static String getElementLabel(ICElement element, int flags) {
        StringBuffer buf = new StringBuffer(60);
        CElementBaseLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(ICElement element, int flags, StringBuffer buf) {
        int type = element.getElementType();
        ISourceRoot root = null;
        if (!(type == 10 || type == 11 || type == 12 && element instanceof ISourceRoot)) {
            root = CElementBaseLabels.getSourceRoot(element);
        }
        if (root != null && CElementBaseLabels.getFlag(flags, 0x10000000)) {
            CElementBaseLabels.getSourceRootLabel(root, 0x2000000, buf);
            buf.append(CONCAT_STRING);
        }
        switch (type) {
            case 79: {
                CElementBaseLabels.getMacroLabel((IMacro)element, flags, buf);
                break;
            }
            case 70: 
            case 71: 
            case 90: 
            case 91: {
                CElementBaseLabels.getMethodLabel((IMethodDeclaration)element, flags, buf);
                break;
            }
            case 73: 
            case 74: 
            case 88: 
            case 89: 
            case 96: 
            case 97: {
                CElementBaseLabels.getFunctionLabel((IFunctionDeclaration)element, flags, buf);
                break;
            }
            case 72: {
                CElementBaseLabels.getFieldLabel((IField)element, flags, buf);
                break;
            }
            case 76: 
            case 77: {
                CElementBaseLabels.getVariableLabel((IVariableDeclaration)element, flags, buf);
                break;
            }
            case 81: {
                CElementBaseLabels.getEnumeratorLabel((IEnumerator)element, flags, buf);
                break;
            }
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                CElementBaseLabels.getTypeLabel(element, flags, buf);
                break;
            }
            case 80: {
                CElementBaseLabels.getTypeDefLabel((ITypeDef)element, flags, buf);
                break;
            }
            case 60: {
                CElementBaseLabels.getTranslationUnitLabel((ITranslationUnit)element, flags, buf);
                break;
            }
            case 12: {
                ICContainer container = (ICContainer)element;
                if (container instanceof ISourceRoot) {
                    CElementBaseLabels.getSourceRootLabel((ISourceRoot)container, flags, buf);
                    break;
                }
                CElementBaseLabels.getContainerLabel(container, flags, buf);
                break;
            }
            case 10: 
            case 11: {
                buf.append(element.getElementName());
                break;
            }
            default: {
                buf.append(element.getElementName());
            }
        }
        if (root != null && CElementBaseLabels.getFlag(flags, 0x8000000)) {
            buf.append(CONCAT_STRING);
            CElementBaseLabels.getSourceRootLabel(root, 0x2000000, buf);
        }
        if (element instanceof IBinary) {
            IBinary bin = (IBinary)element;
            buf.append(" - [").append(bin.getCPU()).append('/').append(bin.isLittleEndian() ? "le" : "be").append(']');
        }
    }

    public static void getMacroLabel(IMacro macro, int flags, StringBuffer buf) {
        IPath path;
        buf.append(macro.getElementName());
        if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = macro.getPath()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(path.toString());
        }
    }

    public static void getMethodLabel(IMethodDeclaration method, int flags, StringBuffer buf) {
        try {
            IPath path;
            String typeName;
            int i;
            String[] types;
            ICElement parent;
            if (CElementBaseLabels.getFlag(flags, 16) && method.exists() && !method.isConstructor()) {
                buf.append(method.getReturnType());
                buf.append(' ');
            }
            if (CElementBaseLabels.getFlag(flags, 32) && (parent = method.getParent()) != null && parent.exists() && !(parent instanceof ITranslationUnit)) {
                CElementBaseLabels.getTypeLabel(parent, 0x2000 | flags & 0x4000, buf);
                buf.append("::");
            }
            if (CElementBaseLabels.getFlag(flags, 2)) {
                buf.append(CElementBaseLabels.getSimpleName(method.getElementName()));
            } else {
                buf.append(method.getElementName());
            }
            if (method instanceof ITemplate) {
                CElementBaseLabels.getTemplateParameters((ITemplate)((Object)method), flags, buf);
            }
            if (CElementBaseLabels.getFlag(flags, 1)) {
                buf.append('(');
                types = method.getParameterTypes();
                if (types != null) {
                    i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            buf.append(COMMA_STRING);
                        }
                        buf.append(types[i]);
                        ++i;
                    }
                }
                buf.append(')');
            }
            if (CElementBaseLabels.getFlag(flags, 4) && method.exists() && (types = method.getExceptions()).length > 0) {
                buf.append(" throw( ");
                i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    buf.append(types[i]);
                    ++i;
                }
                buf.append(" )");
            }
            if (CElementBaseLabels.getFlag(flags, 8) && method.exists() && !method.isConstructor() && !method.isDestructor() && (typeName = method.getReturnType()) != null && typeName.length() > 0) {
                buf.append(DECL_STRING);
                buf.append(typeName);
            }
            if (CElementBaseLabels.getFlag(flags, 64)) {
                buf.append(CONCAT_STRING);
                CElementBaseLabels.getTypeLabel(method.getParent(), 0x2000 | flags & 0x4000, buf);
            }
            if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = method.getPath()) != null) {
                buf.append(CONCAT_STRING);
                buf.append(path.toString());
            }
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
        }
    }

    private static String getSimpleName(String elementName) {
        int idx = elementName.lastIndexOf("::");
        if (idx >= 0) {
            return elementName.substring(idx + 2);
        }
        return elementName;
    }

    private static void getTemplateParameters(ITemplate template, int flags, StringBuffer buf) {
        String[] args = null;
        if (CElementBaseLabels.getFlag(flags, 16384)) {
            args = template.getTemplateArguments();
        } else if (CElementBaseLabels.getFlag(flags, 128)) {
            args = template.getTemplateParameterTypes();
        } else {
            return;
        }
        buf.append('<');
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(args[i]);
                ++i;
            }
        }
        buf.append('>');
    }

    public static void getFieldLabel(IField field, int flags, StringBuffer buf) {
        try {
            IPath path;
            ICElement parent;
            if (CElementBaseLabels.getFlag(flags, 1024) && field.exists()) {
                buf.append(field.getTypeName());
                buf.append(' ');
            }
            if (CElementBaseLabels.getFlag(flags, 2048) && (parent = field.getParent()) != null && parent.exists()) {
                CElementBaseLabels.getTypeLabel(parent, 0x2000 | flags & 0x80, buf);
                buf.append("::");
            }
            if (CElementBaseLabels.getFlag(flags, 256)) {
                buf.append(CElementBaseLabels.getSimpleName(field.getElementName()));
            } else {
                buf.append(field.getElementName());
            }
            if (CElementBaseLabels.getFlag(flags, 512) && field.exists()) {
                buf.append(DECL_STRING);
                buf.append(field.getTypeName());
            }
            if (CElementBaseLabels.getFlag(flags, 4096)) {
                buf.append(CONCAT_STRING);
                CElementBaseLabels.getTypeLabel(field.getParent(), 0x2000 | flags & 0x80, buf);
            }
            if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = field.getPath()) != null) {
                buf.append(CONCAT_STRING);
                buf.append(path.toString());
            }
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
        }
    }

    public static void getVariableLabel(IVariableDeclaration var, int flags, StringBuffer buf) {
        try {
            IPath path;
            ICElement parent;
            if (CElementBaseLabels.getFlag(flags, 1024) && var.exists()) {
                buf.append(var.getTypeName());
                buf.append(' ');
            }
            if (CElementBaseLabels.getFlag(flags, 2048) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
                CElementBaseLabels.getTypeLabel(parent, 8192, buf);
                buf.append("::");
            }
            buf.append(var.getElementName());
            if (CElementBaseLabels.getFlag(flags, 512) && var.exists()) {
                buf.append(DECL_STRING);
                buf.append(var.getTypeName());
            }
            if (CElementBaseLabels.getFlag(flags, 4096) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
                buf.append(CONCAT_STRING);
                CElementBaseLabels.getTypeLabel(var.getParent(), 8192, buf);
            }
            if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = var.getPath()) != null) {
                buf.append(CONCAT_STRING);
                buf.append(path.toString());
            }
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)((Object)e));
        }
    }

    public static void getEnumeratorLabel(IEnumerator var, int flags, StringBuffer buf) {
        IPath path;
        ICElement parent;
        if (CElementBaseLabels.getFlag(flags, 2048) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            CElementBaseLabels.getTypeLabel(parent, 8192, buf);
            buf.append("::");
        }
        buf.append(var.getElementName());
        if (CElementBaseLabels.getFlag(flags, 4096) && (parent = var.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            buf.append(CONCAT_STRING);
            CElementBaseLabels.getTypeLabel(var.getParent(), 8192, buf);
        }
        if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = var.getPath()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(path.toString());
        }
    }

    public static void getFunctionLabel(IFunctionDeclaration func, int flags, StringBuffer buf) {
        IPath path;
        String typeName;
        int i;
        String[] types;
        ICElement parent;
        if (CElementBaseLabels.getFlag(flags, 16) && func.exists()) {
            buf.append(func.getReturnType());
            buf.append(' ');
        }
        if (CElementBaseLabels.getFlag(flags, 32) && (parent = func.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            CElementBaseLabels.getTypeLabel(parent, 8192, buf);
            buf.append("::");
        }
        buf.append(func.getElementName());
        if (func instanceof ITemplate) {
            CElementBaseLabels.getTemplateParameters((ITemplate)((Object)func), flags, buf);
        }
        if (CElementBaseLabels.getFlag(flags, 1)) {
            buf.append('(');
            types = func.getParameterTypes();
            if (types != null) {
                i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    buf.append(types[i]);
                    ++i;
                }
            }
            buf.append(')');
        }
        if (CElementBaseLabels.getFlag(flags, 4) && func.exists() && (types = func.getExceptions()).length > 0) {
            buf.append(" throw( ");
            i = 0;
            while (i < types.length) {
                if (i > 0) {
                    buf.append(COMMA_STRING);
                }
                buf.append(types[i]);
                ++i;
            }
            buf.append(" )");
        }
        if (CElementBaseLabels.getFlag(flags, 8) && func.exists() && (typeName = func.getReturnType()) != null && typeName.length() > 0) {
            buf.append(DECL_STRING);
            buf.append(typeName);
        }
        if (CElementBaseLabels.getFlag(flags, 64) && (parent = func.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            buf.append(CONCAT_STRING);
            CElementBaseLabels.getTypeLabel(func.getParent(), 8192, buf);
        }
        if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = func.getPath()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(path.toString());
        }
    }

    public static void getTypeDefLabel(ITypeDef typedef, int flags, StringBuffer buf) {
        IPath path;
        String typeName;
        ICElement parent;
        if (CElementBaseLabels.getFlag(flags, 1024) && typedef.exists()) {
            buf.append(typedef.getTypeName());
            buf.append(' ');
        }
        if (CElementBaseLabels.getFlag(flags, 2048) && (parent = typedef.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            CElementBaseLabels.getTypeLabel(parent, 8192, buf);
            buf.append("::");
        }
        buf.append(typedef.getElementName());
        if (CElementBaseLabels.getFlag(flags, 512) && typedef.exists() && (typeName = typedef.getTypeName()) != null && typeName.length() > 0) {
            buf.append(DECL_STRING);
            buf.append(typeName);
        }
        if (CElementBaseLabels.getFlag(flags, 4096) && (parent = typedef.getParent()) != null && parent.exists() && parent.getElementType() == 61) {
            buf.append(CONCAT_STRING);
            CElementBaseLabels.getTypeLabel(typedef.getParent(), 8192, buf);
        }
        if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = typedef.getPath()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(path.toString());
        }
    }

    public static void getSourceRootLabel(ISourceRoot root, int flags, StringBuffer buf) {
        CElementBaseLabels.getFolderLabel(root, flags, buf);
    }

    public static void getContainerLabel(ICContainer container, int flags, StringBuffer buf) {
        CElementBaseLabels.getFolderLabel(container, flags, buf);
    }

    private static void getFolderLabel(ICContainer container, int flags, StringBuffer buf) {
        IContainer resource = container.getResource();
        boolean rootQualified = CElementBaseLabels.getFlag(flags, 0x2000000);
        if (rootQualified) {
            buf.append(container.getPath().makeRelative().toString());
        } else {
            if (CCorePlugin.showSourceRootsAtTopOfProject()) {
                buf.append(container.getElementName());
            } else {
                String elementName = container.getElementName();
                Path path = new Path(elementName);
                buf.append(path.lastSegment());
            }
            if (CElementBaseLabels.getFlag(flags, 0x2000000)) {
                if (resource != null && container instanceof ISourceRoot && CElementBaseLabels.isReferenced((ISourceRoot)container)) {
                    buf.append(CONCAT_STRING);
                    buf.append(resource.getProject().getName());
                } else {
                    buf.append(CONCAT_STRING);
                    buf.append(container.getParent().getElementName());
                }
            }
        }
    }

    public static void getTranslationUnitLabel(ITranslationUnit tu, int flags, StringBuffer buf) {
        IResource r = tu.getResource();
        IPath path = r != null ? r.getFullPath().makeRelative() : tu.getPath();
        if (path == null) {
            buf.append(tu.getElementName());
        } else if (CElementBaseLabels.getFlag(flags, 0x100000)) {
            buf.append(path.toString());
        } else if (CElementBaseLabels.getFlag(flags, 0x200000)) {
            buf.append(path.lastSegment());
            buf.append(CONCAT_STRING);
            buf.append(path.removeLastSegments(1));
        } else {
            buf.append(path.lastSegment());
        }
    }

    public static void getTypeLabel(ICElement elem, int flags, StringBuffer buf) {
        IPath path;
        IInheritance inheritance;
        String[] superclassNames;
        String typeName;
        if (CElementBaseLabels.getFlag(flags, 8192)) {
            ICElement parent = elem.getParent();
            boolean isQualifier = true;
            if (parent != null) {
                switch (parent.getElementType()) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 18: 
                    case 30: 
                    case 60: {
                        isQualifier = false;
                    }
                }
            }
            if (isQualifier && !CElementBaseLabels.isCLanguage(parent)) {
                int qflags = flags & Integer.MAX_VALUE;
                CElementBaseLabels.getTypeLabel(parent, qflags, buf);
                buf.append("::");
            }
        }
        if ((typeName = elem.getElementName()).length() == 0) {
            typeName = CoreModelMessages.getString("CElementLabels.anonymous");
        }
        buf.append(typeName);
        if (CElementBaseLabels.getFlag(flags, 65536) && elem instanceof IInheritance && (superclassNames = (inheritance = (IInheritance)((Object)elem)).getSuperClassesNames()) != null && superclassNames.length > 0) {
            buf.append(DECL_STRING);
            int i = 0;
            while (i < superclassNames.length) {
                if (i > 0) {
                    buf.append(COMMA_STRING);
                }
                String superclass = superclassNames[i];
                String visibility = CElementBaseLabels.getVisibility(inheritance.getSuperClassAccess(superclass));
                buf.append(visibility).append(' ').append(superclass);
                ++i;
            }
        }
        if (elem instanceof ITemplate) {
            CElementBaseLabels.getTemplateParameters((ITemplate)((Object)elem), flags, buf);
        }
        if (CElementBaseLabels.getFlag(flags, Integer.MIN_VALUE) && (path = elem.getPath()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(path.toString());
        }
    }

    private static boolean isCLanguage(ICElement elem) {
        while (elem != null) {
            if (!((elem = elem.getParent()) instanceof ITranslationUnit)) continue;
            return ((ITranslationUnit)elem).isCLanguage();
        }
        return false;
    }

    private static String getVisibility(ASTAccessVisibility access) {
        if (access == ASTAccessVisibility.PUBLIC) {
            return "public";
        }
        if (access == ASTAccessVisibility.PROTECTED) {
            return "protected";
        }
        return "private";
    }

    private static boolean getFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static ISourceRoot getSourceRoot(ICElement element) {
        ICElement root = element;
        while (root != null) {
            if (root instanceof ISourceRoot) {
                return (ISourceRoot)root;
            }
            ICElement parent = root.getAncestor(12);
            if (parent == root) {
                return null;
            }
            root = parent;
        }
        return null;
    }

    public static boolean isReferenced(ISourceRoot root) {
        IContainer resource = root.getResource();
        if (resource != null) {
            IProject project = resource.getProject();
            IProject container = root.getCProject().getProject();
            return !container.equals((Object)project);
        }
        return false;
    }
}

