/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.commands;

import org.eclipse.cdt.debug.core.model.ISteppingModeTarget;
import org.eclipse.cdt.debug.core.model.ITargetProperties;
import org.eclipse.cdt.debug.internal.ui.actions.CDTDebugPropertyTester;
import org.eclipse.cdt.debug.internal.ui.commands.Messages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleInstructionStepModeHandler
extends AbstractHandler
implements Preferences.IPropertyChangeListener,
IDebugContextListener {
    private static final String TISM_COMMAND_ID = "org.eclipse.cdt.debug.internal.ui.actions.ToggleInstructionStepModeCommand";
    private Command fCommand = null;
    private ISteppingModeTarget fTarget = null;
    private IWorkbenchWindow fWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    public ToggleInstructionStepModeHandler() {
        DebugUITools.getDebugContextManager().getContextService(this.fWorkbenchWindow).addDebugContextListener((IDebugContextListener)this);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (this.fCommand != null && event.getNewValue() instanceof Boolean) {
            boolean prefState = (Boolean)event.getNewValue();
            try {
                State state = this.fCommand.getState("org.eclipse.ui.commands.toggleState");
                boolean currentState = (Boolean)state.getValue();
                if (currentState != prefState) {
                    HandlerUtil.toggleCommandState((Command)this.fCommand);
                }
            }
            catch (ExecutionException e) {
                CDebugUIPlugin.log(e);
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            this.fCommand = commandService.getCommand(TISM_COMMAND_ID);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        State state = this.fCommand.getState("org.eclipse.ui.commands.toggleState");
        if (state == null) {
            throw new ExecutionException(NLS.bind((String)Messages.ToogleCommand_State_Not_found, (Object)this.fCommand.getId()));
        }
        boolean currentState = (Boolean)state.getValue();
        HandlerUtil.toggleCommandState((Command)this.fCommand);
        ISteppingModeTarget target = this.getTarget();
        if (target != null) {
            target.enableInstructionStepping(!currentState);
        }
        return 0;
    }

    private boolean isTerminated(ISteppingModeTarget target) {
        return target instanceof ITerminate && ((ITerminate)target).isTerminated() || target instanceof IDisconnect && ((IDisconnect)target).isDisconnected();
    }

    public void dispose() {
        ISteppingModeTarget target;
        if (this.fWorkbenchWindow != null) {
            DebugUITools.getDebugContextManager().getContextService(this.fWorkbenchWindow).removeDebugContextListener((IDebugContextListener)this);
        }
        if ((target = this.getTarget()) != null && target instanceof ITargetProperties) {
            ((ITargetProperties)target).removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
        this.setTarget(null);
        super.dispose();
    }

    public void debugContextChanged(DebugContextEvent event) {
        ISelection selection = event.getContext();
        ISteppingModeTarget newTarget = null;
        if (selection instanceof IStructuredSelection) {
            newTarget = CDTDebugPropertyTester.getTargetFromSelection(((IStructuredSelection)selection).getFirstElement());
        }
        if (newTarget == null) {
            return;
        }
        ISteppingModeTarget oldTarget = this.getTarget();
        if (newTarget.equals(oldTarget)) {
            return;
        }
        if (oldTarget != null && oldTarget instanceof ITargetProperties) {
            ((ITargetProperties)oldTarget).removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
        this.setTarget(newTarget);
        if (newTarget instanceof ITargetProperties) {
            ((ITargetProperties)newTarget).addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        }
        try {
            State state;
            boolean currentState;
            boolean prefState;
            boolean bl = prefState = !this.isTerminated(newTarget) && newTarget.isInstructionSteppingEnabled();
            if (this.fCommand != null && (currentState = ((Boolean)(state = this.fCommand.getState("org.eclipse.ui.commands.toggleState")).getValue()).booleanValue()) != prefState) {
                HandlerUtil.toggleCommandState((Command)this.fCommand);
            }
        }
        catch (ExecutionException e) {
            CDebugUIPlugin.log(e);
        }
    }

    private ISteppingModeTarget getTarget() {
        return this.fTarget;
    }

    private void setTarget(ISteppingModeTarget target) {
        this.fTarget = target;
    }
}

