/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.structured;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IField;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.structured.IStructuredType;
import org.eclipse.scout.sdk.core.s.util.ScoutTypeComparators;
import org.eclipse.scout.sdk.core.util.CompositeObject;
import org.eclipse.scout.sdk.core.util.Strings;

public class StructuredType
implements IStructuredType {
    private static final Pattern PROPERTY_BEAN_REGEX = Pattern.compile("^(get|set|is|add|remove|clear|delete)(.*)$");
    private static final Pattern START_HANDLER_REGEX = Pattern.compile("^start(.*)$");
    private static final Pattern METHOD_INNER_TYPE_GETTER_REGEX = Pattern.compile("^get(.*)$");
    private static final Predicate<IType> CLASS_FILTER = type -> {
        if (Strings.isBlank((CharSequence)type.elementName())) {
            return false;
        }
        int flags = type.flags();
        return !Flags.isAbstract((int)flags) && !Flags.isInterface((int)flags) && !Flags.isDeprecated((int)flags);
    };
    private final IType m_type;
    private final IScoutApi m_scoutApi;
    private final EnumSet<IStructuredType.Categories> m_enabledCategories;
    private final EnumSet<IStructuredType.Categories> m_visitedCategories;
    private final Map<IStructuredType.Categories, List<? extends IJavaElement>> m_elements;

    protected StructuredType(IType type, EnumSet<IStructuredType.Categories> enabledCategories) {
        this.m_type = type;
        this.m_scoutApi = type.javaEnvironment().api(IScoutApi.class).orElse(null);
        this.m_enabledCategories = EnumSet.copyOf(enabledCategories);
        this.m_visitedCategories = EnumSet.noneOf(IStructuredType.Categories.class);
        this.m_elements = new EnumMap<IStructuredType.Categories, List<? extends IJavaElement>>(IStructuredType.Categories.class);
        List fields = type.fields().stream().collect(Collectors.toList());
        List enums = ((HierarchyInnerTypeQuery)type.innerTypes().withFlags(16384)).stream().collect(Collectors.toList());
        List methods = type.methods().stream().collect(Collectors.toList());
        List types = type.innerTypes().stream().filter(element -> !Flags.isEnum((int)element.flags())).collect(Collectors.toList());
        this.m_elements.put(IStructuredType.Categories.FIELD_UNKNOWN, fields);
        this.m_elements.put(IStructuredType.Categories.ENUM, enums);
        this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, methods);
        this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, types);
    }

    public Optional<IScoutApi> scoutApi() {
        return Optional.ofNullable(this.m_scoutApi);
    }

    public static IStructuredType of(IType type) {
        EnumSet<IStructuredType.Categories[]> enabled = EnumSet.of(IStructuredType.Categories.FIELD_LOGGER, new IStructuredType.Categories[]{IStructuredType.Categories.FIELD_STATIC, IStructuredType.Categories.FIELD_MEMBER, IStructuredType.Categories.FIELD_UNKNOWN, IStructuredType.Categories.METHOD_CONSTRUCTOR, IStructuredType.Categories.METHOD_CONFIG_PROPERTY, IStructuredType.Categories.METHOD_CONFIG_EXEC, IStructuredType.Categories.METHOD_FORM_DATA_BEAN, IStructuredType.Categories.METHOD_OVERRIDDEN, IStructuredType.Categories.METHOD_START_HANDLER, IStructuredType.Categories.METHOD_INNER_TYPE_GETTER, IStructuredType.Categories.METHOD_LOCAL_BEAN, IStructuredType.Categories.METHOD_UNCATEGORIZED, IStructuredType.Categories.TYPE_FORM_FIELD, IStructuredType.Categories.TYPE_COLUMN, IStructuredType.Categories.TYPE_CODE, IStructuredType.Categories.TYPE_FORM, IStructuredType.Categories.TYPE_TABLE, IStructuredType.Categories.TYPE_TREE, IStructuredType.Categories.TYPE_CALENDAR, IStructuredType.Categories.TYPE_CALENDAR_ITEM_PROVIDER, IStructuredType.Categories.TYPE_WIZARD, IStructuredType.Categories.TYPE_WIZARD_STEP, IStructuredType.Categories.TYPE_MENU, IStructuredType.Categories.TYPE_VIEW_BUTTON, IStructuredType.Categories.TYPE_KEYSTROKE, IStructuredType.Categories.TYPE_COMPOSER_ATTRIBUTE, IStructuredType.Categories.TYPE_COMPOSER_ENTRY, IStructuredType.Categories.TYPE_FORM_HANDLER, IStructuredType.Categories.TYPE_UNCATEGORIZED});
        return new StructuredType(type, enabled);
    }

    private static CompositeObject createPropertyMethodKey(IMethod method) {
        Matcher matcher;
        if (method != null && (matcher = PROPERTY_BEAN_REGEX.matcher(method.elementName())).find()) {
            int getSetOrder = 20;
            if ("get".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 1;
            } else if ("is".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 2;
            } else if ("set".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 3;
            } else if ("add".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 4;
            } else if ("remove".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 5;
            } else if ("clear".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 6;
            } else if ("delete".equalsIgnoreCase(matcher.group(1))) {
                getSetOrder = 7;
            }
            String propName = matcher.group(2);
            return new CompositeObject(new Object[]{propName, getSetOrder, method.elementName(), method.parameters().stream().count(), method});
        }
        return null;
    }

    private static IMethod getOverwrittenMethod(IMethod method) {
        String refSig = method.identifier();
        return method.requireDeclaringType().methods().withSuperClasses(true).stream().filter(element -> !method.equals(element) && refSig.equals(element.identifier())).findAny().orElse(null);
    }

    protected static CompositeObject createConstructorKey(Collection<IMethodParameter> list) {
        if (list == null) {
            return new CompositeObject(new Object[]{0, ""});
        }
        String b = list.stream().map(p -> p.dataType().name()).collect(Collectors.joining());
        return new CompositeObject(new Object[]{list.size(), b});
    }

    public static Predicate<IType> instanceOf(String type) {
        return candidate -> candidate.isInstanceOf(type);
    }

    public IType getType() {
        return this.m_type;
    }

    protected List<? extends IJavaElement> getElementsInternal(IStructuredType.Categories category) {
        this.cache(category);
        return this.m_elements.get((Object)category);
    }

    @Override
    public List<IJavaElement> getElements(IStructuredType.Categories category) {
        return new ArrayList<IJavaElement>(this.getElementsInternal(category));
    }

    @Override
    public <T extends IJavaElement> List<T> getElements(IStructuredType.Categories category, Class<T> clazz) {
        List<? extends IJavaElement> elements = this.getElementsInternal(category);
        if (elements == null) {
            return Collections.emptyList();
        }
        return elements.stream().map(e -> e).collect(Collectors.toList());
    }

    @Override
    public IJavaElement getSiblingMethodFieldGetter(String methodName) {
        return this.getSibling(methodName, IStructuredType.Categories.METHOD_INNER_TYPE_GETTER);
    }

    protected IJavaElement getSibling(String siblingName, IStructuredType.Categories ... categories) {
        for (IStructuredType.Categories cat : categories) {
            List<? extends IJavaElement> references = this.getElementsInternal(cat);
            if (references != null && !references.isEmpty()) {
                for (IJavaElement iJavaElement : references) {
                    if (iJavaElement.elementName().compareTo(siblingName) <= 0) continue;
                    return iJavaElement;
                }
                return references.getLast();
            }
            IJavaElement sibling = this.getSibling(cat);
            if (sibling == null) continue;
            return sibling;
        }
        return null;
    }

    @Override
    public IJavaElement getSibling(IStructuredType.Categories category) {
        IStructuredType.Categories[] methodCategories;
        boolean search = false;
        for (IStructuredType.Categories methodCategory : methodCategories = IStructuredType.Categories.values()) {
            this.cache(methodCategory);
            if (search) {
                List<? extends IJavaElement> elements = this.getElementsInternal(methodCategory);
                if (elements == null || elements.isEmpty()) continue;
                return elements.getFirst();
            }
            if (methodCategory != category) continue;
            search = true;
        }
        return null;
    }

    protected final void cache(IStructuredType.Categories category) {
        if (this.m_enabledCategories.contains((Object)category) && !this.m_visitedCategories.contains((Object)category)) {
            ArrayList<IJavaElement> unknownMethods = new ArrayList<IJavaElement>((Collection)this.m_elements.get((Object)IStructuredType.Categories.METHOD_UNCATEGORIZED));
            ArrayList<IJavaElement> unknownTypes = new ArrayList<IJavaElement>((Collection)this.m_elements.get((Object)IStructuredType.Categories.TYPE_UNCATEGORIZED));
            switch (category) {
                case FIELD_LOGGER: 
                case FIELD_STATIC: 
                case FIELD_MEMBER: {
                    this.visitFields(new ArrayList<IJavaElement>((Collection)this.m_elements.get((Object)IStructuredType.Categories.FIELD_UNKNOWN)));
                    this.m_visitedCategories.add(IStructuredType.Categories.FIELD_LOGGER);
                    this.m_visitedCategories.add(IStructuredType.Categories.FIELD_STATIC);
                    this.m_visitedCategories.add(IStructuredType.Categories.FIELD_MEMBER);
                    break;
                }
                case METHOD_CONSTRUCTOR: {
                    this.visitMethodConstructors(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_CONSTRUCTOR);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_CONFIG_PROPERTY: {
                    this.visitMethodConfigProperty(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_CONFIG_PROPERTY);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_CONFIG_EXEC: {
                    this.visitMethodConfigExec(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_CONFIG_EXEC);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_FORM_DATA_BEAN: {
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_FORM_DATA_BEAN);
                    this.visitMethodFormDataBean(unknownMethods);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_OVERRIDDEN: {
                    this.visitMethodOverridden(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_OVERRIDDEN);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_START_HANDLER: {
                    this.visitMethodStartHandler(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_START_HANDLER);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_INNER_TYPE_GETTER: {
                    this.visitMethodInnerTypeGetter(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_INNER_TYPE_GETTER);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case METHOD_LOCAL_BEAN: {
                    this.visitMethodLocalBean(unknownMethods);
                    this.m_visitedCategories.add(IStructuredType.Categories.METHOD_LOCAL_BEAN);
                    this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, unknownMethods);
                    break;
                }
                case TYPE_FORM_FIELD: {
                    this.visitTypeFormFields(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_FORM_FIELD);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_COLUMN: {
                    this.visitTypeColumns(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_COLUMN);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_CODE: {
                    this.visitTypeCodes(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_CODE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_FORM: {
                    this.visitTypeForms(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_FORM);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_TABLE: {
                    this.visitTypeTables(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_TABLE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_TREE: {
                    this.visitTypeTrees(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_TREE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_CALENDAR: {
                    this.visitTypeCalendar(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_CALENDAR);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_CALENDAR_ITEM_PROVIDER: {
                    this.visitTypeCalendarItemProvider(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_CALENDAR_ITEM_PROVIDER);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_WIZARD: {
                    this.visitTypeWizards(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_WIZARD);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_WIZARD_STEP: {
                    this.visitTypeWizardSteps(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_WIZARD_STEP);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_MENU: {
                    this.visitTypeMenus(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_MENU);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_VIEW_BUTTON: {
                    this.visitTypeViewButtons(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_VIEW_BUTTON);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_KEYSTROKE: {
                    this.visitTypeKeystrokes(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_KEYSTROKE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_COMPOSER_ATTRIBUTE: {
                    this.visitTypeComposerAttribute(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_COMPOSER_ATTRIBUTE);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_COMPOSER_ENTRY: {
                    this.visitTypeDataModelEntry(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_COMPOSER_ENTRY);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                    break;
                }
                case TYPE_FORM_HANDLER: {
                    this.visitTypeFormHandlers(unknownTypes);
                    this.m_visitedCategories.add(IStructuredType.Categories.TYPE_FORM_HANDLER);
                    this.m_elements.put(IStructuredType.Categories.TYPE_UNCATEGORIZED, unknownTypes);
                }
            }
        }
    }

    protected void visitFields(List<IJavaElement> workingSet) {
        ArrayList<IField> loggers = new ArrayList<IField>(2);
        ArrayList<IField> statics = new ArrayList<IField>();
        ArrayList<IField> members = new ArrayList<IField>();
        Optional<String> logger = this.scoutApi().map(IScoutVariousApi::Logger).map(ITypeNameSupplier::fqn);
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IField f = (IField)it.next();
            if ((f.flags() & 8) != 0) {
                String fieldDataType = f.dataType().reference();
                if (logger.isPresent() && logger.orElseThrow().equals(fieldDataType)) {
                    loggers.add(f);
                } else {
                    statics.add(f);
                }
            } else {
                members.add(f);
            }
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.FIELD_LOGGER, loggers);
        this.m_elements.put(IStructuredType.Categories.FIELD_STATIC, statics);
        this.m_elements.put(IStructuredType.Categories.FIELD_MEMBER, members);
        this.m_elements.put(IStructuredType.Categories.FIELD_UNKNOWN, workingSet);
    }

    protected void visitMethodConstructors(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> constructors = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            if (!method.isConstructor()) continue;
            CompositeObject key = StructuredType.createConstructorKey(method.parameters().stream().collect(Collectors.toList()));
            constructors.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_CONSTRUCTOR, new ArrayList(constructors.values()));
    }

    protected void visitMethodConfigExec(Iterable<IJavaElement> workingSet) {
        this.visitMethodWithPrefix(workingSet, "exec", IStructuredType.Categories.METHOD_CONFIG_EXEC);
    }

    protected void visitMethodConfigProperty(Iterable<IJavaElement> workingSet) {
        this.visitMethodWithPrefix(workingSet, "getConfigured", IStructuredType.Categories.METHOD_CONFIG_PROPERTY);
    }

    protected void visitMethodWithPrefix(Iterable<IJavaElement> workingSet, String prefix, IStructuredType.Categories category) {
        TreeMap<CompositeObject, IMethod> methods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        block0: while (it.hasNext()) {
            IMethod method;
            IMethod visitedMethod = method = (IMethod)it.next();
            while (visitedMethod != null) {
                String methodName = visitedMethod.elementName();
                if (methodName.length() > prefix.length() && methodName.startsWith(prefix)) {
                    CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().stream().count(), method});
                    methods.put(key, method);
                    it.remove();
                    continue block0;
                }
                visitedMethod = StructuredType.getOverwrittenMethod(visitedMethod);
            }
        }
        this.m_elements.put(category, new ArrayList(methods.values()));
    }

    protected void visitMethodFormDataBean(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> methods = new TreeMap<CompositeObject, IMethod>();
        Optional<IScoutApi> scoutApi = this.scoutApi();
        if (scoutApi.isPresent()) {
            IScoutApi api = scoutApi.orElseThrow();
            String formDataFqn = api.FormData().fqn();
            Iterator<IJavaElement> it = workingSet.iterator();
            while (it.hasNext()) {
                IMethod method = (IMethod)it.next();
                if (!method.annotations().withName((CharSequence)formDataFqn).existsAny()) continue;
                CompositeObject methodKey = StructuredType.createPropertyMethodKey(method);
                if (methodKey != null) {
                    methods.put(methodKey, method);
                    it.remove();
                    continue;
                }
                SdkLog.warning((CharSequence)"could not parse property method '{}'.", (Object[])new Object[]{method.elementName()});
            }
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_FORM_DATA_BEAN, new ArrayList(methods.values()));
    }

    protected void visitMethodOverridden(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> overriddenMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            if (StructuredType.getOverwrittenMethod(method) == null) continue;
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().stream().count(), method});
            overriddenMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_OVERRIDDEN, new ArrayList(overriddenMethods.values()));
    }

    protected void visitMethodStartHandler(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> startHandlerMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            Matcher matcher = START_HANDLER_REGEX.matcher(method.elementName());
            if (!matcher.find()) continue;
            String fieldName = matcher.group(1);
            if (!((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)this.getType().innerTypes().withRecursiveInnerTypes(true)).withSimpleName((CharSequence)(fieldName + "Handler"))).existsAny()) continue;
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().stream().count(), method});
            startHandlerMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_START_HANDLER, new ArrayList(startHandlerMethods.values()));
    }

    protected void visitMethodInnerTypeGetter(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> fieldGetterMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            Matcher matcher = METHOD_INNER_TYPE_GETTER_REGEX.matcher(method.elementName());
            if (!matcher.find()) continue;
            String fieldName = matcher.group(1);
            if (!((HierarchyInnerTypeQuery)((HierarchyInnerTypeQuery)this.getType().innerTypes().withRecursiveInnerTypes(true)).withSimpleName((CharSequence)fieldName)).existsAny()) continue;
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().stream().count(), method});
            fieldGetterMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_INNER_TYPE_GETTER, new ArrayList(fieldGetterMethods.values()));
    }

    protected void visitMethodLocalBean(Iterable<IJavaElement> workingSet) {
        TreeMap<CompositeObject, IMethod> localPropertyMethods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IJavaElement> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            CompositeObject key = StructuredType.createPropertyMethodKey(method);
            if (key == null) continue;
            localPropertyMethods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_LOCAL_BEAN, new ArrayList(localPropertyMethods.values()));
    }

    protected void visitMethodUncategorized(Iterable<IMethod> workingSet) {
        TreeMap<CompositeObject, IMethod> methods = new TreeMap<CompositeObject, IMethod>();
        Iterator<IMethod> it = workingSet.iterator();
        while (it.hasNext()) {
            IMethod method = it.next();
            CompositeObject key = new CompositeObject(new Object[]{method.elementName(), method.parameters().stream().count(), method});
            methods.put(key, method);
            it.remove();
        }
        this.m_elements.put(IStructuredType.Categories.METHOD_UNCATEGORIZED, new ArrayList(methods.values()));
    }

    protected void visitTypeFormFields(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IFormField, IStructuredType.Categories.TYPE_FORM_FIELD, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeColumns(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IColumn, IStructuredType.Categories.TYPE_COLUMN, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeCodes(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::ICode, IStructuredType.Categories.TYPE_CODE, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeForms(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IForm, IStructuredType.Categories.TYPE_FORM, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeTables(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::ITable, IStructuredType.Categories.TYPE_TABLE, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeTrees(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::ITree, IStructuredType.Categories.TYPE_TREE, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeCalendar(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::ICalendar, IStructuredType.Categories.TYPE_CALENDAR, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeCalendarItemProvider(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::ICalendarItemProvider, IStructuredType.Categories.TYPE_CALENDAR_ITEM_PROVIDER, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeWizards(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IWizard, IStructuredType.Categories.TYPE_WIZARD, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeWizardSteps(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IWizardStep, IStructuredType.Categories.TYPE_WIZARD_STEP, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeMenus(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IMenu, IStructuredType.Categories.TYPE_MENU, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeViewButtons(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IViewButton, IStructuredType.Categories.TYPE_VIEW_BUTTON, ScoutTypeComparators.orderAnnotationComparator(false));
    }

    protected void visitTypeKeystrokes(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IKeyStroke, IStructuredType.Categories.TYPE_KEYSTROKE, ScoutTypeComparators.BY_NAME);
    }

    protected void visitTypeComposerAttribute(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IDataModelAttribute, IStructuredType.Categories.TYPE_COMPOSER_ATTRIBUTE, ScoutTypeComparators.BY_NAME);
    }

    protected void visitTypeDataModelEntry(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IDataModelEntity, IStructuredType.Categories.TYPE_COMPOSER_ENTRY, ScoutTypeComparators.BY_NAME);
    }

    protected void visitTypeFormHandlers(Iterable<IJavaElement> workingSet) {
        this.consumeType(workingSet, IScoutInterfaceApi::IFormHandler, IStructuredType.Categories.TYPE_FORM_HANDLER, ScoutTypeComparators.BY_NAME);
    }

    protected void consumeType(Iterable<IJavaElement> workingSet, Function<IScoutApi, ITypeNameSupplier> typeInterface, IStructuredType.Categories category, Comparator<IType> comparator) {
        TreeSet<IType> types = new TreeSet<IType>(comparator);
        IScoutApi scoutApi = this.scoutApi().orElse(null);
        if (scoutApi != null) {
            String fqn = typeInterface.apply(scoutApi).fqn();
            Predicate<IType> filter = CLASS_FILTER.and(StructuredType.instanceOf(fqn));
            Iterator<IJavaElement> it = workingSet.iterator();
            while (it.hasNext()) {
                IType candidate = (IType)it.next();
                if (!filter.test(candidate)) continue;
                types.add(candidate);
                it.remove();
            }
        }
        this.m_elements.put(category, new ArrayList<IType>(types));
    }
}

