/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.builder.expression;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.JavaUtils;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.JavaSourceBuilderWrapper;
import org.eclipse.scout.sdk.core.java.builder.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.util.Ensure;

public class ExpressionBuilder<TYPE extends IExpressionBuilder<TYPE>>
extends JavaSourceBuilderWrapper<TYPE>
implements IExpressionBuilder<TYPE> {
    protected ExpressionBuilder(ISourceBuilder<?> inner) {
        super(inner);
    }

    public static IExpressionBuilder<?> create(ISourceBuilder<?> inner) {
        return new ExpressionBuilder(inner);
    }

    @Override
    public TYPE classLiteral(CharSequence reference) {
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)this.ref(reference)).append(".class"));
    }

    @Override
    public <T extends IApiSpecification> TYPE classLiteralFrom(Class<T> apiClass, Function<T, ITypeNameSupplier> nameSupplier) {
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)this.refClassFrom(apiClass, nameSupplier)).append(".class"));
    }

    @Override
    public TYPE classLiteralFunc(Function<IJavaBuilderContext, ITypeNameSupplier> func) {
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)this.refClassFunc(func)).append(".class"));
    }

    @Override
    public TYPE appendNew() {
        return (TYPE)((IExpressionBuilder)this.append("new "));
    }

    @Override
    public <API extends IApiSpecification> TYPE appendNewFrom(Class<API> apiClass, Function<API, ITypeNameSupplier> sourceProvider) {
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)this.appendNew().refClassFrom(apiClass, sourceProvider)).parenthesisOpen());
    }

    @Override
    public TYPE appendNew(CharSequence ref) {
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)this.appendNew().ref(ref)).parenthesisOpen());
    }

    @Override
    public TYPE appendThrow() {
        return (TYPE)((IExpressionBuilder)this.append("throw "));
    }

    @Override
    public TYPE appendNot() {
        return (TYPE)((IExpressionBuilder)this.append('!'));
    }

    @Override
    public TYPE appendIf() {
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)((IExpressionBuilder)this.append("if")).space()).parenthesisOpen());
    }

    @Override
    public TYPE stringLiteral(CharSequence literalValue) {
        if (literalValue == null) {
            return this.nullLiteral();
        }
        return (TYPE)((IExpressionBuilder)this.append(JavaUtils.toStringLiteral(literalValue)));
    }

    @Override
    public TYPE appendDefaultValueOf(CharSequence dataTypeFqn) {
        String defaultVal = JavaTypes.defaultValueOf(dataTypeFqn);
        if (defaultVal != null) {
            return (TYPE)((IExpressionBuilder)this.append(defaultVal));
        }
        return (TYPE)((IExpressionBuilder)this.thisInstance());
    }

    @Override
    public TYPE enumValue(CharSequence enumType, CharSequence enumField) {
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)((IExpressionBuilder)this.ref(enumType)).dot()).append((CharSequence)Ensure.notNull((Object)enumField)));
    }

    @Override
    public TYPE stringLiteralArray(CharSequence ... elements) {
        return this.stringLiteralArray(elements, false);
    }

    @Override
    public TYPE stringLiteralArray(CharSequence[] elements, boolean formatWithNewlines) {
        return this.stringLiteralArray(elements, formatWithNewlines, false);
    }

    @Override
    public TYPE stringLiteralArray(CharSequence[] elements, boolean formatWithNewlines, boolean stringLiteralOnSingleElementArray) {
        Ensure.notNull((Object)elements);
        if (stringLiteralOnSingleElementArray && elements.length == 1) {
            return this.stringLiteral(elements[0]);
        }
        return this.stringLiteralArray(Arrays.stream(elements), formatWithNewlines);
    }

    @Override
    public TYPE stringLiteralArray(Stream<? extends CharSequence> elements, boolean formatWithNewlines) {
        Stream<ISourceGenerator> stringLiteralGenerators = ((Stream)Ensure.notNull(elements)).map(e -> b -> b.stringLiteral((CharSequence)e)).map(g -> g.generalize(ExpressionBuilder::create));
        return this.array(stringLiteralGenerators, formatWithNewlines);
    }

    @Override
    public TYPE nullLiteral() {
        return (TYPE)((IExpressionBuilder)this.append("null"));
    }

    @Override
    public TYPE array(Stream<? extends ISourceGenerator<ISourceBuilder<?>>> elements, boolean formatWithNewlines) {
        Object elementSeparator;
        String blockSeparator;
        if (formatWithNewlines) {
            blockSeparator = this.context().lineDelimiter();
            elementSeparator = "," + blockSeparator;
        } else {
            blockSeparator = null;
            elementSeparator = ", ";
        }
        return (TYPE)((IExpressionBuilder)((IExpressionBuilder)((IExpressionBuilder)this.blockStart()).append((Stream)Ensure.notNull(elements), blockSeparator, (CharSequence)elementSeparator, blockSeparator)).blockEnd());
    }
}

