/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.nio.file.Path;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModulesProviderSpi;
import org.eclipse.scout.sdk.core.util.EventListenerList;

public final class NodeModulesProvider {
    private static final Map<Object, NodeModulesProviderSpi> providers = new HashMap<Object, NodeModulesProviderSpi>();
    private static final EventListenerList listeners = new EventListenerList();

    private NodeModulesProvider() {
    }

    public static synchronized void registerProvider(Object context, NodeModulesProviderSpi provider) {
        if (provider == null) {
            providers.remove(context);
        } else {
            providers.put(context, provider);
        }
    }

    public static synchronized Optional<NodeModulesProviderSpi> getProvider(Object context) {
        return Optional.ofNullable(providers.get(context));
    }

    public static void removeProvider(Object context) {
        NodeModulesProvider.registerProvider(context, null);
    }

    public static Optional<NodeModuleSpi> createNodeModule(Path nodeModuleDir, Object context) {
        return NodeModulesProvider.getProvider(context).flatMap(p -> p.create(nodeModuleDir));
    }

    public static synchronized Set<NodeModuleSpi> removeNodeModule(Path changedPath) {
        Set<NodeModuleSpi> removed = providers.values().stream().flatMap(p -> p.remove(changedPath).stream()).collect(Collectors.toUnmodifiableSet());
        NodeModulesProvider.triggerRemoved(removed);
        return removed;
    }

    public static synchronized void clearNodeModules() {
        providers.values().forEach(NodeModulesProviderSpi::clear);
        NodeModulesProvider.triggerRemoved(null);
    }

    public static void addListener(INodeModulesRemovedListener listener) {
        if (listener == null) {
            return;
        }
        listeners.add((EventListener)listener);
    }

    public static void removeListener(INodeModulesRemovedListener listener) {
        if (listener == null) {
            return;
        }
        listeners.remove((EventListener)listener);
    }

    private static void triggerRemoved(Set<NodeModuleSpi> removed) {
        if (removed != null && removed.isEmpty()) {
            return;
        }
        listeners.get(INodeModulesRemovedListener.class).forEach(listener -> listener.nodeModulesRemoved(removed));
    }

    public static interface INodeModulesRemovedListener
    extends EventListener {
        public void nodeModulesRemoved(Set<NodeModuleSpi> var1);
    }
}

