/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.datatypedetect;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.IPropertyDataTypeOverride;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsPropertySubType;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsPropertyType;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class AbstractStringArrayMethodCallOverride
implements IPropertyDataTypeOverride {
    protected static final String PROPERTY_TYPE_METHOD_REGEX_PREFIX = "this\\.";
    protected static final String PROPERTY_TYPE_METHOD_REGEX_SUFFIX = "\\(\\[?([^])]+)";
    protected static final Pattern REGEX_COMMA = Pattern.compile(",");
    private final Map<String, Boolean> m_overrides;
    private final ScoutJsPropertySubType m_subType;

    protected AbstractStringArrayMethodCallOverride(Stream<String> names) {
        this(names, ScoutJsPropertySubType.NOTHING);
    }

    protected AbstractStringArrayMethodCallOverride(Stream<String> names, ScoutJsPropertySubType subType) {
        this.m_overrides = names.collect(Collectors.toMap(Function.identity(), s -> Boolean.FALSE, (a, b) -> Boolean.FALSE));
        this.m_subType = subType;
    }

    @Override
    public Optional<ScoutJsPropertyType> getOverrideFor(ScoutJsProperty property) {
        IField field = property.field();
        String fieldName = field.name();
        if (this.m_overrides.containsKey(fieldName)) {
            this.markUsed(fieldName);
            return Optional.ofNullable(this.createPropertyType(field.dataType().map(IDataType::arrayDimension).orElse(0), property));
        }
        return Optional.empty();
    }

    @Override
    public void markUsed(String propertyName) {
        this.m_overrides.computeIfPresent(propertyName, (k, v) -> Boolean.TRUE);
    }

    protected ScoutJsPropertyType createPropertyType(int arrayDimension, ScoutJsProperty property) {
        IDataType detectedOverride = this.getOverrideType();
        IDataType dataType = detectedOverride.createArrayType(arrayDimension);
        return new ScoutJsPropertyType(dataType, this.m_subType, property);
    }

    protected abstract IDataType getOverrideType();

    @Override
    public Map<String, IDataType> unused() {
        return this.m_overrides.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> this.getOverrideType()));
    }

    protected static Stream<String> parseMethodCallWithStringArguments(INodeElement function, Pattern propertyTypePattern) {
        return function.source().map(SourceRange::asCharSequence).map(source -> AbstractStringArrayMethodCallOverride.parseMethodCallWithStringArguments(source, propertyTypePattern)).orElse(Stream.empty());
    }

    protected static Stream<String> parseMethodCallWithStringArguments(CharSequence source, Pattern propertyTypePattern) {
        return propertyTypePattern.matcher(source).results().map(result -> result.group(1)).flatMap(AbstractStringArrayMethodCallOverride::splitPropertyNames);
    }

    protected static Stream<String> splitPropertyNames(CharSequence propertyNames) {
        return REGEX_COMMA.splitAsStream(propertyNames).map(Strings::trim).map(Strings::withoutQuotes).map(Strings::trim).filter(s -> !s.isEmpty()).map(Object::toString);
    }
}

