/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.utils;

public final class Strings {
    public static String escapeRegExpCharacters(String value) {
        return value.replaceAll("[\\-\\\\\\{\\}\\*\\+\\?\\|\\^\\$\\.\\[\\]\\(\\)\\#]", "\\\\$0");
    }

    public static int firstNonWhitespaceIndex(String text) {
        int i = 0;
        int len = text.length();
        while (i < len) {
            char ch = text.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getLeadingWhitespace(String searchIn) {
        return Strings.getLeadingWhitespace(searchIn, 0, searchIn.length());
    }

    public static String getLeadingWhitespace(String searchIn, int startAt) {
        return Strings.getLeadingWhitespace(searchIn, startAt, searchIn.length());
    }

    public static String getLeadingWhitespace(String searchIn, int startAt, int endAt) {
        int i = startAt;
        while (i < endAt) {
            char ch = searchIn.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return searchIn.substring(startAt, i);
            }
            ++i;
        }
        return searchIn.substring(startAt, endAt);
    }

    public static int lastNonWhitespaceIndex(String str) {
        return Strings.lastNonWhitespaceIndex(str, str.length() - 1);
    }

    public static int lastNonWhitespaceIndex(String str, int startIndex) {
        int i = startIndex;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (!Character.isWhitespace(ch)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private Strings() {
    }
}

