/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.editors.LocalTaskEditorContributionDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensionPartDescriptor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;

public class TaskEditorContributionExtensionReader {
    private static final String ATTR_ID = "id";
    public static final String EXTENSION_TASK_EDITOR_PAGE_CONTRIBUTION = "org.eclipse.mylyn.tasks.ui.taskEditorPageContribution";
    private static final String REPOSITORY_TASK_EDITOR_CONTRIBUTION = "repositoryPart";
    private static final String LOCAL_TASK_EDITOR_CONTRIBUTION = "localPart";
    private static Collection<TaskEditorPartDescriptor> repositoryEditorContributions;
    private static Collection<LocalTaskEditorContributionDescriptor> localEditorContributions;

    public static Collection<LocalTaskEditorContributionDescriptor> getLocalEditorContributions() {
        if (localEditorContributions == null) {
            TaskEditorContributionExtensionReader.initExtensions();
        }
        return Collections.unmodifiableCollection(localEditorContributions);
    }

    public static Collection<TaskEditorPartDescriptor> getRepositoryEditorContributions() {
        if (repositoryEditorContributions == null) {
            TaskEditorContributionExtensionReader.initExtensions();
        }
        return Collections.unmodifiableCollection(repositoryEditorContributions);
    }

    private static void initExtensions() {
        IExtension[] editorExtensions;
        ArrayList<TaskEditorPartDescriptor> repositoryContributions = new ArrayList<TaskEditorPartDescriptor>();
        ArrayList<LocalTaskEditorContributionDescriptor> localContributions = new ArrayList<LocalTaskEditorContributionDescriptor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint editorExtensionPoint = registry.getExtensionPoint(EXTENSION_TASK_EDITOR_PAGE_CONTRIBUTION);
        IExtension[] iExtensionArray = editorExtensions = editorExtensionPoint.getExtensions();
        int n = editorExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(REPOSITORY_TASK_EDITOR_CONTRIBUTION)) {
                    TaskEditorContributionExtensionReader.readRepositoryEditorContributionExtension(element, repositoryContributions);
                } else if (element.getName().equals(LOCAL_TASK_EDITOR_CONTRIBUTION)) {
                    TaskEditorContributionExtensionReader.readLocalEditorContributionExtension(element, localContributions);
                }
                ++n4;
            }
            ++n2;
        }
        repositoryEditorContributions = repositoryContributions;
        localEditorContributions = localContributions;
    }

    private static void readRepositoryEditorContributionExtension(IConfigurationElement element, Collection<TaskEditorPartDescriptor> contributions) {
        try {
            String id = element.getAttribute(ATTR_ID);
            TaskEditorExtensionPartDescriptor descriptor = new TaskEditorExtensionPartDescriptor(id, element);
            contributions.add(descriptor);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to read repository editor contribution", (Throwable)e));
        }
    }

    private static void readLocalEditorContributionExtension(IConfigurationElement element, Collection<LocalTaskEditorContributionDescriptor> localContributions) {
        try {
            localContributions.add(new LocalTaskEditorContributionDescriptor(element));
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to read local editor contribution", (Throwable)e));
        }
    }
}

