/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.core5.http.protocol.HttpContext;

class CacheCredentialsProvider
implements CredentialsStore {
    private static final String AUTHENTICATION_SCOPE_MAY_NOT_BE_NULL = "Authentication scope may not be null";
    private final HashMap<AuthScope, Credentials> credentials = new HashMap();

    public synchronized void removeCredentials(AuthScope authscope) {
        Map.Entry<AuthScope, Credentials> nextMatch;
        if (authscope == null) {
            throw new IllegalArgumentException(AUTHENTICATION_SCOPE_MAY_NOT_BE_NULL);
        }
        Credentials match = this.getCredentials(authscope, null);
        if (match == null) {
            return;
        }
        Iterator<Map.Entry<AuthScope, Credentials>> entries = this.credentials.entrySet().iterator();
        while ((nextMatch = CacheCredentialsProvider.findNextCredentials(entries, authscope, -1)) != null) {
            Credentials nextCredentials = nextMatch.getValue();
            if (!match.equals(nextCredentials)) continue;
            entries.remove();
        }
    }

    public synchronized void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException(AUTHENTICATION_SCOPE_MAY_NOT_BE_NULL);
        }
        if (credentials == null) {
            this.removeCredentials(authscope);
        } else {
            this.credentials.put(authscope, credentials);
        }
    }

    private Credentials findBestCredentials(AuthScope authscope) {
        Credentials bestMatch = this.credentials.get(authscope);
        if (bestMatch == null) {
            Map.Entry<AuthScope, Credentials> nextMatch;
            int bestMatchFactor = -1;
            Iterator<Map.Entry<AuthScope, Credentials>> entries = this.credentials.entrySet().iterator();
            while ((nextMatch = CacheCredentialsProvider.findNextCredentials(entries, authscope, bestMatchFactor)) != null) {
                bestMatch = nextMatch.getValue();
                bestMatchFactor = authscope.match(nextMatch.getKey());
            }
        }
        return bestMatch;
    }

    private static Map.Entry<AuthScope, Credentials> findNextCredentials(Iterator<Map.Entry<AuthScope, Credentials>> iterator, AuthScope authscope, int minFactor) {
        while (iterator.hasNext()) {
            Map.Entry<AuthScope, Credentials> current = iterator.next();
            int factor = authscope.match(current.getKey());
            if (factor <= minFactor) continue;
            return current;
        }
        return null;
    }

    public synchronized Credentials getCredentials(AuthScope authscope, HttpContext context) {
        if (authscope == null) {
            throw new IllegalArgumentException(AUTHENTICATION_SCOPE_MAY_NOT_BE_NULL);
        }
        return this.findBestCredentials(authscope);
    }

    public synchronized void clear() {
        this.credentials.clear();
    }

    public String toString() {
        return this.credentials.toString();
    }
}

