/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.spi;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeNameEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.internal.DataTypeImplementor;
import org.eclipse.scout.sdk.core.typescript.model.spi.AbstractNodeElementSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.DataTypeSpi;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class SimpleCompositeDataTypeSpi
extends AbstractNodeElementSpi<IDataType>
implements DataTypeSpi {
    private final IDataType.DataTypeFlavor m_flavor;
    private final Collection<DataTypeSpi> m_componentDataTypes;
    private final int m_arrayDimension;
    private final FinalValue<String> m_name = new FinalValue();

    protected SimpleCompositeDataTypeSpi(NodeModuleSpi module, IDataType.DataTypeFlavor flavor, Collection<DataTypeSpi> componentDataTypes, int arrayDimension) {
        super(module);
        this.m_flavor = (IDataType.DataTypeFlavor)((Object)Ensure.notNull((Object)((Object)flavor)));
        this.m_componentDataTypes = componentDataTypes;
        this.m_arrayDimension = arrayDimension;
    }

    @Override
    public INodeElement.ExportType exportType() {
        return INodeElement.ExportType.NONE;
    }

    @Override
    protected Path resolveContainingFile() {
        return null;
    }

    @Override
    protected IDataType createApi() {
        return new DataTypeImplementor<SimpleCompositeDataTypeSpi>(this);
    }

    @Override
    public String name() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> new DataTypeNameEvaluator().eval((IDataType)this.api()));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public IDataType.DataTypeFlavor flavor() {
        return this.m_flavor;
    }

    @Override
    public Collection<DataTypeSpi> childTypes() {
        return Collections.unmodifiableCollection(this.m_componentDataTypes);
    }

    @Override
    public int arrayDimension() {
        return this.m_arrayDimension;
    }

    @Override
    public Optional<SourceRange> source() {
        return Optional.empty();
    }
}

