/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.revision.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowVersionsHandler
extends AbstractHistoryCommandHandler {
    public static final String COMPARE_MODE_PARAM = "org.eclipse.egit.ui.history.CompareMode";
    public static final String COMMAND_ID = "org.eclipse.egit.ui.history.ShowVersions";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        GitCompareFileRevisionEditorInput in;
        ITypedElement right;
        IFileRevision rev;
        String commitPath;
        IFile resource;
        RepositoryMapping map;
        boolean compareMode = Boolean.TRUE.toString().equals(event.getParameter(COMPARE_MODE_PARAM));
        IStructuredSelection selection = this.getSelection(this.getPage());
        if (selection.size() < 1) {
            return null;
        }
        Object input = this.getPage().getInputInternal().getSingleFile();
        if (input == null) {
            return null;
        }
        IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        boolean errorOccurred = false;
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        String gitPath = null;
        if (input instanceof IFile && (map = RepositoryMapping.getMapping((IResource)(resource = (IFile)input))) != null) {
            gitPath = map.getRepoRelativePath((IResource)resource);
            for (RevCommit commit : selection) {
                commitPath = this.getRenamedPath(gitPath, (ObjectId)commit);
                rev = null;
                try {
                    rev = CompareUtils.getFileRevision(commitPath, commit, map.getRepository(), null);
                }
                catch (IOException e) {
                    Activator.logError(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)gitPath, (Object)commit.getId()), e);
                    errorOccurred = true;
                }
                if (rev != null) {
                    if (compareMode) {
                        right = CompareUtils.getFileRevisionTypedElement(commitPath, commit, map.getRepository());
                        in = new GitCompareFileRevisionEditorInput(SaveableCompareEditorInput.createFileElement((IFile)resource), right, null);
                        try {
                            CompareUtils.openInCompare(workbenchPage, map.getRepository(), (CompareEditorInput)in);
                        }
                        catch (Exception e) {
                            errorOccurred = true;
                        }
                        continue;
                    }
                    try {
                        EgitUiEditorUtils.openEditor(this.getPart(event).getSite().getPage(), rev, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Activator.logError(UIText.GitHistoryPage_openFailed, e);
                        errorOccurred = true;
                    }
                    continue;
                }
                ids.add(commit.getId());
            }
        }
        if (input instanceof File) {
            File fileInput = (File)input;
            Repository repo = this.getRepository(event);
            gitPath = this.getRepoRelativePath(repo, fileInput);
            for (RevCommit commit : selection) {
                commitPath = this.getRenamedPath(gitPath, (ObjectId)commit);
                rev = null;
                try {
                    rev = CompareUtils.getFileRevision(commitPath, commit, repo, null);
                }
                catch (IOException e) {
                    Activator.logError(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)commitPath, (Object)commit.getId()), e);
                    errorOccurred = true;
                }
                if (rev != null) {
                    if (compareMode) {
                        right = CompareUtils.getFileRevisionTypedElement(commitPath, commit, repo);
                        in = new GitCompareFileRevisionEditorInput((ITypedElement)new LocalNonWorkspaceTypedElement(repo, (IPath)new Path(fileInput.getAbsolutePath())), right, null);
                        CompareUtils.openInCompare(workbenchPage, repo, (CompareEditorInput)in);
                        continue;
                    }
                    try {
                        EgitUiEditorUtils.openEditor(this.getPart(event).getSite().getPage(), rev, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Activator.logError(UIText.GitHistoryPage_openFailed, e);
                        errorOccurred = true;
                    }
                    continue;
                }
                ids.add(commit.getId());
            }
        }
        if (errorOccurred) {
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
        }
        if (ids.size() > 0) {
            StringBuilder idList = new StringBuilder("");
            for (ObjectId objectId : ids) {
                idList.append(objectId.getName()).append(' ');
            }
            MessageDialog.openError((Shell)this.getPart(event).getSite().getShell(), (String)UIText.GitHistoryPage_fileNotFound, (String)NLS.bind((String)UIText.GitHistoryPage_notContainedInCommits, (Object)gitPath, (Object)idList.toString()));
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        int size = this.getSelection(page).size();
        if (size == 0) {
            return false;
        }
        return page.getInputInternal().isSingleFile();
    }
}

