/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;
import org.eclipse.swtchart.extensions.properties.AbstractPage;

public abstract class AbstractSelectorPage
extends AbstractPage {
    protected List list;
    private String selector;
    private boolean selectorEnabled;
    protected int selectedIndex;

    protected AbstractSelectorPage(InteractiveChart chart, String title, String selector) {
        super(chart, title);
        this.selector = selector;
        this.selectedIndex = 0;
        this.selectorEnabled = true;
    }

    protected Control createContents(Composite parent) {
        String[] items = this.getListItems();
        if (items.length < 2) {
            this.selectorEnabled = false;
        }
        Composite composite = new Composite(parent, 0);
        if (this.selectorEnabled) {
            GridLayout layout = new GridLayout(3, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setText(this.selector);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            this.addLeftPanel(composite, items);
            this.addRightPanel(composite);
        } else {
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.addRightPanelContents(composite);
        }
        this.selectInitialValues();
        this.updateControlSelections();
        return composite;
    }

    protected abstract String[] getListItems();

    protected abstract void selectInitialValues();

    private void addLeftPanel(Composite parent, String[] items) {
        Composite leftPanel = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        leftPanel.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        leftPanel.setLayout((Layout)layout);
        this.list = new List(leftPanel, 2048);
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 1;
        this.list.setLayoutData((Object)gridData2);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.list.add(item);
            ++n2;
        }
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSelectorPage.this.selectedIndex = AbstractSelectorPage.this.list.getSelectionIndex();
                AbstractSelectorPage.this.updateControlSelections();
            }
        });
        this.list.select(0);
    }

    private void addRightPanel(Composite parent) {
        Composite rightPanel = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        rightPanel.setLayoutData((Object)gridData);
        rightPanel.setLayout((Layout)new GridLayout(1, false));
        this.addRightPanelContents(rightPanel);
    }

    protected abstract void addRightPanelContents(Composite var1);

    protected abstract void updateControlSelections();
}

