/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public abstract class AbstractMouseEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    @Override
    public int getEvent() {
        return 2;
    }

    @Override
    public int getButton() {
        return 4;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        this.runAction(baseChart, event);
        this.postValidateZoom(baseChart);
        baseChart.fireUpdateCustomRangeSelectionHandlers(event);
        baseChart.redraw();
    }

    protected abstract void runAction(BaseChart var1, Event var2);

    protected void postValidateZoom(BaseChart baseChart) {
        RangeRestriction rangeRestriction = baseChart.getRangeRestriction();
        IAxisSet axisSet = baseChart.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        IAxis yAxis = axisSet.getYAxis(0);
        if (rangeRestriction.isRestrictFrame()) {
            Range rangeX = xAxis.getRange();
            Range rangeY = yAxis.getRange();
            this.adjustFrame(baseChart, xAxis, rangeX, yAxis, rangeY, true);
        } else {
            baseChart.adjustSecondaryXAxes();
            baseChart.adjustSecondaryYAxes();
        }
    }

    private void adjustFrame(BaseChart baseChart, IAxis xAxis, Range rangeX, IAxis yAxis, Range rangeY, boolean adjustMinMax) {
        baseChart.setRange(xAxis, rangeX.lower, rangeX.upper, adjustMinMax);
        baseChart.setRange(yAxis, rangeY.lower, rangeY.upper, adjustMinMax);
    }
}

