/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ViewpoitnDependenciesSelectionDialog {
    private final Viewpoint viewpoint;

    public ViewpoitnDependenciesSelectionDialog(Viewpoint viewpoint) {
        this.viewpoint = viewpoint;
    }

    public Option<Set<URI>> selectReusedViewpoints(Shell shell) {
        return this.selectViewpoints(shell, DescriptionPackage.eINSTANCE.getViewpoint_Reuses(), "Reused Viewpoints", "Select the viewpoints from which this viewpoint will reuse elements:");
    }

    public Option<Set<URI>> selectCustomizedViewpoints(Shell shell) {
        return this.selectViewpoints(shell, DescriptionPackage.eINSTANCE.getViewpoint_Customizes(), "Customized Viewpoints", "Select the viewpoints this viewpoint will customize:");
    }

    public Option<Set<URI>> selectConflictsViewpoints(Shell shell) {
        return this.selectViewpoints(shell, DescriptionPackage.eINSTANCE.getViewpoint_Customizes(), "Conflicting Viewpoints", "Select the viewpoints this viewpoint is in conflict with:");
    }

    private Option<Set<URI>> selectViewpoints(Shell shell, EAttribute attribute, String title, String message) {
        List<URI> available = this.getAvailableViewpointsURIs();
        available.remove(new ViewpointQuery(this.viewpoint).getViewpointURI().get());
        Collections.sort(available, Ordering.usingToString());
        List<URI> selected = this.getSelectedSiriusURIs(this.viewpoint, (EStructuralFeature)attribute);
        ListSelectionDialog lsd = new ListSelectionDialog(shell, available, (IStructuredContentProvider)new SiriusURIContentProvider(), (ILabelProvider)new LabelProvider(), message);
        lsd.setInitialElementSelections(selected);
        lsd.setTitle(title);
        if (lsd.open() == 0) {
            ImmutableSet result = ImmutableSet.copyOf((Iterator)Iterators.filter((Iterator)Iterators.forArray((Object[])lsd.getResult()), URI.class));
            return Options.newSome((Object)result);
        }
        return Options.newNone();
    }

    private List<URI> getSelectedSiriusURIs(Viewpoint vp, EStructuralFeature feature) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)((List)vp.eGet(feature)), (Predicate)Predicates.notNull()));
    }

    private List<URI> getAvailableViewpointsURIs() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)ViewpointRegistry.getInstance().getViewpoints(), (Function)new Function<Viewpoint, URI>(){

            public URI apply(Viewpoint from) {
                Option uri = new ViewpointQuery(from).getViewpointURI();
                if (uri.some()) {
                    return (URI)uri.get();
                }
                return null;
            }
        }), (Predicate)Predicates.notNull()));
    }

    private static final class SiriusURIContentProvider
    implements IStructuredContentProvider {
        private SiriusURIContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                Iterable uris = Iterables.filter((Iterable)((List)inputElement), URI.class);
                return Iterables.toArray((Iterable)uris, URI.class);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

