/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.ui;

import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.sirius.ext.gmf.runtime.diagram.ui.tools.MoveInDiagramDragTracker;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class SnapToAllDragEditPartsTracker
extends DragEditPartsTrackerEx
implements MoveInDiagramDragTracker {
    public static final String SNAP_TO_ALL_SHAPE_KEY = "snapToAllShape";
    public static final boolean DEFAULT_SNAP_TO_SHAPE_MODE = false;
    public static final int SNAP_TO_ALL = 0x100000D;
    protected static final int MODIFIER_NO_SNAPPING = "macosx".equals(Platform.getOS()) ? 262144 : 65536;
    private boolean moveWithArrowKeysSiriusMode;
    private long accessibleBegin;
    private int accessibleStep;
    boolean snapToAllShape = false;
    private Point previousMouseLocation;

    public SnapToAllDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected void snapPoint(ChangeBoundsRequest request) {
        if (this.snapToAllShape) {
            this.getTargetRequest().getExtendedData().put(SNAP_TO_ALL_SHAPE_KEY, Boolean.TRUE);
        } else {
            this.getTargetRequest().getExtendedData().put(SNAP_TO_ALL_SHAPE_KEY, Boolean.FALSE);
        }
        if (!this.moveWithArrowKeysSiriusMode) {
            super.snapPoint(request);
        } else {
            Point moveDelta = request.getMoveDelta();
            if (this.getState() == 32) {
                int restrictedDirection = 0;
                if (moveDelta.preciseX() > 0.0) {
                    restrictedDirection |= 0x10;
                } else if (moveDelta.preciseX() < 0.0) {
                    restrictedDirection |= 8;
                }
                if (moveDelta.preciseY() > 0.0) {
                    restrictedDirection |= 4;
                } else if (moveDelta.preciseY() < 0.0) {
                    restrictedDirection |= 1;
                }
                request.getExtendedData().put("org.eclipse.gmf.runtime.diagram.ui.RestrictedDirections", restrictedDirection);
            }
            if (this.getSnapToHelper() != null && request.isSnapToEnabled()) {
                PrecisionRectangle baseRect = this.getSourceBounds().getPreciseCopy();
                PrecisionRectangle jointRect = this.getOperationSetBounds().getPreciseCopy();
                PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
                baseRect.translate((Point)preciseDelta);
                jointRect.translate((Point)preciseDelta);
                this.getSnapToHelper().snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect, jointRect}, preciseDelta);
                request.setMoveDelta((Point)preciseDelta);
            }
        }
    }

    protected boolean handleKeyDown(KeyEvent event) {
        boolean result = true;
        if (0x100000D == event.keyCode) {
            this.snapToAllShape = true;
        } else if (!this.acceptArrowKey(event)) {
            result = super.handleKeyDown(event);
        } else {
            this.moveWithArrowKeysSiriusMode = true;
            this.siriusAccStepIncrement();
            PrecisionPoint moveDelta = switch (event.keyCode) {
                case 0x1000002 -> new PrecisionPoint(0, this.siriusAccGetStep());
                case 0x1000001 -> new PrecisionPoint(0, -this.siriusAccGetStep());
                case 0x1000004 -> {
                    int stepping = this.siriusAccGetStep();
                    if (this.isCurrentViewerMirrored2()) {
                        stepping = -stepping;
                    }
                    yield new PrecisionPoint(stepping, 0);
                }
                case 0x1000003 -> {
                    int step = -this.siriusAccGetStep();
                    if (this.isCurrentViewerMirrored2()) {
                        step = -step;
                    }
                    yield new PrecisionPoint(step, 0);
                }
                default -> new PrecisionPoint(0, 0);
            };
            double zoomFactor = GraphicalHelper.getZoom((EditPart)this.getSourceEditPart());
            PrecisionPoint preciseDelta = (PrecisionPoint)new PrecisionPoint((Point)moveDelta).scale(zoomFactor);
            ChangeBoundsRequest req = this.getTargetRequest();
            if (req.getMoveDelta().preciseX() == 0.0 && req.getMoveDelta().preciseY() == 0.0) {
                req.setMoveDelta((Point)preciseDelta);
            } else {
                req.setMoveDelta(req.getMoveDelta().getTranslated((Point)preciseDelta));
            }
            req.setConstrainedResize(false);
            req.setSnapToEnabled(!this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING));
            this.setTargetEditPart(this.getSourceEditPart().getParent());
            req.setType((Object)this.getCommandName());
            req.setEditParts(this.getOperationSet());
            this.setState(32);
            this.handleDragInProgress();
        }
        return result;
    }

    protected boolean handleKeyUp(KeyEvent event) {
        if (0x100000D == event.keyCode) {
            this.snapToAllShape = false;
            return true;
        }
        if (this.acceptArrowKey(event)) {
            this.moveWithArrowKeysSiriusMode = false;
            this.siriusAccStepReset();
        }
        return super.handleKeyUp(event);
    }

    protected boolean handleButtonUp(int button) {
        boolean result = super.handleButtonUp(button);
        this.snapToAllShape = false;
        return result;
    }

    protected boolean handleButtonDown(int button) {
        if (button == 2) {
            this.setCursor(SharedCursors.HAND);
            return this.stateTransition(1, 64);
        }
        return super.handleButtonDown(button);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        this.previousMouseLocation = this.getCurrentInput().getMouseLocation().getCopy();
        super.mouseDrag(me, viewer);
    }

    protected boolean handleDragStarted() {
        if (this.isInState(64)) {
            return this.stateTransition(64, 128);
        }
        return super.handleDragStarted();
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(128)) {
            if (this.getCurrentViewer().getControl() instanceof FigureCanvas) {
                FigureCanvas figureCanvas = (FigureCanvas)this.getCurrentViewer().getControl();
                Point currentMouseLocation = this.getCurrentInput().getMouseLocation();
                Dimension difference = this.previousMouseLocation.getDifference(currentMouseLocation);
                Point location = figureCanvas.getViewport().getViewLocation();
                figureCanvas.scrollTo(location.x + difference.width, location.y + difference.height);
            }
            return true;
        }
        return super.handleDragInProgress();
    }

    private boolean isCurrentViewerMirrored2() {
        return (this.getCurrentViewer().getControl().getStyle() & 0x8000000) != 0;
    }

    protected void updateTargetRequest() {
        if (this.moveWithArrowKeysSiriusMode) {
            this.snapPoint(this.getTargetRequest());
        } else {
            super.updateTargetRequest();
        }
    }

    protected boolean updateTargetUnderMouse() {
        if (this.moveWithArrowKeysSiriusMode) {
            return false;
        }
        return super.updateTargetUnderMouse();
    }

    public boolean isMoveWithArrowKeysSiriusMode() {
        return this.moveWithArrowKeysSiriusMode;
    }

    protected void setMoveWithArrowKeysSiriusMode(boolean moveWithArrowKeysSiriusMode) {
        this.moveWithArrowKeysSiriusMode = moveWithArrowKeysSiriusMode;
    }

    public void activate() {
        super.activate();
        this.siriusAccStepReset();
    }

    int siriusAccGetStep() {
        return this.accessibleStep;
    }

    void siriusAccStepIncrement() {
        if (this.accessibleBegin == -1L) {
            this.accessibleBegin = new Date().getTime();
            this.accessibleStep = 1;
        } else {
            this.accessibleStep = 4;
            long elapsed = new Date().getTime() - this.accessibleBegin;
            if (elapsed > 1000L) {
                this.accessibleStep = Math.min(16, (int)(elapsed / 150L));
            }
        }
    }

    void siriusAccStepReset() {
        this.accessibleBegin = -1L;
    }
}

